/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;

public class Java9DynamicJdk
implements IDynamicJdk {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> void report(Log issueLogger, Diagnostic<? extends T> diagnostic) {
        JavaFileObject oldSource = issueLogger.useSource((JavaFileObject)diagnostic.getSource());
        try {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    issueLogger.error(JCDiagnostic.DiagnosticFlag.MULTIPLE, new IssueReporter.Position(diagnostic), CompilerProperties.Errors.ProcMessager(diagnostic.getMessage(Locale.getDefault())));
                    return;
                }
                case WARNING: {
                    issueLogger.warning(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
                case MANDATORY_WARNING: {
                    issueLogger.mandatoryWarning(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
                case NOTE: 
                case OTHER: {
                    issueLogger.note(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
            }
            return;
        }
        finally {
            issueLogger.useSource(oldSource);
        }
    }

    @Override
    public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym) {
        return classSym.members().getSymbols();
    }

    @Override
    public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym, Filter<Symbol> filter) {
        return classSym.members().getSymbols(filter);
    }

    @Override
    public Iterable<Symbol> getMembersByName(Symbol.ClassSymbol classSym, Name call) {
        return classSym.members().getSymbolsByName(call);
    }

    @Override
    public Symbol.ClassSymbol getTypeElement(Context ctx, Object moduleCtx, String fqn) {
        if (moduleCtx instanceof JCTree.JCCompilationUnit) {
            Symbol.ModuleSymbol moduleSym = ((JCTree.JCCompilationUnit)moduleCtx).modle;
            return JavacElements.instance(ctx).getTypeElement(moduleSym, fqn);
        }
        if (moduleCtx instanceof JavaFileManager.Location) {
            try {
                String moduleName = JavacPlugin.instance().getJavaFileManager().inferModuleName((JavaFileManager.Location)moduleCtx);
                if (moduleName != null) {
                    Name name = Names.instance(ctx).fromString(moduleName);
                    Symbol.ModuleSymbol moduleSym = Modules.instance(ctx).getObservableModule(name);
                    return JavacElements.instance(ctx).getTypeElement(moduleSym, fqn);
                }
                moduleCtx = null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (moduleCtx == null) {
            return JavacElements.instance(ctx).getTypeElement(fqn);
        }
        throw new IllegalArgumentException("Unexpected moduleCtx type: " + moduleCtx.getClass().getTypeName());
    }

    @Override
    public Symbol.ClassSymbol getLoadedClass(Context ctx, String fqn) {
        Symtab symtab = Symtab.instance(ctx);
        Name flatName = Names.instance(ctx).fromString(fqn);
        for (Symbol.ModuleSymbol msym : Modules.instance(ctx).allModules()) {
            Symbol.ClassSymbol classSym = symtab.getClass(msym, flatName);
            if (classSym == null) continue;
            return classSym;
        }
        return null;
    }

    @Override
    public List<Type> getTargets(JCTree.JCLambda tree) {
        return tree.targets;
    }

    @Override
    public void setTargets(JCTree.JCLambda tree, List<Type> targets) {
        tree.targets = targets;
    }

    @Override
    public void logError(Log logger, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        logger.error(pos, new JCDiagnostic.Error("compiler", key, args));
    }
}

