/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import manifold.api.fs.IDirectory;
import manifold.api.host.IRuntimeManifoldHost;
import manifold.internal.host.SingleModuleManifoldHost;
import manifold.internal.runtime.IjPluginIntegration;
import manifold.internal.runtime.UrlClassLoaderWrapper;
import manifold.util.SourcePathUtil;
import manifold.util.concurrent.LockingLazyVar;

public class RuntimeManifoldHost
extends SingleModuleManifoldHost
implements IRuntimeManifoldHost {
    private static volatile LockingLazyVar<IRuntimeManifoldHost> HOST = LockingLazyVar.make(RuntimeManifoldHost::loadRuntimeManifoldHost);
    private List<File> _classpath;

    public static IRuntimeManifoldHost get() {
        return HOST.get();
    }

    public static IRuntimeManifoldHost clear() {
        return HOST.clear();
    }

    private static IRuntimeManifoldHost loadRuntimeManifoldHost() {
        try {
            IRuntimeManifoldHost host = RuntimeManifoldHost.loadRuntimeManifoldHost(RuntimeManifoldHost.class.getClassLoader());
            if (host == null) {
                host = RuntimeManifoldHost.loadRuntimeManifoldHost(Thread.currentThread().getContextClassLoader());
            }
            if (host != null) {
                return host;
            }
        }
        catch (ServiceConfigurationError e) {
            e.printStackTrace();
        }
        return new RuntimeManifoldHost();
    }

    private static IRuntimeManifoldHost loadRuntimeManifoldHost(ClassLoader cl) {
        ServiceLoader<IRuntimeManifoldHost> loader = ServiceLoader.load(IRuntimeManifoldHost.class, cl);
        Iterator<IRuntimeManifoldHost> iterator = loader.iterator();
        if (iterator.hasNext()) {
            IRuntimeManifoldHost host = iterator.next();
            if (iterator.hasNext()) {
                System.out.println("WARNING: Found multiple Manifold hosts, using first encountered: " + HOST.getClass().getName());
            }
            return host;
        }
        return null;
    }

    public static void bootstrap() {
        RuntimeManifoldHost.get().bootstrap(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean isBootstrapped() {
        return this.getSingleModule() != null;
    }

    @Override
    public void bootstrap(List<File> sourcepath, List<File> classpath) {
        if (this.isBootstrapped()) {
            return;
        }
        this.preBootstrap();
        this.init(sourcepath, classpath);
    }

    public void init(List<File> sourcepath, List<File> classpath) {
        ArrayList<File> combined = new ArrayList<File>();
        if (classpath != null) {
            combined.addAll(classpath);
        }
        combined.addAll(this.deriveClasspath());
        this.initDirectly(sourcepath, combined);
    }

    private List<File> deriveClasspath() {
        LinkedList<File> ll = new LinkedList<File>();
        ClassLoader loader = this.getActualClassLoader();
        while (loader != null) {
            ClassLoader parent;
            UrlClassLoaderWrapper wrap = UrlClassLoaderWrapper.wrap(loader);
            if (wrap != null) {
                for (URL url : wrap.getURLs()) {
                    try {
                        File file = new File(url.toURI());
                        if (!file.exists() || ll.contains(file)) continue;
                        ll.add(file);
                    }
                    catch (Exception exception) {}
                }
            }
            if ((parent = loader.getParent()) == null) {
                parent = IjPluginIntegration.getParent(loader);
            }
            loader = parent;
        }
        return ll;
    }

    protected void initDirectly(List<File> sourcepath, List<File> classpath) {
        classpath = new ArrayList<File>(classpath);
        RuntimeManifoldHost.removeDups(classpath);
        if (classpath.equals(this._classpath)) {
            return;
        }
        this._classpath = classpath;
        List<IDirectory> cp = this.createDefaultClassPath();
        cp.addAll(classpath.stream().map(file -> this.getFileSystem().getIDirectory((File)file)).collect(Collectors.toList()));
        RuntimeManifoldHost.removeDups(cp);
        List sp = sourcepath.stream().map(file -> this.getFileSystem().getIDirectory((File)file)).filter(e -> !SourcePathUtil.excludeFromSourcePath(e.toJavaFile().getAbsolutePath())).collect(Collectors.toList());
        ArrayList<IDirectory> all = new ArrayList<IDirectory>();
        for (IDirectory p : sp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        for (IDirectory p : cp) {
            if (all.contains(p) || SourcePathUtil.excludeFromSourcePath(p.toJavaFile().getAbsolutePath())) continue;
            all.add(p);
        }
        this.createSingleModule(cp, all, Collections.emptyList());
    }

    private List<IDirectory> createDefaultClassPath() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(RuntimeManifoldHost.removeQuotes(System.getProperty("java.class.path", "")));
        vals.add(System.getProperty("sun.boot.class.path", ""));
        vals.add(System.getProperty("java.ext.dirs", ""));
        return this.expand(vals);
    }

    private List<IDirectory> expand(List<String> paths) {
        LinkedHashSet<IDirectory> expanded = new LinkedHashSet<IDirectory>();
        for (String path : paths) {
            for (String pathElement : path.split(File.pathSeparator)) {
                if (pathElement.length() <= 0) continue;
                File filePath = new File(pathElement);
                IDirectory resource = this.getFileSystem().getIDirectory(filePath);
                expanded.add(resource);
            }
        }
        return new ArrayList<IDirectory>(expanded);
    }

    private static String removeQuotes(String classpath) {
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        return classpath;
    }

    private static void removeDups(List classpath) {
        for (int i = classpath.size() - 1; i >= 0; --i) {
            Object f = classpath.get(i);
            classpath.remove(i);
            if (classpath.contains(f)) continue;
            classpath.add(i, f);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }
}

