/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class BootstrapPlugin
implements Plugin,
TaskListener {
    private Context _ctx;
    private boolean _done;

    @Override
    public String getName() {
        return "BootstrapPlugin";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        this._ctx = ((BasicJavacTask)task).getContext();
        task.addTaskListener(this);
    }

    @Override
    public void started(TaskEvent te) {
        if (JreUtil.isJava8()) {
            return;
        }
        CompilationUnitTree compilationUnit = te.getCompilationUnit();
        if (!(compilationUnit instanceof JCTree.JCCompilationUnit)) {
            return;
        }
        if (this._done) {
            return;
        }
        this._done = true;
        BootstrapPlugin.openModule(this._ctx, "jdk.compiler");
    }

    @Override
    public void finished(TaskEvent e) {
    }

    public static void openModule(Context context, String moduleName) {
        try {
            Symbol moduleToOpen = (Symbol)ReflectUtil.method(Symtab.instance(context), "getModule", Name.class).invoke(Names.instance(context).fromString(moduleName));
            if (moduleToOpen == null) {
                return;
            }
            moduleToOpen.complete();
            Set rootModules = (Set)ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Modules"), "instance", Context.class).invokeStatic(context), "allModules").get();
            for (Symbol rootModule : rootModules) {
                rootModule.complete();
                List requires = (List)ReflectUtil.field(rootModule, "requires").get();
                ArrayList<Object> newRequires = new ArrayList<Object>(requires);
                Object addedRequires = ReflectUtil.constructor("com.sun.tools.javac.code.Directive$RequiresDirective", ReflectUtil.type("com.sun.tools.javac.code.Symbol$ModuleSymbol")).newInstance(moduleToOpen);
                newRequires.add(addedRequires);
                requires = List.from(newRequires);
                ReflectUtil.field(rootModule, "requires").set(requires);
                ArrayList<Object> exports = new ArrayList<Object>((Collection)ReflectUtil.field(moduleToOpen, "exports").get());
                for (Symbol pkg : (Iterable)ReflectUtil.field(moduleToOpen, "enclosedPackages").get()) {
                    if (!(pkg instanceof Symbol.PackageSymbol)) continue;
                    Object exp = ReflectUtil.constructor("com.sun.tools.javac.code.Directive$ExportsDirective", Symbol.PackageSymbol.class, List.class).newInstance(pkg, List.of(rootModule));
                    exports.add(exp);
                    ((Map)ReflectUtil.field(rootModule, "visiblePackages").get()).put(((Symbol.PackageSymbol)pkg).fullname, pkg);
                }
                ReflectUtil.field(moduleToOpen, "exports").set(List.from(exports));
                Set readModules = (Set)ReflectUtil.field(moduleToOpen, "readModules").get();
                readModules.add(rootModule);
                ReflectUtil.field(moduleToOpen, "readModules").set(readModules);
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to reflectively add-exports " + moduleName + "/* to root module[s], you must add the following argument to jave.exe:\n  --add-exports=" + moduleName + "/*=<root-module>\n");
            throw new RuntimeException(e);
        }
    }
}

