/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ITypeManifold;
import manifold.api.type.IncrementalCompile;
import manifold.api.type.Precompile;
import manifold.ext.ExtensionManifold;
import manifold.ext.ExtensionMethod;
import manifold.ext.RuntimeMethods;
import manifold.ext.StructuralTypeEraser;
import manifold.ext.TypeUtil;
import manifold.ext.api.Extension;
import manifold.ext.api.Self;
import manifold.ext.api.Structural;
import manifold.ext.api.This;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.TypeProcessor;
import manifold.util.ManClassUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class ExtensionTransformer
extends TreeTranslator {
    private final ExtensionManifold _sp;
    private final TypeProcessor _tp;
    private boolean _bridgeMethod;

    ExtensionTransformer(ExtensionManifold sp, TypeProcessor typeProcessor) {
        this._sp = sp;
        this._tp = typeProcessor;
    }

    public TypeProcessor getTypeProcessor() {
        return this._tp;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        super.visitIdent(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (tree.sym != null && TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            Tree parent = this._tp.getParent(tree);
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            tree = objIdent;
            tree.type = objectSym.type;
        }
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        super.visitLambda(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        tree.type = this.eraseStructureType(tree.type);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type target : IDynamicJdk.instance().getTargets(tree)) {
            types.add(this.eraseStructureType(target));
        }
        IDynamicJdk.instance().setTargets(tree, List.from(types));
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            Tree parent = this._tp.getParent(tree);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            this.result = objIdent;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        super.visitTypeCast(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            this.eraseCompilerGeneratedCast(tree);
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym)) {
            tree.expr = this.replaceCastExpression(tree.getExpression(), tree.type);
            tree.type = this.getObjectClass().type;
        }
        this.result = tree;
    }

    private void eraseCompilerGeneratedCast(JCTree.JCTypeCast tree) {
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym) && !this.isConstructProxyCall(tree.getExpression())) {
            tree.type = this.getObjectClass().type;
            TreeMaker make = this._tp.getTreeMaker();
            tree.clazz = make.Type(this.getObjectClass().type);
        }
    }

    private boolean isConstructProxyCall(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression meth = ((JCTree.JCMethodInvocation)expression).meth;
            return meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)meth).getIdentifier().toString().equals("constructProxy");
        }
        return expression instanceof JCTree.JCTypeCast && this.isConstructProxyCall(((JCTree.JCTypeCast)expression).getExpression());
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        super.visitApply(tree);
        Symbol.MethodSymbol method = this.findExtMethod(tree);
        this.eraseGenericStructuralVarargs(tree);
        if (this._tp.isGenerate()) {
            return;
        }
        if (method != null) {
            this.replaceExtCall(tree, method);
            this.result = tree;
        } else {
            this.result = this.isStructuralMethod(tree) ? this.replaceStructuralCall(tree) : tree;
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        super.visitAnnotation(tree);
        if (!Self.class.getTypeName().equals(tree.getAnnotationType().type.tsym.toString())) {
            return;
        }
        if (!this.isSelfInReturn(tree, tree)) {
            this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ALLOWED_HERE.get(new Object[0]));
        } else {
            this.verifySelfOnThis(tree, tree);
        }
    }

    private void verifySelfOnThis(JCTree annotated, JCTree.JCAnnotation selfAnno) {
        String fqn;
        if (annotated instanceof JCTree.JCAnnotatedType) {
            fqn = ((JCTree.JCAnnotatedType)annotated).getUnderlyingType().type.tsym.getQualifiedName().toString();
        } else if (annotated instanceof JCTree.JCMethodDecl) {
            fqn = ((JCTree.JCMethodDecl)annotated).getReturnType().type.tsym.getQualifiedName().toString();
        } else {
            return;
        }
        try {
            JCTree.JCClassDecl enclosingClass = this._tp.getClassDecl(annotated);
            if (!this.isDeclaringClassOrExtension(annotated, fqn, enclosingClass) && !fqn.equals("Array")) {
                this._tp.report(selfAnno, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ON_CORRECT_TYPE.get(fqn, enclosingClass.sym.getQualifiedName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isDeclaringClassOrExtension(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        if (enclosingClass.sym.getQualifiedName().toString().equals(fqn)) {
            return true;
        }
        return this.isOnExtensionMethod(annotated, fqn, enclosingClass);
    }

    private boolean isOnExtensionMethod(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        JCTree.JCMethodDecl declMethod;
        String extendedClassName;
        if (this.isExtensionClass(enclosingClass) && (extendedClassName = this.getExtendedClassName()) != null && extendedClassName.equals(fqn) && (declMethod = this.findDeclMethod(annotated)) != null) {
            java.util.List parameters = declMethod.getParameters();
            for (JCTree.JCVariableDecl param : parameters) {
                if (!this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) continue;
                return true;
            }
        }
        return false;
    }

    private JCTree.JCMethodDecl findDeclMethod(Tree annotated) {
        if (annotated == null) {
            return null;
        }
        if (annotated instanceof JCTree.JCMethodDecl) {
            return (JCTree.JCMethodDecl)annotated;
        }
        return this.findDeclMethod(this._tp.getParent(annotated));
    }

    private boolean isSelfInReturn(Tree tree, JCTree.JCAnnotation anno) {
        if (tree == null) {
            return false;
        }
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCMethodDecl && (tree == ((JCTree.JCMethodDecl)parent).getModifiers() || tree == ((JCTree.JCMethodDecl)parent).getReturnType() || ((List)((JCTree.JCMethodDecl)parent).getModifiers().getAnnotations()).contains(anno))) {
            return !((JCTree.JCMethodDecl)parent).getModifiers().getFlags().contains((Object)javax.lang.model.element.Modifier.STATIC) || this.isExtensionClass(this.getEnclosingClass(parent));
        }
        return this.isSelfInReturn(parent, anno);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        this.verifyExtensionInterfaces(tree);
        this.checkExtensionClassError(tree);
        this.precompileClasses(tree);
        this.incrementalCompileClasses(tree);
    }

    private void precompileClasses(JCTree.JCClassDecl tree) {
        HashMap<String, Set<String>> typeNames = new HashMap<String, Set<String>>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(Precompile.class.getCanonicalName())) continue;
            this.getTypesToCompile(anno, typeNames);
        }
        this.precompile(typeNames);
    }

    private void getTypesToCompile(JCTree.JCAnnotation precompileAnno, Map<String, Set<String>> typeNames) {
        Attribute.Compound attribute = precompileAnno.attribute;
        if (attribute == null) {
            return;
        }
        String typeManifoldClassName = null;
        String regex = ".*";
        for (Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("typeManifold")) {
                typeManifoldClassName = ((Attribute)pair.snd).getValue().toString();
                continue;
            }
            if (!((Name)argName).toString().equals("typeNames")) continue;
            regex = ((Attribute)pair.snd).getValue().toString();
        }
        Set regexes = typeNames.computeIfAbsent(typeManifoldClassName, tm -> new HashSet());
        regexes.add(regex);
    }

    private void precompile(Map<String, Set<String>> typeNames) {
        for (ITypeManifold tm : this._tp.getHost().getSingleModule().getTypeManifolds()) {
            for (Map.Entry<String, Set<String>> entry : typeNames.entrySet()) {
                String typeManifoldClassName = entry.getKey();
                if (!tm.getClass().getName().equals(typeManifoldClassName)) continue;
                Collection<String> namesToPrecompile = this.computeNamesToPrecompile(tm.getAllTypeNames(), entry.getValue());
                for (String fqn : namesToPrecompile) {
                    IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), fqn);
                }
            }
        }
    }

    private Collection<String> computeNamesToPrecompile(Collection<String> allTypeNames, Set<String> regexes) {
        HashSet<String> matchingTypes = new HashSet<String>();
        for (String fqn : allTypeNames) {
            if (!regexes.stream().anyMatch(fqn::matches)) continue;
            matchingTypes.add(fqn);
        }
        return matchingTypes;
    }

    private void incrementalCompileClasses(JCTree.JCClassDecl tree) {
        if (this._tp.isGenerate()) {
            return;
        }
        Set<Object> drivers = this.findDrivers(tree);
        this.addCompiledResourceTypeByFile(drivers, tree);
        this.incrementalCompile(drivers);
    }

    private Set<Object> findDrivers(JCTree.JCClassDecl tree) {
        HashSet<Object> drivers = new HashSet<Object>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(IncrementalCompile.class.getCanonicalName())) continue;
            this.getIncrementalCompileDrivers(anno, drivers);
        }
        this._tp.addDrivers(drivers);
        return this._tp.getDrivers();
    }

    private void getIncrementalCompileDrivers(JCTree.JCAnnotation anno, Set<Object> drivers) {
        Attribute.Compound attribute = anno.attribute;
        if (attribute == null) {
            return;
        }
        String fqnDriver = null;
        Integer driverId = null;
        for (Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("driverInstance")) {
                driverId = (int)((Integer)((Attribute)pair.snd).getValue());
                continue;
            }
            if (!((Name)argName).toString().equals("driverClass")) continue;
            fqnDriver = (String)((Attribute)pair.snd).getValue();
        }
        if (driverId != null) {
            Object driver = ReflectUtil.method(fqnDriver, "getInstance", Integer.TYPE).invokeStatic(driverId);
            drivers.add(driver);
        }
    }

    private void incrementalCompile(Set<Object> drivers) {
        for (Object driver : drivers) {
            Collection changedFiles = (Collection)ReflectUtil.method(driver, "getChangedFiles", new Class[0]).invoke(new Object[0]);
            if (changedFiles == null || changedFiles.isEmpty()) {
                return;
            }
            IManifoldHost host = this._tp.getHost();
            Set changes = changedFiles.stream().map(f -> host.getFileSystem().getIFile((File)f)).collect(Collectors.toSet());
            for (ITypeManifold tm : host.getSingleModule().getTypeManifolds()) {
                for (IFile file : changes) {
                    Set types = Arrays.stream(tm.getTypesForFile(file)).collect(Collectors.toSet());
                    if (types.size() <= 0) continue;
                    ReflectUtil.method(driver, "mapTypesToFile", Set.class, File.class).invoke(types, file.toJavaFile());
                    for (String fqn : types) {
                        Symbol.ClassSymbol classSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), fqn);
                        assert (classSym != null);
                        changedFiles.remove(file.toJavaFile());
                    }
                }
            }
        }
    }

    private void addCompiledResourceTypeByFile(Set<Object> drivers, JCTree.JCClassDecl tree) {
        if (tree.sym == null) {
            return;
        }
        Name qualifiedName = tree.sym.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        JavaFileObject sourcefile = tree.sym.sourcefile;
        if (!(sourcefile instanceof GeneratedJavaStubFileObject)) {
            return;
        }
        Set<IFile> resourceFiles = ((GeneratedJavaStubFileObject)sourcefile).getResourceFiles();
        for (IFile ifile : resourceFiles) {
            File file;
            try {
                file = ifile.toJavaFile();
            }
            catch (Exception e) {
                continue;
            }
            Map<File, Set<String>> typesCompiledByFile = this._tp.getTypesCompiledByFile();
            Set<String> types = typesCompiledByFile.get(file);
            if (types == null) {
                types = new ConcurrentHashSet<String>();
                typesCompiledByFile.put(file, types);
            }
            types.add(qualifiedName.toString());
        }
        this.addIndirectCompiledTypesToBuildForMapping(drivers);
    }

    private void addIndirectCompiledTypesToBuildForMapping(Set<Object> drivers) {
        Map<File, Set<String>> typesCompiledByFile = this._tp.getTypesCompiledByFile();
        if (typesCompiledByFile.isEmpty()) {
            return;
        }
        for (Object driver : drivers) {
            Map map = (Map)ReflectUtil.method(driver, "getTypesToFile", new Class[0]).invoke(new Object[0]);
            typesCompiledByFile.forEach((file, types) -> {
                Set existingTypes = (Set)map.get(file);
                if (existingTypes != null) {
                    existingTypes.addAll(types);
                } else {
                    map.put(file, types);
                }
            });
            typesCompiledByFile.clear();
        }
    }

    private void eraseExistingClassFiles(IFile file, Set<String> types) {
        for (String fqn : types) {
            String name;
            IDirectory parent = file.getParent();
            IFile classFile = parent.file((name = ManClassUtil.getShortClassName(fqn)) + ".class");
            if (!classFile.isJavaFile()) continue;
            try {
                classFile.delete();
                PathCache pathCache = this._tp.getHost().getSingleModule().getPathCache();
                pathCache.getExtensionCache("class").remove(fqn);
                for (IFile iFile : parent.listFiles()) {
                    if (!iFile.getName().startsWith(name + '$')) continue;
                    iFile.delete();
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    private void verifyExtensionInterfaces(JCTree.JCClassDecl tree) {
        if (!this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            return;
        }
        block0: for (JCTree.JCExpression iface : tree.getImplementsClause()) {
            Symbol.TypeSymbol ifaceSym = iface.type.tsym;
            if (ifaceSym == this._tp.getSymtab().objectType.tsym) continue;
            for (Attribute.Compound anno : ifaceSym.getAnnotationMirrors()) {
                if (!anno.type.toString().equals(Structural.class.getName())) continue;
                continue block0;
            }
            this._tp.report(iface, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_ONLY_STRUCTURAL_INTERFACE_ALLOWED_HERE.get(iface.toString()));
        }
    }

    private boolean shouldProcessForGeneration() {
        return this._bridgeMethod;
    }

    private boolean isBridgeMethod(JCTree.JCMethodDecl tree) {
        long modifiers = tree.getModifiers().flags;
        return (0x80000000L & modifiers) != 0L;
    }

    private Type eraseStructureType(Type type) {
        return (Type)new StructuralTypeEraser(this).visit(type);
    }

    private boolean isReceiver(JCTree tree) {
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)parent).getExpression() == tree;
        }
        return false;
    }

    Symbol.ClassSymbol getObjectClass() {
        Symtab symbols = Symtab.instance(this._tp.getContext());
        return (Symbol.ClassSymbol)symbols.objectType.tsym;
    }

    private void eraseGenericStructuralVarargs(JCTree.JCMethodInvocation tree) {
        if (tree.varargsElement instanceof Type.ClassType && TypeUtil.isStructuralInterface(this._tp, tree.varargsElement.tsym)) {
            tree.varargsElement = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (this.isBridgeMethod(tree)) {
            this._bridgeMethod = true;
        }
        try {
            super.visitMethodDef(tree);
        }
        finally {
            this._bridgeMethod = false;
        }
        if (this._tp.isGenerate()) {
            return;
        }
        if (tree.sym.owner.isAnonymous()) {
            JCTree.JCClassDecl anonymousClassDef = (JCTree.JCClassDecl)this._tp.getTreeUtil().getTree(tree.sym.owner);
            this._tp.preserveInnerClassForGenerationPhase(anonymousClassDef);
        }
        this.verifyExtensionMethod(tree);
        this.result = tree;
    }

    private void checkExtensionClassError(JCTree.JCClassDecl typeDecl) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin == null) {
            return;
        }
        if (!this.isExtensionClass(typeDecl)) {
            return;
        }
        String extendedFqn = this.getExtendedClassName();
        if (javacPlugin.getJavaInputFiles().stream().anyMatch(pair -> !(pair.getSecond() instanceof GeneratedJavaStubFileObject) && ((String)pair.getFirst()).equals(extendedFqn))) {
            this._tp.report(typeDecl, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_CANNOT_EXTEND_SOURCE_FILE.get(extendedFqn));
        }
    }

    private void verifyExtensionMethod(JCTree.JCMethodDecl tree) {
        if (!this.isExtensionClass(this._tp.getParent(tree))) {
            return;
        }
        String extendedClassName = this.getExtendedClassName();
        if (extendedClassName == null) {
            return;
        }
        boolean thisAnnoFound = false;
        java.util.List parameters = tree.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)parameters).get(i);
            long methodModifiers = tree.getModifiers().flags;
            if (this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) {
                Symbol.ClassSymbol extendClassSym;
                thisAnnoFound = true;
                if (i != 0) {
                    this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_THIS_FIRST.get(new Object[0]));
                }
                if (param.type.tsym instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)param.type.tsym).className().equals(extendedClassName) || (extendClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), extendedClassName)) == null || TypeUtil.isStructuralInterface(this._tp, extendClassSym)) continue;
                this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_TYPE_FOR_THIS.get(extendedClassName));
                continue;
            }
            if (i != 0 || !Modifier.isStatic((int)methodModifiers) || !Modifier.isPublic((int)methodModifiers) || !param.type.toString().equals(extendedClassName)) continue;
            this._tp.report(param, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_MAYBE_MISSING_THIS.get(new Object[0]));
        }
        if (thisAnnoFound || this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            long methodModifiers = tree.getModifiers().flags;
            if (!Modifier.isStatic((int)methodModifiers)) {
                this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_BE_STATIC.get(tree.getName()));
            }
            if (Modifier.isPrivate((int)methodModifiers)) {
                this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_NOT_BE_PRIVATE.get(tree.getName()));
            }
        }
    }

    private String getExtendedClassName() {
        String extendedClassName = this._tp.getCompilationUnit().getPackageName().toString();
        int iExt = extendedClassName.indexOf("extensions.");
        if (iExt < 0) {
            return null;
        }
        extendedClassName = extendedClassName.substring(iExt + "extensions".length() + 1);
        return extendedClassName;
    }

    private boolean isExtensionClass(Tree parent) {
        return parent instanceof JCTree.JCClassDecl && this.hasAnnotation((List<JCTree.JCAnnotation>)((JCTree.JCClassDecl)parent).getModifiers().getAnnotations(), Extension.class);
    }

    private JCTree.JCClassDecl getEnclosingClass(Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)tree;
        }
        return this.getEnclosingClass(this._tp.getParent(tree));
    }

    private boolean hasAnnotation(List<JCTree.JCAnnotation> annotations, Class<? extends Annotation> annoClass) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().type.toString().equals(annoClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private JCTree replaceStructuralCall(JCTree.JCMethodInvocation theCall) {
        JCTree.JCExpression methodSelect = theCall.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            Symtab symbols = this._tp.getSymtab();
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), RuntimeMethods.class.getName());
            Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(theCall.pos(), names.fromString("constructProxy"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(thisArg);
            JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, thisArg.type.tsym.getQualifiedName().toString() + ".class");
            ifaceClassExpr.type = symbols.classType;
            ifaceClassExpr.sym = symbols.classType.tsym;
            this.assignTypes(ifaceClassExpr.selected, thisArg.type.tsym);
            newArgs.add(ifaceClassExpr);
            JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, RuntimeMethods.class.getName() + ".constructProxy"), List.from(newArgs));
            makeProxyCall.setPos(theCall.pos);
            makeProxyCall.type = thisArg.type;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
            newMethodSelect.sym = makeInterfaceProxyMethod;
            newMethodSelect.type = makeInterfaceProxyMethod.type;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            JCTree.JCTypeCast cast = make.TypeCast(thisArg.type, (JCTree.JCExpression)makeProxyCall);
            cast.type = thisArg.type;
            ((JCTree.JCFieldAccess)theCall.meth).selected = cast;
            return theCall;
        }
        return null;
    }

    private JCTree.JCExpression replaceCastExpression(JCTree.JCExpression expression, Type type) {
        TreeMaker make = this._tp.getTreeMaker();
        Symtab symbols = this._tp.getSymtab();
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), RuntimeMethods.class.getName());
        Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(expression.pos(), names.fromString("assignStructuralIdentity"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
        JavacElements javacElems = this._tp.getElementUtil();
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(expression);
        JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, type.tsym.getQualifiedName().toString() + ".class");
        ifaceClassExpr.type = symbols.classType;
        ifaceClassExpr.sym = symbols.classType.tsym;
        this.assignTypes(ifaceClassExpr.selected, type.tsym);
        newArgs.add(ifaceClassExpr);
        JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, RuntimeMethods.class.getName() + ".assignStructuralIdentity"), List.from(newArgs));
        makeProxyCall.type = symbols.objectType;
        makeProxyCall.setPos(expression.pos);
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
        newMethodSelect.sym = makeInterfaceProxyMethod;
        newMethodSelect.type = makeInterfaceProxyMethod.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        JCTree.JCTypeCast castCall = make.TypeCast(symbols.objectType, (JCTree.JCExpression)makeProxyCall);
        castCall.type = symbols.objectType;
        return castCall;
    }

    private void replaceExtCall(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol method) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            m.selected = this.memberAccess(make, javacElems, extensionFqn);
            BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
            Symbol.ClassSymbol extensionClassSym = ClassSymbols.instance(this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionFqn).getFirst();
            this.assignTypes(m.selected, extensionClassSym);
            m.sym = method;
            m.type = method.type;
            if (!isStatic) {
                ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
                newArgs.add(0, thisArg);
                tree.args = List.from(newArgs);
            }
        }
    }

    private void assignTypes(JCTree.JCExpression m, Symbol symbol) {
        if (m instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
            this.assignTypes(fieldAccess.selected, symbol.owner);
        } else if (m instanceof JCTree.JCIdent) {
            JCTree.JCIdent fieldAccess = (JCTree.JCIdent)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
        }
    }

    private Symbol.MethodSymbol findExtMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree) {
            JCTree.JCFieldAccess meth = (JCTree.JCFieldAccess)tree.meth;
            if (meth.sym == null || !meth.sym.hasAnnotations()) {
                return null;
            }
            for (Attribute.Compound annotation : meth.sym.getAnnotationMirrors()) {
                if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
                String extensionClass = (String)((Attribute)annotation.values.get((int)0).snd).getValue();
                boolean isStatic = (Boolean)((Attribute)annotation.values.get((int)1).snd).getValue();
                BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
                manifold.util.Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> classSymbol = ClassSymbols.instance(this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionClass);
                if (classSymbol == null) continue;
                Symbol.ClassSymbol extClassSym = classSymbol.getFirst();
                if (extClassSym == null) {
                    return null;
                }
                Types types = Types.instance(javacTask.getContext());
                block1: for (Symbol elem : IDynamicJdk.instance().getMembers(extClassSym)) {
                    int thisOffset;
                    if (!(elem instanceof Symbol.MethodSymbol) || !elem.flatName().toString().equals(meth.sym.name.toString())) continue;
                    Symbol.MethodSymbol extMethodSym = (Symbol.MethodSymbol)elem;
                    java.util.List extParams = extMethodSym.getParameters();
                    java.util.List calledParams = ((Symbol.MethodSymbol)meth.sym).getParameters();
                    int n = thisOffset = isStatic ? 0 : 1;
                    if (((List)extParams).size() - thisOffset != ((List)calledParams).size()) continue;
                    for (int i = thisOffset; i < ((List)extParams).size(); ++i) {
                        Symbol.VarSymbol extParam = (Symbol.VarSymbol)((List)extParams).get(i);
                        Symbol.VarSymbol calledParam = (Symbol.VarSymbol)((List)calledParams).get(i - thisOffset);
                        if (!types.isSameType(types.erasure(extParam.type), types.erasure(calledParam.type))) continue block1;
                    }
                    return extMethodSym;
                }
            }
        }
        return null;
    }

    private boolean isStructuralMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            if (m.sym != null && !m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC)) {
                JCTree.JCExpression thisArg = m.selected;
                if (TypeUtil.isStructuralInterface(this._tp, thisArg.type.tsym)) {
                    return true;
                }
            }
        }
        return false;
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return this.memberAccess(make, javacElems, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }

    private Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return ExtensionTransformer.resolveMethod(pos, this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), name, qual, args);
    }

    private static Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Context ctx, JCTree.JCCompilationUnit compUnit, Name name, Type qual, List<Type> args) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = compUnit;
        return rs.resolveInternalMethod(pos, env, qual, name, args, null);
    }
}

