/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.host;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.darkj.DarkJavaTypeManifold;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.cache.PathCache;
import manifold.api.host.Dependency;
import manifold.api.host.IManifoldHost;
import manifold.api.image.ImageTypeManifold;
import manifold.api.properties.PropertiesTypeManifold;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.util.ServiceUtil;

public interface IModule {
    public IManifoldHost getHost();

    public String getName();

    public List<IDirectory> getSourcePath();

    public List<IDirectory> getJavaClassPath();

    public List<IDirectory> getOutputPath();

    public IDirectory[] getExcludedPath();

    public List<IDirectory> getCollectiveSourcePath();

    public List<IDirectory> getCollectiveJavaClassPath();

    default public IFileSystem getFileSystem() {
        return this.getHost().getFileSystem();
    }

    public List<Dependency> getDependencies();

    public PathCache getPathCache();

    public Set<ITypeManifold> getTypeManifolds();

    public JavaFileObject produceFile(String var1, JavaFileManager.Location var2, DiagnosticListener<JavaFileObject> var3);

    default public Set<ITypeManifold> findTypeManifoldsFor(String fqn, Predicate<ITypeManifold> ... predicates) {
        HashSet<ITypeManifold> tms = new HashSet<ITypeManifold>(2);
        Set<ITypeManifold> typeManifolds = this.getTypeManifolds();
        if (predicates != null && predicates.length > 0) {
            typeManifolds = typeManifolds.stream().filter(e -> Arrays.stream(predicates).anyMatch(p -> p.test(e))).collect(Collectors.toSet());
        }
        for (ITypeManifold tm : typeManifolds) {
            if (!tm.isType(fqn)) continue;
            tms.add(tm);
        }
        return tms;
    }

    default public Set<ITypeManifold> findTypeManifoldsFor(IFile file) {
        HashSet<ITypeManifold> tms = new HashSet<ITypeManifold>(2);
        for (ITypeManifold tm : this.getTypeManifolds()) {
            if (!tm.handlesFile(file)) continue;
            tms.add(tm);
        }
        return tms;
    }

    default public SortedSet<ITypeManifold> loadTypeManifolds() {
        TreeSet<ITypeManifold> typeManifolds = new TreeSet<ITypeManifold>(this.getTypeManifoldSorter());
        this.loadBuiltIn(typeManifolds);
        this.loadRegistered(typeManifolds);
        return typeManifolds;
    }

    default public Comparator<ITypeManifold> getTypeManifoldSorter() {
        return (tm1, tm2) -> tm1.getContributorKind() == ContributorKind.Supplemental ? 1 : -1;
    }

    default public void loadBuiltIn(Set<ITypeManifold> tms) {
        List<String> excludedTypeManifolds = this.getExcludedTypeManifolds();
        this.addBuiltIn(PropertiesTypeManifold.class, tms, excludedTypeManifolds);
        this.addBuiltIn(ImageTypeManifold.class, tms, excludedTypeManifolds);
        this.addBuiltIn(DarkJavaTypeManifold.class, tms, excludedTypeManifolds);
    }

    default public void addBuiltIn(Class<? extends ITypeManifold> tmClass, Set<ITypeManifold> tms, List<String> excludedTypeManifolds) {
        if (!excludedTypeManifolds.contains(tmClass.getTypeName())) {
            try {
                Constructor<? extends ITypeManifold> declaredConstructor = tmClass.getDeclaredConstructor(new Class[0]);
                if (declaredConstructor == null) {
                    throw new IllegalStateException("Type manifold class '" + tmClass.getTypeName() + "' does not define an accessible default constructor");
                }
                ITypeManifold tm = declaredConstructor.newInstance(new Object[0]);
                if (tm.accept(this)) {
                    tms.add(tm);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    default public List<String> getExcludedTypeManifolds() {
        String exclude = System.getProperty("manifold.exclude");
        if (exclude != null && !exclude.isEmpty()) {
            ArrayList<String> excluded = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
            while (tokenizer.hasMoreTokens()) {
                String excludedTypeManifold = tokenizer.nextToken().trim();
                excluded.add(excludedTypeManifold);
            }
            return excluded;
        }
        return Collections.emptyList();
    }

    default public void loadRegistered(Set<ITypeManifold> tms) {
        HashSet registeredTms = new HashSet();
        ServiceUtil.loadRegisteredServices(registeredTms, ITypeManifold.class, this.getClass().getClassLoader());
        List<String> excludedTypeManifolds = this.getExcludedTypeManifolds();
        tms.addAll(registeredTms.stream().filter(tm -> tm.accept(this) && !excludedTypeManifolds.contains(tm.getClass().getTypeName())).collect(Collectors.toSet()));
    }
}

