/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;

public class Stack<T>
implements Iterable<T> {
    private final ArrayList<T> _list;

    public Stack() {
        this._list = new ArrayList();
    }

    public Stack(Stack<T> source) {
        this._list = new ArrayList<T>(source._list);
    }

    public Stack(ArrayList<T> list) {
        this._list = list;
    }

    public boolean push(T item) {
        return this._list.add(item);
    }

    public void insert(T item, int iPos) {
        this._list.add(iPos, item);
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this._list.remove(this.size() - 1);
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this._list.get(this.size() - 1);
    }

    public T getBase() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this._list.get(0);
    }

    public boolean contains(T obj) {
        return this._list.contains(obj);
    }

    @Override
    public Iterator<T> iterator() {
        return this._list.iterator();
    }

    public T get(int i) {
        return this._list.get(i);
    }

    public int indexOf(T o) {
        return this._list.indexOf(o);
    }

    public void clear() {
        this._list.clear();
    }

    public int size() {
        return this._list.size();
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stack stack = (Stack)o;
        return this._list.equals(stack._list);
    }

    public int hashCode() {
        return this._list.hashCode();
    }

    public List<T> toList() {
        return new ArrayList<T>(this._list);
    }
}

