/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import manifold.js.parser.Token;
import manifold.js.parser.tree.ProgramNode;

public class Node {
    private String _name;
    private Token _start;
    private Token _end;
    private List<Node> _children;
    private Node _parent;

    public Node(String name) {
        this._name = name;
        this._children = new ArrayList<Node>();
    }

    public Node getParent() {
        return this._parent;
    }

    public ProgramNode getProgramNode() {
        return this._parent.getProgramNode();
    }

    public List<Node> getChildren() {
        return this._children;
    }

    public <T> List<T> getChildren(Class<T> clazz) {
        LinkedList<Node> lst = new LinkedList<Node>();
        for (Node child : this._children) {
            if (!child.getClass().equals(clazz)) continue;
            lst.add(child);
        }
        return lst;
    }

    public <T extends Node> T getFirstChild(Class<T> clazz) {
        for (Node child : this._children) {
            if (!child.getClass().equals(clazz)) continue;
            return (T)child;
        }
        return null;
    }

    public void addChild(Node n) {
        this._children.add(n);
        n._parent = this;
    }

    public Node withChild(Node n) {
        this._children.add(n);
        n._parent = this;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public void setTokens(Token start, Token end) {
        this._start = start;
        this._end = end;
    }

    public Token getStart() {
        return this._start;
    }

    public Token getEnd() {
        return this._end;
    }

    public String genCode() {
        StringBuilder childCode = new StringBuilder();
        for (Node node : this.getChildren()) {
            childCode.append(node.genCode());
        }
        return childCode.toString();
    }

    public String toString() {
        return this.getName();
    }
}

