/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import manifold.util.ReflectUtil;
import manifold.util.StreamUtil;

class IjPluginIntegration {
    IjPluginIntegration() {
    }

    static void addUrlToIntelliJPluginClassLoader(ClassLoader cl, URL url) {
        if (cl.getClass().getTypeName().equals("com.intellij.ide.plugins.cl.PluginClassLoader")) {
            try {
                Object classPath = ReflectUtil.method(cl, "getClassPath", new Class[0]).invoke(new Object[0]);
                ReflectUtil.field(classPath, "myCanUseCache").set(false);
                Object urlLoader = IjPluginIntegration.makeUrlLoader(cl, url);
                ReflectUtil.method(ReflectUtil.field(classPath, "myLoaders").get(), "add", Object.class).invoke(urlLoader);
                ReflectUtil.method(ReflectUtil.field(classPath, "myLoadersMap").get(), "put", Object.class, Object.class).invoke(url, urlLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Object makeUrlLoader(ClassLoader cl, URL url) throws IOException {
        Class cls = IjPluginIntegration.defineClass(cl, "/com/intellij/util/lang/UrlLoader.class");
        IjPluginIntegration.defineClass(cl, "/com/intellij/util/lang/UrlLoader$JavaResource.class");
        IjPluginIntegration.defineClass(cl, "/com/intellij/util/lang/UrlLoader$IjResource.class");
        return ReflectUtil.constructor(cls, URL.class, Integer.TYPE).newInstance(url, 0);
    }

    private static Class defineClass(ClassLoader cl, String fqn) throws IOException {
        InputStream stream = cl.getResourceAsStream(fqn);
        byte[] bytes = StreamUtil.getContent(stream);
        ClassLoader parent = (ClassLoader)Array.get(ReflectUtil.field(cl, "myParents").get(), 0);
        return (Class)ReflectUtil.method(parent, "defineClass", byte[].class, Integer.TYPE, Integer.TYPE).invoke(bytes, 0, bytes.length);
    }
}

