/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IResource;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.internal.javac.IJavaParser;
import manifold.internal.javac.InMemoryClassJavaFileObject;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.internal.javac.StringJavaFileObject;
import manifold.internal.javac.TypeProcessor;
import manifold.util.JreUtil;
import manifold.util.Pair;
import manifold.util.SourcePathUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class JavaParser
implements IJavaParser {
    private final IManifoldHost _host;
    private JavaCompiler _javac;
    private JavaFileManager _fileManager;
    private ManifoldJavaFileManager _mfm;
    private LocklessLazyVar<JavaCompiler> _parserJavac;

    public JavaParser(IManifoldHost host) {
        this._host = host;
        this._parserJavac = LocklessLazyVar.make(JavacTool::create);
    }

    private void init() {
        if (this._javac == null) {
            this._javac = JavacTool.create();
            JavacPlugin javacHook = JavacPlugin.instance();
            if (javacHook != null && !JreUtil.isJava9Modular_compiler(javacHook.getContext())) {
                this._fileManager = javacHook.getJavaFileManager();
                this._mfm = javacHook.getManifoldFileManager();
            } else {
                this._fileManager = this._javac.getStandardFileManager(null, null, Charset.forName("UTF-8"));
                try {
                    IModule globalModule = this.getHost().getSingleModule();
                    if (globalModule != null) {
                        ((StandardJavaFileManager)this._fileManager).setLocation(StandardLocation.SOURCE_PATH, globalModule.getSourcePath().stream().map(IResource::toJavaFile).filter(f -> !SourcePathUtil.excludeFromSourcePath(f.getAbsolutePath())).collect(Collectors.toList()));
                        ((StandardJavaFileManager)this._fileManager).setLocation(StandardLocation.CLASS_PATH, globalModule.getJavaClassPath().stream().map(IResource::toJavaFile).filter(f -> !SourcePathUtil.excludeFromTestPath(f.getAbsolutePath())).collect(Collectors.toList()));
                    }
                    this._mfm = new ManifoldJavaFileManager(this.getHost(), this._fileManager, null, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public boolean parseType(String fqn, java.util.List<CompilationUnitTree> trees, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        Pair<JavaFileObject, String> pair = this.findJavaSource(fqn, errorHandler);
        if (pair == null) {
            return false;
        }
        StringWriter errors = new StringWriter();
        JavacTask javacTask = (JavacTask)this._javac.getTask(errors, this._mfm, errorHandler, Collections.singletonList("-proc:none"), null, Collections.singletonList(pair.getFirst()));
        try {
            this.initTypeProcessing(javacTask, Collections.singleton(fqn));
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            for (CompilationUnitTree compilationUnitTree : iterable) {
                trees.add(compilationUnitTree);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean parseText(String src, java.util.List<CompilationUnitTree> trees, Consumer<SourcePositions> sourcePositions, Consumer<DocTrees> docTrees, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        ArrayList<StringJavaFileObject> javaStringObjects = new ArrayList<StringJavaFileObject>();
        javaStringObjects.add(new StringJavaFileObject("sample", src));
        StringWriter errors = new StringWriter();
        JavacTask javacTask = (JavacTask)this._javac.getTask(errors, this._mfm, errorHandler, Collections.singletonList("-proc:none"), null, javaStringObjects);
        try {
            this.initTypeProcessing(javacTask, Collections.singleton("sample"));
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            if (errors.getBuffer().length() > 0) {
                System.err.println(errors.getBuffer());
            }
            for (CompilationUnitTree compilationUnitTree : iterable) {
                trees.add(compilationUnitTree);
            }
            if (sourcePositions != null) {
                sourcePositions.accept(Trees.instance(javacTask).getSourcePositions());
            }
            if (docTrees != null) {
                docTrees.accept(DocTrees.instance(javacTask));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JCTree.JCExpression parseExpr(String expr, DiagnosticCollector<JavaFileObject> errorHandler) {
        ArrayList<StringJavaFileObject> javaStringObjects = new ArrayList<StringJavaFileObject>();
        String src = "class Sample {\n  Object foo = " + expr + ";\n}\n";
        javaStringObjects.add(new StringJavaFileObject("sample", src));
        StringWriter errors = new StringWriter();
        JavacTask javacTask = (JavacTask)Objects.requireNonNull(this._parserJavac.get()).getTask(errors, null, errorHandler, Collections.singletonList("-proc:none"), null, javaStringObjects);
        try {
            this.initTypeProcessing(javacTask, Collections.singleton("sample"));
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            if (errors.getBuffer().length() > 0) {
                System.err.println(errors.getBuffer());
            }
            for (CompilationUnitTree compilationUnitTree : iterable) {
                java.util.List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                if (typeDecls.isEmpty()) continue;
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)typeDecls.get(0);
                JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)((List)tree.getMembers()).get(0);
                return field.getInitializer();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InMemoryClassJavaFileObject compile(String fqn, Iterable<String> options, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        InMemoryClassJavaFileObject compiledClass = this._mfm.findCompiledFile(fqn);
        if (compiledClass != null) {
            return compiledClass;
        }
        Pair<JavaFileObject, String> fileObj = this.findJavaSource(fqn, errorHandler);
        if (fileObj == null) {
            return null;
        }
        int check = this._mfm.pushRuntimeMode();
        try {
            StringWriter errors = new StringWriter();
            JavacTask javacTask = (JavacTask)this._javac.getTask(errors, this._mfm, errorHandler, options, null, Collections.singletonList(fileObj.getFirst()));
            this.initTypeProcessing(javacTask, Collections.singleton(fqn));
            javacTask.call();
            InMemoryClassJavaFileObject inMemoryClassJavaFileObject = this._mfm.findCompiledFile(fileObj.getSecond());
            return inMemoryClassJavaFileObject;
        }
        finally {
            this._mfm.popRuntimeMode(check);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InMemoryClassJavaFileObject compile(JavaFileObject jfo, String fqn, Iterable<String> options, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        int check = this._mfm.pushRuntimeMode();
        try {
            StringWriter errors = new StringWriter();
            JavacTask javacTask = (JavacTask)this._javac.getTask(errors, this._mfm, errorHandler, options, null, Collections.singletonList(jfo));
            this.initTypeProcessing(javacTask, Collections.singleton(fqn));
            javacTask.call();
            InMemoryClassJavaFileObject inMemoryClassJavaFileObject = this._mfm.findCompiledFile(fqn);
            return inMemoryClassJavaFileObject;
        }
        finally {
            this._mfm.popRuntimeMode(check);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<InMemoryClassJavaFileObject> compile(Collection<JavaFileObject> files, Iterable<String> options, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        int check = this._mfm.pushRuntimeMode();
        try {
            StringWriter errors = new StringWriter();
            JavacTask javacTask = (JavacTask)this._javac.getTask(errors, this._mfm, errorHandler, options, null, files);
            this.initTypeProcessing(javacTask, files.stream().map(this::getTypeForFile).collect(Collectors.toSet()));
            javacTask.call();
            Collection<InMemoryClassJavaFileObject> collection = this._mfm.getCompiledFiles();
            return collection;
        }
        finally {
            this._mfm.popRuntimeMode(check);
        }
    }

    private String getTypeForFile(JavaFileObject file) {
        URI uri = file.toUri();
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            return this.makeTypeName(file.getName());
        }
        IFile iFile = this.getHost().getFileSystem().getIFile(new File(file.getName()));
        java.util.List<IDirectory> sourcePath = this.getHost().getSingleModule().getSourcePath();
        for (IDirectory dir : sourcePath) {
            if (!iFile.isDescendantOf(dir)) continue;
            return this.makeTypeName(iFile.getName().substring(dir.getName().length()));
        }
        throw new IllegalStateException("Could not infer type name from: " + file.getName());
    }

    private String makeTypeName(String path) {
        return path.replace('/', '.').replace(File.separatorChar, '.').substring(0, path.lastIndexOf(46));
    }

    private void initTypeProcessing(JavacTask javacTask, Set<String> types) {
        TypeProcessor typeProcessor = new TypeProcessor(this.getHost(), javacTask);
        typeProcessor.addTypesToProcess(types);
    }

    @Override
    public Pair<JavaFileObject, String> findJavaSource(String fqn, DiagnosticListener<JavaFileObject> errorHandler) {
        this.init();
        if (this._mfm == null) {
            return null;
        }
        JavaFileObject fileObj = this._mfm.getSourceFileForInput(StandardLocation.SOURCE_PATH, fqn, JavaFileObject.Kind.SOURCE, errorHandler);
        if (fileObj == null) {
            int iDot = fqn.lastIndexOf(46);
            if (iDot > 0) {
                String enclosingFqn = fqn.substring(0, iDot);
                return this.findJavaSource(enclosingFqn, errorHandler);
            }
            return null;
        }
        return new Pair<JavaFileObject, String>(fileObj, fqn);
    }

    public BasicJavacTask getJavacTask() {
        this.init();
        StringWriter errors = new StringWriter();
        return (BasicJavacTask)this._javac.getTask(errors, this._mfm, null, Arrays.asList("-proc:none", "-source", "8"), null, null);
    }

    @Override
    public void clear() {
        this._javac = null;
        this._parserJavac.clear();
        try {
            if (this._fileManager != null) {
                this._fileManager.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

