/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.api.host.IManifoldHost;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.ParentTreePathScanner;
import manifold.util.JavacDiagnostic;

public abstract class CompiledTypeProcessor
implements TaskListener {
    private final IManifoldHost _host;
    private final JavacTask _javacTask;
    private CompilationUnitTree _compilationUnit;
    private final Types _types;
    private final Map<String, Boolean> _typesToProcess;
    private ParentMap _parents;
    private final IssueReporter<JavaFileObject> _issueReporter;
    private Map<String, JCTree.JCClassDecl> _innerClassForGeneration;
    private JCTree.JCClassDecl _tree;
    private boolean _generate;

    CompiledTypeProcessor(IManifoldHost host, JavacTask javacTask) {
        this._host = host;
        this._javacTask = javacTask;
        javacTask.addTaskListener(this);
        Context context = ((BasicJavacTask)javacTask).getContext();
        JavaCompiler compiler = JavaCompiler.instance(context);
        compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.max(compiler.shouldStopPolicyIfNoError, CompileStates.CompileState.FLOW);
        this._issueReporter = new IssueReporter(Log.instance(context));
        this._types = Types.instance(context);
        this._typesToProcess = new HashMap<String, Boolean>();
        this._innerClassForGeneration = new HashMap<String, JCTree.JCClassDecl>();
        this._parents = new ParentMap();
    }

    public abstract void process(TypeElement var1, IssueReporter<JavaFileObject> var2);

    public Context getContext() {
        return ((BasicJavacTask)this.getJavacTask()).getContext();
    }

    public IManifoldHost getHost() {
        return this._host;
    }

    public JavacTask getJavacTask() {
        return this._javacTask;
    }

    public JCTree.JCClassDecl getTree() {
        return this._tree;
    }

    public boolean isGenerate() {
        return this._generate;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this._compilationUnit;
    }

    public Types getTypes() {
        return this._types;
    }

    public JavacElements getElementUtil() {
        return JavacElements.instance(this.getContext());
    }

    public Trees getTreeUtil() {
        return Trees.instance(this.getJavacTask());
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.getContext());
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.getContext());
    }

    public Tree getParent(Tree node) {
        return this._parents.getParent(node);
    }

    public JCTree.JCClassDecl getClassDecl(Tree node) {
        if (node == null || node instanceof JCTree.JCCompilationUnit) {
            return null;
        }
        if (node instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)node;
        }
        return this.getClassDecl(this.getParent(node));
    }

    public JavaFileObject getFile(Tree node) {
        JCTree.JCClassDecl classDecl = this.getClassDecl(node);
        return classDecl == null ? null : classDecl.sym.sourcefile;
    }

    public void report(JCTree tree, Diagnostic.Kind kind, String msg) {
        IssueReporter<JavaFileObject> reporter = new IssueReporter<JavaFileObject>(Log.instance(this.getContext()));
        JavaFileObject file = this.getFile(tree);
        reporter.report(new JavacDiagnostic(file, kind, tree.getStartPosition(), 0L, 0L, msg));
    }

    public boolean addTypesToProcess(RoundEnvironment roundEnv) {
        for (TypeElement elem : ElementFilter.typesIn(roundEnv.getRootElements())) {
            this._typesToProcess.put(elem.getQualifiedName().toString(), false);
        }
        return false;
    }

    public void addTypesToProcess(Set<String> types) {
        types.forEach(e -> this._typesToProcess.put((String)e, false));
    }

    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        TypeElement elem = e.getTypeElement();
        if (elem instanceof Symbol.ClassSymbol) {
            this._tree = this._typesToProcess.containsKey(elem.getQualifiedName().toString()) ? this.findTopLevel((Symbol.ClassSymbol)elem, e.getCompilationUnit().getTypeDecls()) : this._innerClassForGeneration.get(((Symbol.ClassSymbol)elem).flatName().toString());
            if (this._tree != null) {
                this._compilationUnit = e.getCompilationUnit();
                this._generate = true;
                this.process(elem, this._issueReporter);
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        this._generate = false;
        String fqn = e.getTypeElement().getQualifiedName().toString();
        Boolean visited = this._typesToProcess.get(fqn);
        if (visited == Boolean.TRUE) {
            return;
        }
        if (fqn.isEmpty()) {
            return;
        }
        this._typesToProcess.put(fqn, true);
        this._compilationUnit = e.getCompilationUnit();
        TypeElement elem = e.getTypeElement();
        this._tree = (JCTree.JCClassDecl)this.getTreeUtil().getTree(elem);
        this.preserveInnerClassesForGeneration(this._tree);
        this.process(elem, this._issueReporter);
    }

    private JCTree.JCClassDecl findTopLevel(Symbol.ClassSymbol type, List<? extends Tree> typeDecls) {
        for (Tree tree : typeDecls) {
            if (!(tree instanceof JCTree.JCClassDecl) || ((JCTree.JCClassDecl)tree).sym != type) continue;
            return (JCTree.JCClassDecl)tree;
        }
        return null;
    }

    private void preserveInnerClassesForGeneration(JCTree.JCClassDecl tree) {
        for (JCTree def : tree.defs) {
            if (!(def instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)def;
            this.preserveInnerClassForGenerationPhase(classDecl);
            this.preserveInnerClassesForGeneration(classDecl);
        }
    }

    public void preserveInnerClassForGenerationPhase(JCTree.JCClassDecl def) {
        this._innerClassForGeneration.put(def.sym.flatName().toString(), def);
    }

    private boolean isNested(Element elem) {
        if (!(elem instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElem = (TypeElement)elem;
        String fqn = typeElem.getQualifiedName().toString();
        if (this._typesToProcess.containsKey(fqn)) {
            return true;
        }
        for (String t : this._typesToProcess.keySet()) {
            if (!t.contains(fqn + '.')) continue;
            return true;
        }
        return this.isNested(typeElem.getEnclosingElement());
    }

    private boolean isOuter(String fqn) {
        if (fqn.isEmpty()) {
            return false;
        }
        for (String t : this._typesToProcess.keySet()) {
            if (!t.contains(fqn + '.')) continue;
            return true;
        }
        return false;
    }

    private class ParentMap {
        private Map<CompilationUnitTree, Map<Tree, Tree>> _parents = new HashMap<CompilationUnitTree, Map<Tree, Tree>>();

        private ParentMap() {
        }

        private Tree getParent(Tree child) {
            Map parents = this._parents.computeIfAbsent(CompiledTypeProcessor.this._compilationUnit, cu -> {
                HashMap<Tree, Tree> map = new HashMap<Tree, Tree>();
                new ParentTreePathScanner(map).scan((Tree)cu, null);
                return map;
            });
            return (Tree)parents.get(child);
        }
    }

    private class AnonymousClassListener
    implements Scope.ScopeListener {
        JCTree.JCClassDecl _tree;

        public AnonymousClassListener(JCTree.JCClassDecl tree) {
            this._tree = tree;
        }

        @Override
        public void symbolAdded(Symbol sym, Scope s) {
            if (sym instanceof Symbol.ClassSymbol && sym.isAnonymous()) {
                System.out.println(sym.getQualifiedName());
            }
        }

        @Override
        public void symbolRemoved(Symbol sym, Scope s) {
        }
    }
}

