/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;

public class AbstractSrcMethod<T extends AbstractSrcMethod<T>>
extends SrcStatement<T> {
    private SrcType _returns;
    private SrcStatementBlock _body;
    private List<SrcType> _typeVars = Collections.emptyList();
    private List<SrcType> _throwTypes = Collections.emptyList();
    private boolean _isConstructor;

    public AbstractSrcMethod(SrcClass srcClass) {
        super(srcClass);
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this._isConstructor = isConstructor;
    }

    public T returns(SrcType returns) {
        this._returns = returns;
        return (T)this;
    }

    public T returns(Class returns) {
        this._returns = new SrcType(returns);
        return (T)this;
    }

    public T returns(String returns) {
        this._returns = new SrcType(returns);
        return (T)this;
    }

    public void addTypeVar(SrcType typeVar) {
        if (this._typeVars.isEmpty()) {
            this._typeVars = new ArrayList<SrcType>();
        }
        this._typeVars.add(typeVar);
    }

    public void addThrowType(SrcType type) {
        if (this._throwTypes.isEmpty()) {
            this._throwTypes = new ArrayList<SrcType>();
        }
        this._throwTypes.add(type);
    }

    public T body(SrcStatementBlock body) {
        this._body = body;
        return (T)this;
    }

    public SrcType getReturnType() {
        return this._returns;
    }

    public List<SrcType> getTypeVariables() {
        return this._typeVars;
    }

    public List<SrcType> getThrowTypes() {
        return this._throwTypes;
    }

    private String renderThrowTypes(StringBuilder sb) {
        if (this._throwTypes.size() > 0) {
            sb.append(" throws ");
            for (int i = 0; i < this._throwTypes.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this._throwTypes.get(i));
            }
        }
        return "";
    }

    public String signature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSimpleName()).append(this.renderParameters(sb, true));
        return sb.toString();
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, this.getModifiers() & 0xFFFFFFFFFFFFFF7FL, (this.getModifiers() & 0x80000000000L) != 0L, 1);
        this.renderTypeVars(this._typeVars, sb);
        if (this._returns != null) {
            this._returns.render(sb, indent).append(' ').append(this.getSimpleName()).append(this.renderParameters(sb)).append(this.renderThrowTypes(sb));
        } else if (this.isConstructor()) {
            sb.append(this.getOwner().getSimpleName()).append(this.renderParameters(sb)).append(this.renderThrowTypes(sb));
        }
        if (this.isAbstractMethod()) {
            sb.append(";\n");
        } else if (this._body != null) {
            this._body.render(sb, indent);
        } else {
            throw new IllegalStateException("Body of method is null");
        }
        return sb;
    }

    private boolean isAbstractMethod() {
        return Modifier.isAbstract((int)this.getModifiers()) || this.isNonDefaultNonStaticInterfaceMethod();
    }

    private boolean isNonDefaultNonStaticInterfaceMethod() {
        return this.getOwner() instanceof SrcClass && ((SrcClass)this.getOwner()).isInterface() && (this.getModifiers() & 0x80000000000L) == 0L && (this.getModifiers() & 8L) == 0L;
    }
}

