/*
 * Decompiled with CFR 0.152.
 */
package manifold.util.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class FqnCacheNode<K> {
    private final String _name;
    private final FqnCacheNode<K> _parent;
    private K _userData;
    private Map<String, FqnCacheNode<K>> _children;

    public FqnCacheNode(String text, FqnCacheNode<K> parent) {
        this._name = text;
        this._parent = parent;
    }

    public final FqnCacheNode<K> getChild(String segment) {
        if (this._children != null) {
            return this._children.get(segment);
        }
        return null;
    }

    public FqnCacheNode<K> getParent() {
        return this._parent;
    }

    public void clear() {
        this._children = null;
    }

    public FqnCacheNode<K> getOrCreateChild(String segment) {
        FqnCacheNode<K> node;
        if (this._children == null) {
            this._children = new ConcurrentHashMap<String, FqnCacheNode<K>>(2);
        }
        if ((node = this._children.get(segment)) == null) {
            node = new FqnCacheNode<K>(segment, this);
            this._children.put(segment, node);
        }
        return node;
    }

    public final void delete() {
        super.deleteChild(this);
    }

    private void deleteChild(FqnCacheNode<K> child) {
        if (this._children != null) {
            FqnCacheNode<Object> removed = this._children.remove(child._name);
            if (removed != null) {
                removed.setUserData(null);
            }
            if (this._children.isEmpty()) {
                this._children = null;
            }
        }
    }

    public final K getUserData() {
        return this._userData;
    }

    public final void setUserData(K userData) {
        K prev = this._userData;
        this._userData = userData;
        this.updateReverseMap(this, prev);
    }

    protected void updateReverseMap(FqnCacheNode<K> node, K prev) {
        if (this._parent != null) {
            this._parent.updateReverseMap(node, prev);
        }
    }

    public final boolean isLeaf() {
        return this._children == null || this._children.isEmpty();
    }

    public void collectNames(Set<String> names, String s) {
        if (this._children != null) {
            for (FqnCacheNode<K> child : this._children.values()) {
                String path;
                String string = path = s.length() == 0 ? child._name : s + super.separator() + child._name;
                if (child.isLeaf()) {
                    names.add(path);
                    continue;
                }
                child.collectNames(names, path);
            }
        }
    }

    public final Collection<FqnCacheNode<K>> getChildren() {
        if (this._children != null) {
            return this._children.values();
        }
        return Collections.emptySet();
    }

    public final boolean visitDepthFirst(Predicate<K> visitor) {
        if (this._children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this._children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                if (fqnCacheNode.visitDepthFirst(visitor)) continue;
                return false;
            }
        }
        return visitor.test(this.getUserData());
    }

    public final boolean visitNodeDepthFirst(Predicate<FqnCacheNode> visitor) {
        if (this._children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this._children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                if (fqnCacheNode.visitNodeDepthFirst(visitor)) continue;
                return false;
            }
        }
        return visitor.test(this);
    }

    public final boolean visitBreadthFirst(Predicate<K> visitor) {
        if (!visitor.test(this.getUserData())) {
            return false;
        }
        if (this._children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this._children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                fqnCacheNode.visitBreadthFirst(visitor);
            }
        }
        return true;
    }

    public final boolean visitNodeBreadthFirst(Predicate<FqnCacheNode> visitor) {
        if (!visitor.test(this)) {
            return false;
        }
        if (this._children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this._children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                fqnCacheNode.visitNodeBreadthFirst(visitor);
            }
        }
        return true;
    }

    public final String getName() {
        return this._name;
    }

    public final String getFqn() {
        StringBuilder sb = new StringBuilder();
        FqnCacheNode<K> node = this;
        while (node != null && node.isVisible()) {
            String str = node._name + (sb.length() == 0 ? "" : this.separator());
            sb.insert(0, str);
            node = node._parent;
        }
        return sb.toString();
    }

    private String separator() {
        char c = this._name.charAt(0);
        return c == '[' || c == '<' ? "" : ".";
    }

    private boolean isVisible() {
        return this.getParent() != null || this.isRootVisible();
    }

    public boolean isRootVisible() {
        return false;
    }

    public String toString() {
        return this._name;
    }
}

