/*
 * Decompiled with CFR 0.152.
 */
package manifold.util.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import manifold.util.DynamicArray;
import manifold.util.cache.FqnCacheNode;
import manifold.util.cache.IFqnCache;
import manifold.util.cache.StringCache;
import manifold.util.cache.TypeSystemAwareCache;
import manifold.util.concurrent.Cache;

public class FqnCache<T>
extends FqnCacheNode<T>
implements IFqnCache<T> {
    private static final TypeSystemAwareCache<String, String[]> PARTS_CACHE = TypeSystemAwareCache.make("Fqn Parts Cache", 10000, e -> FqnCache.split(e, null));
    private final Validator _validator;
    private final Cache<String, String[]> _validatorCache;
    private final boolean _rootVisible;

    public FqnCache() {
        this("root", false, null);
    }

    public FqnCache(String name, boolean rootVisible, Validator validator) {
        super(name, null);
        this._rootVisible = rootVisible;
        this._validator = validator;
        this._validatorCache = validator == null ? null : Cache.make("FqnCache Parts", 10000, e -> FqnCache.split(e, this._validator));
    }

    @Override
    public boolean isRootVisible() {
        return this._rootVisible;
    }

    @Override
    public FqnCacheNode<T> getNode(String fqn) {
        String part;
        FqnCacheNode n = this;
        String[] stringArray = this.getParts(fqn, this._validator);
        int n2 = stringArray.length;
        for (int i = 0; i < n2 && (n = n.getChild(part = stringArray[i])) != null; ++i) {
        }
        return n;
    }

    @Override
    public final T get(String fqn) {
        FqnCacheNode<T> n = this.getNode(fqn);
        return n == null ? null : (T)n.getUserData();
    }

    @Override
    public final boolean contains(String fqn) {
        return this.getNode(fqn) != null;
    }

    @Override
    public final void add(String fqn) {
        this.add(fqn, null);
    }

    @Override
    public void add(String fqn, T userData) {
        FqnCacheNode n = this;
        for (String part : this.getParts(fqn, this._validator)) {
            n = n.getOrCreateChild(part);
        }
        n.setUserData(userData);
    }

    public void addAll(FqnCache<T> from) {
        from.getFqns().forEach(fqn -> this.add((String)fqn, from.get((String)fqn)));
    }

    public void addAll(Map<String, T> from) {
        from.keySet().forEach(fqn -> this.add((String)fqn, (T)from.get(fqn)));
    }

    @Override
    public final void remove(String[] fqns) {
        for (String fqn : fqns) {
            this.remove(fqn);
        }
    }

    @Override
    public boolean remove(String fqn) {
        FqnCacheNode n = this;
        for (String part : this.getParts(fqn, this._validator)) {
            if ((n = n.getChild(part)) != null) continue;
            return false;
        }
        n.delete();
        return true;
    }

    @Override
    public Set<String> getFqns() {
        HashSet<String> names = new HashSet<String>();
        this.collectNames(names, "");
        return names;
    }

    private static String[] split(String fqn, Validator validator) {
        String theRest = fqn;
        DynamicArray<String> parts = new DynamicArray<String>();
        while (theRest != null) {
            String part;
            int iParam = theRest.indexOf(60);
            int iDot = theRest.indexOf(46);
            int iArray = theRest.indexOf(91);
            if (iParam == 0) {
                if (iArray > 0) {
                    part = theRest.substring(0, iArray);
                    theRest = iArray < theRest.length() ? theRest.substring(iArray) : null;
                } else {
                    if (theRest.charAt(theRest.length() - 1) != '>') {
                        throw new RuntimeException("\"" + theRest + "\" does not end with '>'");
                    }
                    part = theRest;
                    theRest = null;
                }
            } else if (iArray == 0) {
                part = theRest.substring(0, 2);
                theRest = part.length() == theRest.length() ? null : theRest.substring(2);
            } else if (iParam > 0) {
                if (iDot > 0 && iDot < iParam) {
                    part = theRest.substring(0, iDot);
                    theRest = iDot + 1 < theRest.length() ? theRest.substring(iDot + 1) : null;
                } else {
                    part = theRest.substring(0, iParam);
                    theRest = iParam < theRest.length() ? theRest.substring(iParam) : null;
                }
            } else if (iDot > 0) {
                part = theRest.substring(0, iDot);
                theRest = iDot + 1 < theRest.length() ? theRest.substring(iDot + 1) : null;
            } else {
                part = theRest;
                theRest = null;
            }
            if (validator != null && (part = validator.validate(part)) == null) {
                return null;
            }
            parts.add(StringCache.get(part));
        }
        return parts.toArray(new String[parts.size()]);
    }

    private String[] getParts(String fqn, Validator validator) {
        if (validator != null) {
            return this._validatorCache.get(fqn);
        }
        return FqnCache.getParts(fqn);
    }

    public static String[] getParts(String fqn) {
        return (String[])PARTS_CACHE.get(fqn);
    }

    public static interface Validator {
        public String validate(String var1);
    }
}

