/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import manifold.util.concurrent.LocklessLazyVar;

public class PerfLogUtil {
    private static final LocklessLazyVar<Boolean> PERF = LocklessLazyVar.make(() -> {
        String value = System.getProperty("manifold.perf", "false");
        return Boolean.valueOf(value);
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String label, Runnable run) {
        long before = System.nanoTime();
        try {
            run.run();
        }
        finally {
            PerfLogUtil.log(label, before);
        }
    }

    public static void log(String label, long nanosBefore) {
        if (!PERF.get().booleanValue()) {
            return;
        }
        System.out.println(label + ": " + (System.nanoTime() - nanosBefore) / 1000000L + "ms");
    }
}

