/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import manifold.internal.javac.IIssue;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.manifold.TemplateIssue;
import manifold.templates.tokenizer.Token;

public class Tokenizer {
    private List<TemplateIssue> _issues = new ArrayList<TemplateIssue>();

    public List<Token> tokenize(String str) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        TokenBuilder builder = new TokenBuilder(str);
        while (builder.hasNext()) {
            tokens.add(builder.next());
        }
        return tokens;
    }

    private void addError(String message, int line) {
        TemplateIssue error = new TemplateIssue(IIssue.Kind.Error, 0, line, 0, message);
        this._issues.add(error);
    }

    public List<TemplateIssue> getIssues() {
        return this._issues;
    }

    static {
        Bootstrap.init();
    }

    class TokenBuilder
    implements Iterator<Token> {
        String tokenString;
        int line;
        int col;
        int index;
        int toJump = 0;

        TokenBuilder(String str) {
            this.tokenString = str;
            this.line = 1;
            this.col = 1;
            this.index = 0;
        }

        private Character peekBehind() {
            return this.peekBehind(1);
        }

        private Character peekBehind(int distance) {
            if (this.index - distance < 0) {
                return null;
            }
            return Character.valueOf(this.tokenString.charAt(this.index - distance));
        }

        private Character peekForward() {
            return this.peekForward(1);
        }

        private Character peekForward(int distance) {
            if (this.index + distance < this.tokenString.length()) {
                return Character.valueOf(this.tokenString.charAt(this.index + distance));
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.tokenString == null) {
                return false;
            }
            return this.index < this.tokenString.length();
        }

        @Override
        public Token next() {
            Token toReturn;
            if (this.index >= this.tokenString.length()) {
                throw new NoSuchElementException();
            }
            Token.TokenType nextType = this.getNextTokenType();
            int pos = this.index;
            int col = this.col;
            int line = this.line;
            if (nextType == Token.TokenType.STATEMENT) {
                this.advancePosition(2);
                this.toJump = 2;
                toReturn = this.next(nextType, true, line, col, pos, "%>");
                this.advancePosition(2);
            } else if (nextType == Token.TokenType.EXPRESSION) {
                if (this.isModernExpressionSyntax()) {
                    this.advancePosition(2);
                    this.toJump = 1;
                    toReturn = this.next(nextType, true, line, col, pos, "}");
                    this.advancePosition();
                } else {
                    this.advancePosition(3);
                    this.toJump = 2;
                    toReturn = this.next(nextType, true, line, col, pos, "%>");
                    this.advancePosition(2);
                }
            } else if (nextType == Token.TokenType.DIRECTIVE) {
                this.advancePosition(3);
                this.toJump = 2;
                toReturn = this.next(nextType, true, line, col, pos, "%>");
                this.advancePosition(2);
            } else if (nextType == Token.TokenType.COMMENT) {
                this.advancePosition(4);
                this.toJump = 4;
                toReturn = this.next(nextType, false, line, col, pos, "--%>");
                this.advancePosition(4);
            } else {
                this.toJump = 0;
                toReturn = this.next(nextType, false, line, col, pos, "<%", "${");
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private Token next(Token.TokenType type, boolean quoteSensitive, int line, int col, int pos, String ... terminateConditions) {
            int contentStartPos = this.index;
            int length = this.tokenString.length();
            ArrayList<Character> termStart = new ArrayList<Character>();
            for (String s : terminateConditions) {
                termStart.add(Character.valueOf(s.charAt(0)));
            }
            int quoteState = 0;
            while (this.index < length) {
                char current = this.tokenString.charAt(this.index);
                if (current == '\"' && quoteSensitive) {
                    if (quoteState == 1 && this.peekBehind().charValue() != '\\') {
                        quoteState = 0;
                    } else if (quoteState == 0) {
                        quoteState = 1;
                    }
                } else if (current == '\'' && quoteSensitive) {
                    if (quoteState == 2 && this.peekBehind().charValue() != '\\') {
                        quoteState = 0;
                    } else if (quoteState == 0) {
                        quoteState = 2;
                    }
                } else if (current == '\\' && type == Token.TokenType.STRING_CONTENT) {
                    if (this.peekForward().charValue() == '$') {
                        this.advancePosition();
                    }
                    if (this.peekForward().charValue() == '<' && this.peekForward(2).charValue() == '%') {
                        this.advancePosition();
                        this.advancePosition();
                    }
                } else if (quoteState == 0) {
                    if (termStart.contains(Character.valueOf(current)) && this.checkIfTerminates(terminateConditions)) {
                        String currentTokenString = this.tokenString.substring(contentStartPos, this.index);
                        currentTokenString = type != Token.TokenType.STRING_CONTENT ? currentTokenString.trim() : this.removeEscapesForStringContent(currentTokenString);
                        return new Token(type, currentTokenString, line, col, pos, this.index + this.toJump);
                    }
                    if (type != Token.TokenType.COMMENT) {
                        this.checkIllegalOpenings(type);
                    }
                }
                this.advancePosition();
            }
            if (type == Token.TokenType.STRING_CONTENT) {
                return new Token(type, this.removeEscapesForStringContent(this.tokenString.substring(contentStartPos)), line, col, pos, this.index);
            }
            Tokenizer.this.addError("Tokenization Error: " + (Object)((Object)type) + " is not closed", line);
            return new Token(type, this.tokenString.substring(contentStartPos), line, col, pos, this.index);
        }

        private String removeEscapesForStringContent(String currentTokenString) {
            return currentTokenString.replace("\\$", "$").replace("\\<%", "<%");
        }

        private boolean isModernExpressionSyntax() {
            return this.tokenString.charAt(this.index) == '$';
        }

        private boolean checkIfTerminates(String[] terminateConditions) {
            for (String cond : terminateConditions) {
                boolean terminates = true;
                for (int i = 0; i < cond.length(); ++i) {
                    Character c = this.peekForward(i);
                    if (c != null && cond.charAt(i) == c.charValue()) continue;
                    terminates = false;
                }
                if (!terminates) continue;
                return true;
            }
            return false;
        }

        private void checkIllegalOpenings(Token.TokenType type) {
            if (this.tokenString.charAt(this.index) == '<' && this.peekForward().charValue() == '%') {
                if (this.peekForward(2).charValue() == '@') {
                    Tokenizer.this.addError("Attempted to open new directive within " + (Object)((Object)type), this.line);
                } else if (this.peekForward(2).charValue() == '=') {
                    Tokenizer.this.addError("Attempted to open new expression within " + (Object)((Object)type), this.line);
                } else {
                    Tokenizer.this.addError("Attempted to open new statement within " + (Object)((Object)type), this.line);
                }
                this.next();
            }
            if (this.tokenString.charAt(this.index) == '$' && this.peekForward().charValue() == '{') {
                Tokenizer.this.addError("Attempted to open new expression within " + (Object)((Object)type), this.line);
                this.next();
            }
        }

        private Token.TokenType getNextTokenType() {
            Character next = this.peekForward();
            if (this.tokenString.charAt(this.index) == '<' && next.charValue() == '%') {
                if (this.peekForward(2) != null && this.peekForward(2).charValue() == '@') {
                    return Token.TokenType.DIRECTIVE;
                }
                if (this.peekForward(2) != null && this.peekForward(2).charValue() == '=') {
                    return Token.TokenType.EXPRESSION;
                }
                if (this.peekForward(2) != null && this.peekForward(2).charValue() == '-' && this.peekForward(3) != null && this.peekForward(3).charValue() == '-') {
                    return Token.TokenType.COMMENT;
                }
                return Token.TokenType.STATEMENT;
            }
            if (this.tokenString.charAt(this.index) == '$' && next.charValue() == '{') {
                return Token.TokenType.EXPRESSION;
            }
            return Token.TokenType.STRING_CONTENT;
        }

        private void advancePosition() {
            if (this.index < this.tokenString.length()) {
                char current = this.tokenString.charAt(this.index);
                if (current == '\n') {
                    ++this.line;
                    this.col = 0;
                }
                ++this.col;
                ++this.index;
            }
        }

        private void advancePosition(int i) {
            for (int x = 0; x < i; ++x) {
                this.advancePosition();
            }
        }
    }
}

