/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.sparkjava;

import manifold.internal.runtime.Bootstrap;
import manifold.templates.runtime.BaseTemplate;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class SparkTemplate
extends BaseTemplate {
    private static ThreadLocal<Request> REQUEST;
    private static ThreadLocal<Response> RESPONSE;

    public Response getResponse() {
        return RESPONSE.get();
    }

    public Request getRequest() {
        return REQUEST.get();
    }

    public static void init() {
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            REQUEST.set(request);
            RESPONSE.set(response);
        }});
        Spark.afterAfter((request, response) -> {
            REQUEST.set(null);
            RESPONSE.set(null);
        });
    }

    @Override
    public String toS(Object o) {
        if (o instanceof RawObject) {
            return super.toS(o.toString());
        }
        if (o == null) {
            return "";
        }
        return this.escapeHTML(o.toString());
    }

    private String escapeHTML(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot").replaceAll("'", "&#39");
    }

    public Object raw(Object o) {
        return new RawObject(o);
    }

    static {
        Bootstrap.init();
        REQUEST = new ThreadLocal();
        RESPONSE = new ThreadLocal();
    }

    private static class RawObject {
        private final Object in;

        RawObject(Object in) {
            this.in = in;
        }

        public String toString() {
            return this.in.toString();
        }

        static {
            Bootstrap.init();
        }
    }
}

