/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.ManifoldTemplates;
import manifold.templates.runtime.ILayout;
import manifold.templates.runtime.TemplateRuntimeException;
import sun.misc.Unsafe;

public class BaseTemplate {
    private static Unsafe unsafe;
    private ILayout _explicitLayout = null;

    public String toS(Object o) {
        return o == null ? "" : o.toString();
    }

    protected void setLayout(ILayout layout) {
        this._explicitLayout = layout;
    }

    protected ILayout getTemplateLayout() {
        if (this._explicitLayout != null) {
            return this._explicitLayout;
        }
        return ManifoldTemplates.getDefaultLayout(this.getClass().getName());
    }

    protected ILayout getExplicitLayout() {
        return this._explicitLayout;
    }

    protected void beforeRender(Appendable buffer, ILayout override, boolean outerTemplate) throws IOException {
        if (outerTemplate) {
            ILayout templateLayout = override == null ? this.getTemplateLayout() : override;
            templateLayout.header(buffer);
        }
    }

    protected void afterRender(Appendable buffer, ILayout override, boolean outerTemplate, long renderTime) throws IOException {
        if (outerTemplate) {
            ILayout templateLayout = override == null ? this.getTemplateLayout() : override;
            templateLayout.footer(buffer);
        }
        ManifoldTemplates.getTracer().trace(this.getClass(), renderTime);
    }

    protected void handleException(Exception e, String fileName, int lineStart, int[] bbLineNumbers) {
        if (e.getClass().equals(TemplateRuntimeException.class)) {
            unsafe.throwException(e);
        }
        StackTraceElement[] currentStack = e.getStackTrace();
        String templateClassName = this.getClass().getName();
        for (int elementToRemove = 0; elementToRemove < currentStack.length; ++elementToRemove) {
            StackTraceElement curr = currentStack[elementToRemove];
            if (!curr.getClassName().equals(templateClassName)) continue;
            if (curr.getMethodName().equals("renderImpl")) {
                this.handleTemplateException(e, fileName, lineStart, bbLineNumbers, elementToRemove);
                continue;
            }
            if (!curr.getMethodName().equals("footer") && !curr.getMethodName().equals("header")) continue;
            this.handleLayoutException(e, fileName, lineStart, bbLineNumbers, elementToRemove);
        }
    }

    private void handleTemplateException(Exception e, String fileName, int lineStart, int[] bbLineNumbers, int elementToRemove) {
        StackTraceElement b;
        StackTraceElement[] currentStack = e.getStackTrace();
        int lineNumber = currentStack[elementToRemove].getLineNumber();
        int javaLineNum = lineNumber - lineStart;
        String declaringClass = currentStack[elementToRemove + 1].getClassName();
        String methodName = currentStack[elementToRemove + 1].getMethodName();
        currentStack[elementToRemove + 1] = b = new StackTraceElement(declaringClass, methodName, fileName, bbLineNumbers[javaLineNum]);
        System.arraycopy(currentStack, elementToRemove + 1, currentStack, elementToRemove, currentStack.length - 1 - elementToRemove);
        this.throwBBException(e, currentStack);
    }

    private void handleLayoutException(Exception e, String fileName, int lineStart, int[] bbLineNumbers, int elementToReplace) {
        StackTraceElement b;
        StackTraceElement[] currentStack = e.getStackTrace();
        int lineNumber = currentStack[elementToReplace].getLineNumber();
        int javaLineNum = lineNumber - lineStart;
        String declaringClass = currentStack[elementToReplace].getClassName();
        String methodName = currentStack[elementToReplace].getMethodName();
        currentStack[elementToReplace] = b = new StackTraceElement(declaringClass, methodName, fileName, bbLineNumbers[javaLineNum]);
        this.throwBBException(e, currentStack);
    }

    private void throwBBException(Exception e, StackTraceElement[] currentStack) {
        e.setStackTrace(currentStack);
        TemplateRuntimeException exceptionToThrow = new TemplateRuntimeException(e);
        exceptionToThrow.setStackTrace(currentStack);
        unsafe.throwException(exceptionToThrow);
    }

    static {
        Bootstrap.init();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }
}

