/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import manifold.internal.javac.IIssue;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.manifold.TemplateIssue;
import manifold.templates.manifold.TemplateIssueContainer;
import manifold.templates.tokenizer.Token;
import manifold.templates.tokenizer.Tokenizer;

public class TemplateGen {
    private final String BASE_CLASS_NAME = "BaseTemplate";
    private final String LAYOUT_INTERFACE = "ILayout";
    private List<TemplateIssue> _issues = new ArrayList<TemplateIssue>();

    public String generateCode(String fullyQualifiedName, String source, String fileName) {
        FileGenerator generator = new FileGenerator(fullyQualifiedName, fileName, source);
        return generator.getFileContents();
    }

    private void addError(String message, int line) {
        TemplateIssue error = new TemplateIssue(IIssue.Kind.Error, 0, line, 0, message);
        this._issues.add(error);
    }

    public TemplateIssueContainer getIssues() {
        return new TemplateIssueContainer(this._issues);
    }

    static {
        Bootstrap.init();
    }

    class FileGenerator {
        private TemplateStringBuilder sb = new TemplateStringBuilder();
        private ClassInfo currClass;
        private List<Token> tokens;
        private Map<Integer, Directive> dirMap;

        FileGenerator(String fullyQualifiedName, String fileName, String source) {
            String[] parts = fullyQualifiedName.split("\\.");
            String className = parts[parts.length - 1];
            StringBuilder packageName = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length - 1; ++i) {
                packageName.append(".").append(parts[i]);
            }
            Tokenizer tokenizer = new Tokenizer();
            this.tokens = tokenizer.tokenize(source);
            TemplateGen.this._issues.addAll(tokenizer.getIssues());
            List<Directive> dirList = this.getDirectivesList(this.tokens);
            this.dirMap = this.getDirectivesMap(dirList);
            this.currClass = new ClassInfo(dirList.iterator(), className, fileName, this.tokens.size() - 1, true);
            this.buildFile(packageName.toString(), dirList);
        }

        String getFileContents() {
            return this.sb.toString();
        }

        private void buildFile(String packageName, List<Directive> dirList) {
            this.sb.append("package ").reAppend(packageName + ";\n\n").append("import java.io.IOException;\n").append("import manifold.templates.ManifoldTemplates;\n").append("import manifold.templates.runtime.*;\n\n");
            this.addImports(dirList);
            this.makeClassContent();
        }

        private boolean containsStringContentOrExpr(List<Token> tokens, Integer start, Integer end) {
            if (end == null) {
                end = tokens.size() - 1;
            }
            for (int i = start.intValue(); i <= end; ++i) {
                Token token = tokens.get(i);
                Token.TokenType tokenType = token.getType();
                if (tokenType != Token.TokenType.STRING_CONTENT && tokenType != Token.TokenType.EXPRESSION) continue;
                return true;
            }
            return false;
        }

        private void addRenderImpl() {
            boolean needsToCatchIO;
            if (this.currClass.paramsList == null) {
                this.sb.append("    public void renderImpl(Appendable buffer, ILayout overrideLayout) {\n");
            } else {
                this.sb.append("    public void renderImpl(Appendable buffer, ILayout overrideLayout, ").reAppend(this.currClass.params).reAppend(") {\n");
            }
            boolean bl = needsToCatchIO = this.currClass.depth == 0;
            if (!needsToCatchIO) {
                needsToCatchIO = this.containsStringContentOrExpr(this.tokens, this.currClass.startTokenPos - 1, this.currClass.endTokenPos);
            }
            if (needsToCatchIO) {
                this.sb.append("        try {\n");
            }
            if (this.currClass.isLayout) {
                this.sb.append("            INSTANCE.header(buffer);\n").append("            INSTANCE.footer(buffer);\n");
            } else {
                this.sb.append("            beforeRender(buffer, overrideLayout, ").reAppend(String.valueOf(this.currClass.depth == 0)).reAppend(");\n");
                this.sb.append("            long startTime = System.nanoTime();\n");
                this.makeFuncContent(this.currClass.startTokenPos, this.currClass.endTokenPos);
                this.sb.append("            long endTime = System.nanoTime();\n");
                this.sb.append("            long duration = (endTime - startTime)/1000000;\n");
                this.sb.append("            afterRender(buffer, overrideLayout, ").reAppend(String.valueOf(this.currClass.depth == 0)).reAppend(", duration);\n");
            }
            if (needsToCatchIO) {
                this.sb.append("        } catch (IOException e) {\n").append("            throw new RuntimeException(e);\n").append("        }\n");
            }
            this.sb.append("    }\n\n");
        }

        private void addRender() {
            if (this.currClass.paramsList == null) {
                this.sb.append("\n").append("    public static String render() {\n").append("        StringBuilder sb = new StringBuilder();\n").append("        renderInto(sb);\n").append("        return sb.toString();\n").append("    }\n\n");
                this.sb.append("\n").append("    public static String render(ILayout overrideLayout) {\n").append("        StringBuilder sb = new StringBuilder();\n").append("        renderInto(sb, overrideLayout);\n").append("        return sb.toString();\n").append("    }\n\n");
            } else {
                this.sb.append("\n").append("    public static String render(").reAppend(this.currClass.params + ") {\n").append("        StringBuilder sb = new StringBuilder();\n").append("        renderInto(sb");
                for (String[] p : this.currClass.paramsList) {
                    this.sb.reAppend(", ").reAppend(p[1]);
                }
                this.sb.reAppend(");\n").append("        return sb.toString();\n").append("    }\n\n");
                this.sb.append("\n").append("    public static String render(ILayout overrideLayout, ").reAppend(this.currClass.params + ") {\n").append("        StringBuilder sb = new StringBuilder();\n").append("        renderInto(sb, overrideLayout");
                for (String[] p : this.currClass.paramsList) {
                    this.sb.reAppend(", ").reAppend(p[1]);
                }
                this.sb.reAppend(");\n").append("        return sb.toString();\n").append("    }\n\n");
            }
        }

        private void addFileHeader() {
            this.sb.append("\n");
            if (this.currClass.depth == 0) {
                if (this.currClass.isLayout) {
                    this.sb.append("public class ").reAppend(this.currClass.name).reAppend(" extends ").reAppend(this.currClass.superClass).reAppend(" implements ").reAppend("ILayout").reAppend(" {\n");
                } else {
                    this.sb.append("public class ").reAppend(this.currClass.name).reAppend(" extends ").reAppend(this.currClass.superClass).reAppend(" {\n");
                }
            } else {
                this.sb.append("public static class ").reAppend(this.currClass.name).reAppend(" extends ").reAppend(this.currClass.superClass).reAppend(" {\n");
            }
            this.sb.append("    private static ").reAppend(this.currClass.name).reAppend(" INSTANCE = new ").reAppend(this.currClass.name).reAppend("();\n");
            this.sb.append("    private ").reAppend(this.currClass.name).reAppend("(){\n");
            if (this.currClass.hasLayout) {
                this.sb.append("        setLayout(").reAppend(this.currClass.layoutDir.className).reAppend(".asLayout());\n");
            }
            this.sb.append("}\n\n");
        }

        private void addRenderInto() {
            if (this.currClass.paramsList == null) {
                this.sb.append("    public static void renderInto(Appendable buffer) {\n").append("        INSTANCE.renderImpl(buffer, null);\n").append("    }\n\n");
                this.sb.append("    public static void renderInto(Appendable buffer, ILayout overrideLayout) {\n").append("        INSTANCE.renderImpl(buffer, overrideLayout);\n").append("    }\n\n");
            } else {
                this.sb.append("    public static void renderInto(Appendable buffer, ").reAppend(this.currClass.params).reAppend(") {\n").append("        INSTANCE.renderImpl(buffer, null");
                for (String[] param : this.currClass.paramsList) {
                    this.sb.reAppend(", ").reAppend(param[1]);
                }
                this.sb.reAppend(");\n").append("    }\n\n");
                this.sb.append("    public static void renderInto(Appendable buffer, ILayout overrideLayout, ").reAppend(this.currClass.params).reAppend(") {\n").append("        INSTANCE.renderImpl(buffer, overrideLayout");
                for (String[] param : this.currClass.paramsList) {
                    this.sb.reAppend(", ").reAppend(param[1]);
                }
                this.sb.reAppend(");\n").append("    }\n\n");
            }
        }

        private void makeClassContent() {
            this.addFileHeader();
            this.addRender();
            this.addRenderInto();
            this.addRenderImpl();
            if (this.currClass.isLayout) {
                this.addHeaderAndFooter();
            }
            Iterator<ClassInfo> iterator = this.currClass.nestedClasses.values().iterator();
            while (iterator.hasNext()) {
                ClassInfo nested;
                this.currClass = nested = iterator.next();
                this.makeClassContent();
            }
            this.sb.append("}\n");
        }

        private void addHeaderAndFooter() {
            this.sb.append("    public static ").reAppend("ILayout").reAppend(" asLayout() {\n").append("        return INSTANCE;\n").append("    }\n\n").append("    @Override\n").append("    public void header(Appendable buffer) throws IOException {\n").append("        if (getExplicitLayout() != null) {\n").append("            getExplicitLayout().header(buffer);\n").append("        }\n");
            assert (this.currClass.depth == 0);
            this.makeFuncContent(this.currClass.startTokenPos, this.currClass.contentPos);
            this.sb.append("    }\n").append("    @Override\n").append("    public void footer(Appendable buffer) throws IOException {\n");
            this.makeFuncContent(this.currClass.contentPos, this.currClass.endTokenPos);
            this.sb.append("        if (getExplicitLayout() != null) {\n").append("            getExplicitLayout().footer(buffer);\n").append("    }\n}\n");
        }

        private List<Directive> getDirectivesList(List<Token> tokens) {
            ArrayList<Directive> dirList = new ArrayList<Directive>();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getType() != Token.TokenType.DIRECTIVE) continue;
                dirList.add(new Directive(i, token, tokens));
            }
            return dirList;
        }

        private Map<Integer, Directive> getDirectivesMap(List<Directive> dirList) {
            HashMap<Integer, Directive> dirMap = new HashMap<Integer, Directive>();
            for (Directive dir : dirList) {
                dirMap.put(dir.tokenPos, dir);
            }
            return dirMap;
        }

        private void addImports(List<Directive> dirList) {
            for (Directive dir : dirList) {
                if (dir.dirType != DirType.IMPORT) continue;
                this.sb.append("import " + dir.className + ";\n");
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void makeFuncContent(Integer startPos, Integer endPos) {
            ArrayList<Integer> bbLineNumbers = new ArrayList<Integer>();
            if (endPos == null) {
                endPos = this.tokens.size() - 1;
            }
            this.sb.append("            int lineStart = Thread.currentThread().getStackTrace()[1].getLineNumber() + 1;\n");
            this.sb.append("            try {\n");
            block7: for (int i = startPos.intValue(); i <= endPos; ++i) {
                Token token = this.tokens.get(i);
                switch (token.getType()) {
                    case STRING_CONTENT: {
                        this.sb.append("                buffer.append(\"").reAppend(token.getContent().replaceAll("\"", "\\\\\"").replaceAll("\r", "").replaceAll("\n", "\\\\n") + "\");\n");
                        bbLineNumbers.add(token.getLine());
                        break;
                    }
                    case STATEMENT: {
                        String[] statementList = token.getContent().split("\n");
                        for (int j = 0; j < statementList.length; ++j) {
                            String statement = statementList[j].trim().replaceAll("\r", "");
                            this.sb.append("                ").reAppend(statement).reAppend("\n");
                            bbLineNumbers.add(token.getLine() + j);
                        }
                        break;
                    }
                    case EXPRESSION: {
                        this.sb.append("                buffer.append(toS(").reAppend(token.getContent()).reAppend("));\n");
                        bbLineNumbers.add(token.getLine());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    case DIRECTIVE: {
                        Directive dir = this.dirMap.get(i);
                        if (dir.dirType == DirType.SECTION) {
                            ClassInfo classToSkipOver = this.currClass.nestedClasses.get(i + 1);
                            i = classToSkipOver.endTokenPos == null ? endPos.intValue() : classToSkipOver.endTokenPos.intValue();
                            this.addSection(dir);
                            break;
                        }
                        if (dir.dirType == DirType.END_SECTION) break block7;
                        if (dir.dirType == DirType.INCLUDE) {
                            this.addInclude(dir);
                            break;
                        }
                        if (dir.dirType != DirType.CONTENT) break;
                    }
                }
            }
            String nums = bbLineNumbers.toString().substring(1, bbLineNumbers.toString().length() - 1);
            this.sb.append("            } catch (RuntimeException e) {\n");
            this.sb.append("                int[] bbLineNumbers = new int[]{").reAppend(nums).reAppend("};\n");
            this.sb.append("                handleException(e, \"").reAppend(this.currClass.fileName).reAppend("\", lineStart, bbLineNumbers);\n            }\n");
        }

        private void addInclude(Directive dir) {
            assert (dir.dirType == DirType.INCLUDE);
            if (dir.conditional == null) {
                if (dir.params != null) {
                    this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer, manifold.templates.runtime.ILayout.EMPTY,").reAppend(dir.params).reAppend(");\n");
                } else {
                    this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer, manifold.templates.runtime.ILayout.EMPTY);\n");
                }
            } else {
                this.sb.append("            if(").reAppend(dir.conditional).reAppend("){\n");
                if (dir.params != null) {
                    this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer, manifold.templates.runtime.ILayout.EMPTY,").reAppend(dir.params).reAppend(");\n");
                } else {
                    this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer, manifold.templates.runtime.ILayout.EMPTY);\n");
                }
                this.sb.append("            ").reAppend("}\n");
            }
        }

        private void addSection(Directive dir) {
            assert (dir.dirType == DirType.SECTION);
            if (dir.params != null) {
                String paramsWithoutTypes = dir.makeParamsStringWithoutTypes(dir.paramsList);
                this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer, ").reAppend(paramsWithoutTypes).reAppend(");\n");
            } else {
                this.sb.append("            ").reAppend(dir.className).reAppend(".renderInto(buffer);\n");
            }
        }

        private class TemplateStringBuilder {
            private final String INDENT = "    ";
            private StringBuilder sb = new StringBuilder();

            private TemplateStringBuilder() {
            }

            TemplateStringBuilder append(String content) {
                for (int i = 0; i < ((FileGenerator)FileGenerator.this).currClass.depth; ++i) {
                    this.sb.append("    ");
                }
                this.sb.append(content);
                return this;
            }

            TemplateStringBuilder reAppend(String content) {
                this.sb.append(content);
                return this;
            }

            public String toString() {
                return this.sb.toString();
            }
        }
    }

    class Directive {
        int tokenPos;
        Token token;
        DirType dirType;
        String className;
        String params;
        String[][] paramsList;
        String conditional;

        Directive(int tokenPos, Token token, List<Token> tokens) {
            assert (token.getType() == Token.TokenType.DIRECTIVE);
            this.tokenPos = tokenPos;
            this.token = token;
            this.identifyType();
            this.fillVars(tokens);
        }

        private void identifyType() {
            String content = this.token.getContent();
            if (content.matches("import.*")) {
                this.dirType = DirType.IMPORT;
            } else if (content.matches("extends.*")) {
                this.dirType = DirType.EXTENDS;
            } else if (content.matches("params.*")) {
                this.dirType = DirType.PARAMS;
            } else if (content.matches("include.*")) {
                this.dirType = DirType.INCLUDE;
            } else if (content.matches("section.*")) {
                this.dirType = DirType.SECTION;
            } else if (content.trim().matches("end section")) {
                this.dirType = DirType.END_SECTION;
            } else if (content.trim().matches("content")) {
                this.dirType = DirType.CONTENT;
            } else if (content.trim().matches("layout.*")) {
                this.dirType = DirType.LAYOUT;
            } else {
                TemplateGen.this.addError("Unsupported Directive Type", this.token.getLine());
                this.dirType = DirType.ERRANT;
            }
        }

        private void fillVars(List<Token> tokens) {
            switch (this.dirType) {
                case IMPORT: {
                    this.className = this.token.getContent().substring(6).trim();
                    break;
                }
                case EXTENDS: {
                    this.className = this.token.getContent().substring(7).trim();
                    break;
                }
                case PARAMS: {
                    String content = this.token.getContent().substring(6).trim();
                    this.params = content.substring(1, content.length() - 1);
                    this.paramsList = this.splitParamsList(this.params);
                    break;
                }
                case INCLUDE: {
                    this.fillIncludeVars();
                    break;
                }
                case SECTION: {
                    String[] temp = this.token.getContent().substring(7).trim().split("\\(", 2);
                    this.className = temp[0].trim();
                    if (temp.length != 2 || temp[1].equals(")")) break;
                    this.params = temp[1].substring(0, temp[1].length() - 1).trim();
                    this.paramsList = this.splitParamsList(this.params);
                    this.findParamTypes(this.paramsList, this.tokenPos, tokens);
                    this.params = this.makeParamsString(this.paramsList);
                    break;
                }
                case END_SECTION: {
                    break;
                }
                case CONTENT: {
                    break;
                }
                case LAYOUT: {
                    this.className = this.token.getContent().substring(6).trim();
                    break;
                }
            }
        }

        private void fillIncludeVars() {
            String content = this.token.getContent().substring(8).trim();
            for (int index = 0; index < content.length(); ++index) {
                if (content.charAt(index) == '(') {
                    this.className = content.substring(0, index).trim();
                    this.params = content.substring(index + 1, content.indexOf(41));
                    this.fillConditional(content.substring(content.indexOf(41) + 1).trim());
                    return;
                }
                if (index >= content.length() - 2 || content.charAt(index) != ' ' || content.charAt(index + 1) != 'i' || content.charAt(index + 2) != 'f') continue;
                this.className = content.substring(0, index).trim();
                this.params = null;
                this.fillConditional(content.substring(index + 1).trim());
                return;
            }
            this.className = content;
        }

        private void fillConditional(String conditional) {
            if (conditional.length() < 2) {
                return;
            }
            String conditionalWithoutIf = conditional.substring(2);
            this.conditional = conditionalWithoutIf.charAt(0) == '(' ? conditionalWithoutIf.substring(1, conditionalWithoutIf.length() - 1) : conditionalWithoutIf;
        }

        private String[][] splitParamsList(String params) {
            params = params.replaceAll(" ,", ",").replace(", ", ",");
            String[] parameters = params.split(",");
            String[][] paramsList = new String[parameters.length][2];
            for (int i = 0; i < parameters.length; ++i) {
                paramsList[i] = parameters[i].split(" ", 2);
            }
            return paramsList;
        }

        private String makeParamsString(String[][] paramsList) {
            StringBuilder params = new StringBuilder().append(paramsList[0][0]).append(" ").append(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][0]).append(" ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private void findParamTypes(String[][] params, int tokenPos, List<Token> tokens) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].length != 1) continue;
                String name = params[i][0];
                params[i] = new String[2];
                params[i][0] = this.inferSingleArgumentType(name, tokenPos, tokens);
                params[i][1] = name;
            }
        }

        private String makeParamsStringWithoutTypes(String[][] paramsList) {
            StringBuilder params = new StringBuilder(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private String inferSingleArgumentType(String name, int tokenPos, List<Token> tokens) {
            String pattern = "([a-zA-Z_$][a-zA-Z_$0-9]* " + name + ")|(\".*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*\")|('.*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*')";
            Pattern argumentRegex = Pattern.compile(pattern);
            for (int i = tokenPos - 1; i >= 0; --i) {
                String[][] outerClassParameters;
                Token currentToken = tokens.get(i);
                if (currentToken.getType() == Token.TokenType.STATEMENT) {
                    Matcher argumentMatcher = argumentRegex.matcher(currentToken.getContent());
                    String toReturn = null;
                    while (argumentMatcher.find()) {
                        if (argumentMatcher.group(1) == null) continue;
                        toReturn = argumentMatcher.group(1);
                    }
                    if (toReturn == null) continue;
                    return toReturn.split(" ")[0];
                }
                if (currentToken.getType() != Token.TokenType.DIRECTIVE) continue;
                Directive cur = new Directive(i, currentToken, tokens);
                if (cur.dirType != DirType.PARAMS) continue;
                for (String[] currentParams : outerClassParameters = cur.paramsList) {
                    String parameter = currentParams[1];
                    if (!name.equals(parameter)) continue;
                    return currentParams[0];
                }
            }
            TemplateGen.this.addError("Type for argument can not be inferred: " + name, this.token.getLine());
            return "";
        }
    }

    protected static enum DirType {
        IMPORT,
        EXTENDS,
        PARAMS,
        INCLUDE,
        SECTION,
        END_SECTION,
        CONTENT,
        LAYOUT,
        ERRANT;


        static {
            Bootstrap.init();
        }
    }

    class ClassInfo {
        Map<Integer, ClassInfo> nestedClasses = new HashMap<Integer, ClassInfo>();
        String params = null;
        String[][] paramsList = null;
        String name;
        String fileName;
        String superClass = "BaseTemplate";
        int startTokenPos;
        Integer endTokenPos;
        int depth;
        boolean isLayout = false;
        boolean hasLayout = false;
        Directive layoutDir;
        int contentPos;

        ClassInfo(Iterator<Directive> dirIterator, String name, String fileName, Integer endTokenPos, boolean outermost) {
            assert (outermost);
            this.name = name;
            this.fileName = fileName;
            this.startTokenPos = 0;
            this.endTokenPos = endTokenPos;
            this.depth = 0;
            this.fillClassInfo(dirIterator);
        }

        ClassInfo(Iterator<Directive> dirIterator, String name, String fileName, String params, String[][] paramList, int startTokenPos, int depth, String superClass) {
            this.name = name;
            this.fileName = fileName;
            this.params = params;
            this.paramsList = paramList;
            this.startTokenPos = startTokenPos;
            this.depth = depth;
            this.superClass = superClass;
            this.fillClassInfo(dirIterator);
        }

        /*
         * Enabled aggressive block sorting
         */
        void fillClassInfo(Iterator<Directive> dirIterator) {
            boolean endSec = false;
            while (dirIterator.hasNext()) {
                Directive dir = dirIterator.next();
                switch (dir.dirType) {
                    case IMPORT: {
                        break;
                    }
                    case INCLUDE: {
                        break;
                    }
                    case EXTENDS: {
                        if (this.depth == 0) {
                            if (this.superClass.equals("BaseTemplate")) {
                                this.superClass = dir.className;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Extends Directive: class cannot extend 2 classes", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Extends Directive: class cannot extend within section", dir.token.getLine());
                        break;
                    }
                    case PARAMS: {
                        if (this.depth == 0) {
                            if (this.params == null) {
                                this.params = dir.params;
                                this.paramsList = dir.paramsList;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Params Directive: class cannot have 2 params directives", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Params Directive: class cannot have param directive within section", dir.token.getLine());
                        break;
                    }
                    case SECTION: {
                        this.addNestedClass(new ClassInfo(dirIterator, dir.className, this.fileName, dir.params, dir.paramsList, dir.tokenPos + 1, this.depth + 1, this.superClass));
                        break;
                    }
                    case END_SECTION: {
                        if (this.endTokenPos == null) {
                            this.endTokenPos = dir.tokenPos;
                            return;
                        } else {
                            TemplateGen.this.addError("Invalid End Section Directive: section declaration does not exist", dir.token.getLine());
                        }
                        return;
                    }
                    case CONTENT: {
                        if (this.isLayout) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot have two layout instantiations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot instantiate layout within section", dir.token.getLine());
                            break;
                        }
                        this.isLayout = true;
                        this.contentPos = dir.tokenPos;
                        break;
                    }
                    case LAYOUT: {
                        if (this.hasLayout) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot have two layout declarations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot declare layout within section", dir.token.getLine());
                            break;
                        }
                        this.hasLayout = true;
                        this.layoutDir = dir;
                    }
                }
            }
            if (endSec) return;
            if (this.depth == 0) {
                if ($assertionsDisabled) return;
                if (this.startTokenPos == 0) return;
                throw new AssertionError();
            }
            TemplateGen.this.addError("Reached end of file before parsing section: " + this.name, 0);
        }

        void addNestedClass(ClassInfo nestedClass) {
            this.nestedClasses.put(nestedClass.startTokenPos, nestedClass);
        }
    }
}

