/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates;

import java.util.HashMap;
import manifold.internal.runtime.Bootstrap;
import manifold.templates.runtime.ILayout;

public class ManifoldTemplates {
    private static HashMap<String, ILayout> DEFAULT_LAYOUT_MAP;
    private static TraceCallback TRACER;

    public static void resetDefaultLayout() {
        DEFAULT_LAYOUT_MAP = new HashMap();
        DEFAULT_LAYOUT_MAP.put("", ILayout.EMPTY);
    }

    public static void setDefaultLayout(ILayout layout) {
        DEFAULT_LAYOUT_MAP.put("", layout);
    }

    public static void setDefaultLayout(String somePackage, ILayout layout) {
        DEFAULT_LAYOUT_MAP.put(somePackage, layout);
    }

    public static void trace() {
        ManifoldTemplates.traceWith((template, timeToRender) -> System.out.println(" - Template " + template.getName() + " rendered in " + timeToRender + "ms"));
    }

    public static void traceWith(TraceCallback tracer) {
        TRACER = tracer;
    }

    public static ILayout getDefaultLayout(String packageName) {
        if (DEFAULT_LAYOUT_MAP.containsKey(packageName)) {
            return DEFAULT_LAYOUT_MAP.get(packageName);
        }
        return ManifoldTemplates.getDefaultLayout(packageName.substring(0, Math.max(0, packageName.lastIndexOf(46))));
    }

    public static TraceCallback getTracer() {
        return TRACER;
    }

    static {
        Bootstrap.init();
        TRACER = (c, t) -> {};
        DEFAULT_LAYOUT_MAP = new HashMap();
        DEFAULT_LAYOUT_MAP.put("", ILayout.EMPTY);
    }

    public static interface TraceCallback {
        public void trace(Class var1, long var2);

        static {
            Bootstrap.init();
        }
    }
}

