/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.internal.runtime.Bootstrap;
import manifold.js.JavascriptProgram;
import manifold.js.Util;
import manifold.js.parser.TemplateParser;
import manifold.js.parser.TemplateTokenizer;
import manifold.js.parser.tree.template.JSTNode;
import manifold.js.parser.tree.template.RawStringNode;

public class JavascriptTemplate {
    public static SrcClass genClass(String fqn, JSTNode jstNode) {
        SrcClass clazz = new SrcClass(fqn, SrcClass.Kind.Class);
        clazz.addField(((SrcField)new SrcField("TEMPLATE_NODE", JSTNode.class).modifiers(8L)).initializer(new SrcRawExpression("manifold.js.JavascriptTemplate.initNode(\"" + fqn + "\")")));
        clazz.addField(((SrcField)new SrcField("ENGINE", ScriptEngine.class).modifiers(8L)).initializer(new SrcRawExpression("manifold.js.JavascriptTemplate.initEngine(TEMPLATE_NODE)")));
        Object srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name("renderToString")).modifiers(9L)).returns(String.class);
        List<SrcParameter> srcParameters = JavascriptProgram.makeSrcParameters(jstNode, srcMethod);
        ((AbstractSrcMethod)srcMethod).body(new SrcStatementBlock().addStatement(new SrcRawStatement().rawText("return manifold.js.JavascriptTemplate.renderToStringImpl(ENGINE, TEMPLATE_NODE" + JavascriptProgram.generateArgList(srcParameters) + ");")));
        clazz.addMethod((AbstractSrcMethod)srcMethod);
        return clazz;
    }

    public static String renderToStringImpl(ScriptEngine engine, JSTNode templateNode, Object ... args) {
        try {
            List rawStrings;
            Object[] argsWithStrings = Arrays.copyOf(args, args.length + 1);
            argsWithStrings[argsWithStrings.length - 1] = rawStrings = templateNode.getChildren(RawStringNode.class).stream().map(node -> node.genCode()).collect(Collectors.toList());
            String ret = (String)((Invocable)((Object)engine)).invokeFunction("renderToString", argsWithStrings);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptEngine initEngine(JSTNode templateNode) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        Util.safe(() -> nashorn.eval(templateNode.genCode()));
        return nashorn;
    }

    public static JSTNode initNode(String programName) {
        TemplateParser parser = new TemplateParser(new TemplateTokenizer(JavascriptProgram.loadSrcForName(programName, "jst"), true));
        return (JSTNode)parser.parse();
    }

    static {
        Bootstrap.init();
    }
}

