/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.File;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import manifold.collections.extensions.java.lang.Iterable.ManIterableExt;
import manifold.collections.extensions.java.util.List.ManifoldListCollectionExt;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.runtime.Bootstrap;
import manifold.io.FilePathComponents;
import manifold.io.FileTreeWalk;
import manifold.io.extensions.java.io.File.ManFileReadWriteExt;
import manifold.io.extensions.java.io.InputStream.ManInputStreamExt;
import manifold.text.extensions.java.lang.String.ManStringExt;

@Extension
public class ManFileExt {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    @Extension
    public static File createTempDir() throws IOException {
        return ManFileExt.createTempDir("tmp", null, null);
    }

    @Extension
    public static File createTempDir(String prefix, String suffix, File directory) throws IOException {
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        if (dir.mkdir()) {
            return dir;
        }
        throw new IOException("Unable to create temporary directory " + dir);
    }

    public static String getExtension(@This File thiz) {
        String ext = ManStringExt.substringAfterLast(thiz.getName(), '.');
        return ext == null ? "" : ext;
    }

    public static String slashPath(@This File thiz) {
        return thiz.getPath().replace('\u0000', '/');
    }

    public static String nameWithoutExtension(@This File thiz) {
        String name = ManStringExt.substringBeforeLast(thiz.getName(), ".");
        return name == null ? "" : name;
    }

    public static String toRelativeString(@This File thiz, File base) {
        String rel = ManFileExt.toRelativeStringOrNull(thiz, base);
        if (rel == null) {
            throw new IllegalArgumentException("this and base files have different roots: " + thiz + " and " + base);
        }
        return rel;
    }

    public static File relativeTo(@This File thiz, File base) {
        return new File(ManFileExt.toRelativeString(thiz, base));
    }

    public static File relativeToOrSelf(@This File thiz, File base) {
        String rel = ManFileExt.toRelativeStringOrNull(thiz, base);
        return rel == null ? thiz : new File(rel);
    }

    public static File relativeToOrNull(@This File thiz, File base) {
        String rel = ManFileExt.toRelativeStringOrNull(thiz, base);
        return rel == null ? null : new File(rel);
    }

    private static String toRelativeStringOrNull(File thiz, File base) {
        FilePathComponents thisComponents = ManFileExt.toComponents(thiz).normalize();
        FilePathComponents baseComponents = ManFileExt.toComponents(base).normalize();
        if (thisComponents.root != baseComponents.root) {
            return null;
        }
        int baseCount = baseComponents.size();
        int thisCount = thisComponents.size();
        int sameCount = ManFileExt.getSameCount(thisComponents, baseComponents, baseCount, thisCount);
        StringBuilder res = new StringBuilder();
        for (int i = baseCount - 1; i >= sameCount; --i) {
            if (baseComponents.segments.get(i).getName().equals("..")) {
                return null;
            }
            res.append("..");
            if (i == sameCount) continue;
            res.append('\u0000');
        }
        if (sameCount < thisCount) {
            if (sameCount < baseCount) {
                res.append('\u0000');
            }
            ManIterableExt.joinTo(ManIterableExt.subList(thisComponents.segments, sameCount), res, File.separator);
        }
        return res.toString();
    }

    private static int getSameCount(FilePathComponents thisComponents, FilePathComponents baseComponents, int baseCount, int thisCount) {
        int i;
        int maxSameCount = Math.min(thisCount, baseCount);
        for (i = 0; i < maxSameCount && thisComponents.segments.get(i).equals(baseComponents.segments.get(i)); ++i) {
        }
        return i;
    }

    public static FilePathComponents toComponents(@This File thiz) {
        String path = thiz.getPath();
        int rootLength = ManFileExt.getRootLength(path);
        String rootName = path.substring(0, rootLength);
        String subPath = path.substring(rootLength);
        ArrayList<File> list = subPath.isEmpty() ? new ArrayList<File>() : Arrays.stream(subPath.split(File.separator)).map(File::new).collect(Collectors.toList());
        return new FilePathComponents(new File(rootName), list);
    }

    private static int getRootLength(String path) {
        int first = path.indexOf(0, 0);
        if (first == 0) {
            if (path.length() > 1 && path.charAt(1) == '\u0000' && (first = path.indexOf(0, 2)) >= 0) {
                if ((first = path.indexOf(0, first + 1)) >= 0) {
                    return first + 1;
                }
                return path.length();
            }
            return 1;
        }
        if (first > 0 && path.charAt(first - 1) == ':') {
            return ++first;
        }
        if (first == -1 && path.endsWith(":")) {
            return path.length();
        }
        return 0;
    }

    static String rootName(File thiz) {
        return thiz.getPath().substring(0, ManFileExt.getRootLength(thiz.getPath()));
    }

    static File root(File thiz) {
        return new File(ManFileExt.rootName(thiz));
    }

    public static boolean isRooted(@This File thiz) {
        return ManFileExt.getRootLength(thiz.getPath()) > 0;
    }

    public static File copyTo(@This File thiz, File target) {
        return ManFileExt.copyTo(thiz, target, false, 8192);
    }

    public static File copyTo(@This File thiz, File target, boolean overwrite, int bufferSize) {
        if (!thiz.exists()) {
            throw new RuntimeException(new NoSuchFileException(thiz.toString(), null, "The source file doesn't exist."));
        }
        if (target.exists()) {
            boolean stillExists;
            boolean bl = stillExists = !overwrite || !target.delete();
            if (stillExists) {
                throw new RuntimeException(new FileAlreadyExistsException(thiz.toString(), target.toString(), "The destination file already exists."));
            }
        }
        if (thiz.isDirectory()) {
            if (!target.mkdirs()) {
                throw new RuntimeException(new FileSystemException(thiz.toString(), target.toString(), "Failed to create target directory."));
            }
        } else {
            File parentFile = target.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            try (FileInputStream input = ManFileReadWriteExt.inputStream(thiz);
                 FileOutputStream output = ManFileReadWriteExt.outputStream(target);){
                ManInputStreamExt.copyTo(input, output, bufferSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return target;
    }

    public static boolean copyRecursively(@This File thiz, File target) {
        return ManFileExt.copyRecursively(thiz, target, false, (t, u) -> {
            throw new RuntimeException((Throwable)u);
        });
    }

    public static boolean copyRecursively(@This File thiz, File target, Predicate<File> filter) {
        return ManFileExt.copyRecursively(thiz, target, false, (t, u) -> {
            throw new RuntimeException((Throwable)u);
        }, filter);
    }

    public static boolean copyRecursively(@This File thiz, File target, boolean overwrite, BiFunction<File, IOException, OnErrorAction> onError) {
        return ManFileExt.copyRecursively(thiz, target, overwrite, onError, file -> true);
    }

    public static boolean copyRecursively(@This File thiz, File target, boolean overwrite, BiFunction<File, IOException, OnErrorAction> onError, Predicate<File> filter) {
        if (!thiz.exists()) {
            return OnErrorAction.TERMINATE != onError.apply(thiz, new NoSuchFileException(thiz.toString(), null, "The source file doesn't exist."));
        }
        for (File src : ManFileExt.walkTopDown(thiz).onFail((f, e) -> {
            if (onError.apply((File)f, (IOException)e) == OnErrorAction.TERMINATE) {
                throw new RuntimeException(new TerminateException(f.toString()));
            }
        })) {
            if (!filter.test(src)) continue;
            if (!src.exists()) {
                if (OnErrorAction.TERMINATE != onError.apply(src, new NoSuchFileException(src.toString(), null, "The source file doesn't exist."))) continue;
                return false;
            }
            String relPath = ManFileExt.toRelativeString(src, thiz);
            File dstFile = new File(target, relPath);
            if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                boolean stillExists;
                if (!overwrite) {
                    stillExists = true;
                } else if (dstFile.isDirectory()) {
                    stillExists = !ManFileExt.deleteRecursively(dstFile);
                } else {
                    boolean bl = stillExists = !dstFile.delete();
                }
                if (stillExists) {
                    if (OnErrorAction.TERMINATE != onError.apply(dstFile, new FileAlreadyExistsException(src.toString(), dstFile.toString(), "The destination file already exists."))) continue;
                    return false;
                }
            }
            if (src.isDirectory()) {
                dstFile.mkdirs();
                continue;
            }
            if (ManFileExt.copyTo(src, dstFile, overwrite, 8192).length() == src.length() || OnErrorAction.TERMINATE != onError.apply(src, new IOException("Source file wasn't copied completely, length of destination file differs."))) continue;
            return false;
        }
        return true;
    }

    public static FileTreeWalk walk(@This File thiz, FileTreeWalk.FileWalkDirection direction) {
        return new FileTreeWalk(thiz, direction);
    }

    public static FileTreeWalk walkTopDown(@This File thiz) {
        return ManFileExt.walk(thiz, FileTreeWalk.FileWalkDirection.TOP_DOWN);
    }

    public static FileTreeWalk walkBottomUp(@This File thiz) {
        return ManFileExt.walk(thiz, FileTreeWalk.FileWalkDirection.BOTTOM_UP);
    }

    public static boolean deleteRecursively(@This File thiz) {
        return ManIterableExt.fold(ManFileExt.walkBottomUp(thiz), true, (res, it) -> (it.delete() || !it.exists()) && res != false);
    }

    public static boolean startsWith(@This File thiz, File other) {
        FilePathComponents components = ManFileExt.toComponents(thiz);
        FilePathComponents otherComponents = ManFileExt.toComponents(other);
        if (components.root != otherComponents.root) {
            return false;
        }
        return components.size() >= otherComponents.size() && components.segments.subList(0, otherComponents.size()).equals(otherComponents.segments);
    }

    public static boolean startsWith(@This File thiz, String other) {
        return ManFileExt.startsWith(thiz, new File(other));
    }

    public static boolean endsWith(@This File thiz, File other) {
        FilePathComponents components = ManFileExt.toComponents(thiz);
        FilePathComponents otherComponents = ManFileExt.toComponents(other);
        if (otherComponents.isRooted()) {
            return thiz.equals(other);
        }
        int shift = components.size() - otherComponents.size();
        return shift >= 0 && components.segments.subList(shift, components.size()).equals(otherComponents.segments);
    }

    public static boolean endsWith(@This File thiz, String other) {
        return ManFileExt.endsWith(thiz, new File(other));
    }

    public static File normalize(@This File thiz) {
        FilePathComponents comps = ManFileExt.toComponents(thiz);
        return ManFileExt.resolve(comps.root, ManIterableExt.joinToString(ManFileExt.normalize(comps.segments), File.separator));
    }

    public static List<File> normalize(List<File> segments) {
        ArrayList<File> list = new ArrayList<File>(segments.size());
        block8: for (File file : segments) {
            switch (file.getName()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (!list.isEmpty() && !ManifoldListCollectionExt.last(list).getName().equals("..")) {
                        list.remove(list.size() - 1);
                        continue block8;
                    }
                    list.add(file);
                    continue block8;
                }
            }
            list.add(file);
        }
        return list;
    }

    public static File resolve(@This File thiz, File relative) {
        if (ManFileExt.isRooted(relative)) {
            return relative;
        }
        String baseName = thiz.toString();
        return baseName.isEmpty() || baseName.endsWith(File.separator) ? new File(baseName + relative) : new File(baseName + '\u0000' + relative);
    }

    public static File resolve(@This File thiz, String relative) {
        return ManFileExt.resolve(thiz, new File(relative));
    }

    public static File resolveSibling(@This File thiz, File relative) {
        FilePathComponents components = ManFileExt.toComponents(thiz);
        File parentSubPath = components.size() == 0 ? new File("..") : components.subPath(0, components.size() - 1);
        return ManFileExt.resolve(ManFileExt.resolve(components.root, parentSubPath), relative);
    }

    public static File resolveSibling(@This File thiz, String relative) {
        return ManFileExt.resolveSibling(thiz, new File(relative));
    }

    static {
        Bootstrap.init();
    }

    private static class TerminateException
    extends FileSystemException {
        TerminateException(String file) {
            super(file);
        }

        static {
            Bootstrap.init();
        }
    }

    public static enum OnErrorAction {
        SKIP,
        TERMINATE;


        static {
            Bootstrap.init();
        }
    }
}

