/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime.protocols;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.InMemoryClassJavaFileObject;
import manifold.internal.javac.JavaCompileIssuesException;
import manifold.internal.javac.JavaParser;
import manifold.internal.javac.StringJavaFileObject;
import manifold.util.Pair;
import manifold.util.PerfLogUtil;

public class ManClassesUrlConnection
extends URLConnection {
    private static final boolean DUMP_CLASSFILES = false;
    private static final String[] JAVA_NAMESPACES_TO_IGNORE = new String[]{"java/", "javax/", "sun/"};
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final ThreadLocal<Map<String, Supplier<String>>> _proxySupplierByFqn = ThreadLocal.withInitial(HashMap::new);
    private Supplier<byte[]> _bytecodeSupplier;
    private JavaFileObject _javaSrcFile;
    private Supplier<String> _proxySupplier;
    private String _javaFqn;
    private ClassLoader _loader;
    private boolean _bDirectory;
    private boolean _bInvalid;

    public static Supplier<String> getProxySupplier(String fqnProxy) {
        return _proxySupplierByFqn.get().get(fqnProxy);
    }

    public static void putProxySupplier(String fqnProxy, Supplier<String> supplier) {
        _proxySupplierByFqn.get().put(fqnProxy, supplier);
    }

    public static void removeProxySupplier(String fqnProxy) {
        _proxySupplierByFqn.get().remove(fqnProxy);
    }

    ManClassesUrlConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this._bInvalid) {
            throw new IOException();
        }
        this.connectImpl();
        if (this._bInvalid) {
            throw new IOException();
        }
    }

    private boolean connectImpl() {
        if (this._bInvalid) {
            return false;
        }
        if (this._bytecodeSupplier == null && this._javaSrcFile == null && this._proxySupplier == null && !this._bDirectory) {
            String strPath = URLDecoder.decode(this.getURL().getPath());
            String strClass = strPath.substring(1);
            if (this.isManifest(strClass)) {
                return true;
            }
            if (!this.ignoreJavaClass(strClass)) {
                String strType = strClass.replace('/', '.');
                int iIndexClass = strType.lastIndexOf(".class");
                if (iIndexClass > 0) {
                    strType = strType.substring(0, iIndexClass).replace('$', '.');
                    this.maybeAssignType(this.findClassLoader(this.getURL().getHost()), strType);
                } else if (strPath.endsWith("/")) {
                    this._bDirectory = true;
                }
            }
            this._bInvalid = this._bytecodeSupplier == null && this._javaSrcFile == null && this._proxySupplier == null && !this._bDirectory;
        }
        return !this._bInvalid;
    }

    private boolean isManifest(String strClass) {
        return strClass.equalsIgnoreCase(META_INF_MANIFEST_MF);
    }

    private ClassLoader findClassLoader(String host) {
        int identityHash = Integer.parseInt(host);
        for (ClassLoader loader = ManifoldHost.getActualClassLoader(); loader != null; loader = loader.getParent()) {
            if (System.identityHashCode(loader) != identityHash) continue;
            return loader;
        }
        throw new IllegalStateException("Can't find ClassLoader with identity hash: " + identityHash);
    }

    private void maybeAssignType(ClassLoader loader, String strType) {
        Supplier<String> proxySupplier = ManClassesUrlConnection.getProxySupplier(strType);
        if (proxySupplier != null) {
            ManClassesUrlConnection.removeProxySupplier(strType);
            this._proxySupplier = proxySupplier;
            this._javaFqn = strType;
            this._loader = loader;
            return;
        }
        ManifoldHost.maybeAssignType(loader, strType, this.getURL(), (fqn, type) -> {
            if (fqn != null) {
                try {
                    Pair<JavaFileObject, String> pair = JavaParser.instance().findJavaSource((String)fqn, (DiagnosticListener<JavaFileObject>)new DiagnosticCollector<JavaFileObject>());
                    if (pair != null) {
                        this._javaSrcFile = pair.getFirst();
                        this._javaFqn = fqn;
                        this._loader = loader;
                    }
                }
                catch (NoClassDefFoundError e) {
                    System.out.println("\n!!! Unable to dynamically compile Java from source.  tools.jar is likely missing from classpath.\n");
                }
            } else if (type != null) {
                this._bytecodeSupplier = type;
                this._loader = loader;
            }
        });
    }

    private boolean ignoreJavaClass(String strClass) {
        for (String namespace : JAVA_NAMESPACES_TO_IGNORE) {
            if (!strClass.startsWith(namespace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._bytecodeSupplier != null || this._javaSrcFile != null || this._proxySupplier != null) {
            return new LazyByteArrayInputStream();
        }
        if (this._bDirectory) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.getURL().getPath().toUpperCase().endsWith(META_INF_MANIFEST_MF)) {
            return new ByteArrayInputStream(new byte[0]);
        }
        throw new IOException("Invalid or missing Manifold class for: " + this.url.toString());
    }

    public boolean isValid() {
        return this.connectImpl();
    }

    class LazyByteArrayInputStream
    extends InputStream {
        byte[] _buf;
        int _pos;
        int _mark;
        int _count;

        LazyByteArrayInputStream() {
        }

        private void init() {
            if (this._buf == null) {
                ManifoldHost.performLockedOperation(ManClassesUrlConnection.this._loader, () -> {
                    if (ManClassesUrlConnection.this._bytecodeSupplier != null) {
                        this._buf = (byte[])ManClassesUrlConnection.this._bytecodeSupplier.get();
                    } else if (ManClassesUrlConnection.this._javaSrcFile != null) {
                        this._buf = this.compileJavaClass();
                    } else if (ManClassesUrlConnection.this._proxySupplier != null) {
                        this._buf = this.compileProxyClass((String)ManClassesUrlConnection.this._proxySupplier.get());
                    }
                    this._pos = 0;
                    this._count = this._buf.length;
                    this.writeClassFile_Debug();
                });
            }
        }

        private void writeClassFile_Debug() {
        }

        private byte[] compileJavaClass() {
            long before = System.nanoTime();
            try {
                DiagnosticCollector<JavaFileObject> errorHandler = new DiagnosticCollector<JavaFileObject>();
                InMemoryClassJavaFileObject cls = JavaParser.instance().compile(ManClassesUrlConnection.this._javaFqn, Arrays.asList("-source", "8", "-g", "-nowarn", "-Xlint:none", "-proc:none", "-parameters"), errorHandler);
                if (cls != null) {
                    byte[] byArray = cls.getBytes();
                    return byArray;
                }
                throw new JavaCompileIssuesException(ManClassesUrlConnection.this._javaFqn, errorHandler);
            }
            finally {
                PerfLogUtil.log("compileJavaClass() " + ManClassesUrlConnection.this._javaFqn, before);
            }
        }

        private byte[] compileProxyClass(String source) {
            long before = System.nanoTime();
            try {
                DiagnosticCollector<JavaFileObject> errorHandler = new DiagnosticCollector<JavaFileObject>();
                StringJavaFileObject fileObj = new StringJavaFileObject(ManClassesUrlConnection.this._javaFqn, source);
                InMemoryClassJavaFileObject cls = JavaParser.instance().compile(fileObj, ManClassesUrlConnection.this._javaFqn, Arrays.asList("-source", "8", "-g", "-nowarn", "-Xlint:none", "-proc:none", "-parameters"), errorHandler);
                if (cls != null) {
                    byte[] byArray = cls.getBytes();
                    return byArray;
                }
                throw new JavaCompileIssuesException(ManClassesUrlConnection.this._javaFqn, errorHandler);
            }
            finally {
                PerfLogUtil.log("compileProxyClass() " + ManClassesUrlConnection.this._javaFqn, before);
            }
        }

        @Override
        public int read() {
            this.init();
            return this._pos < this._count ? this._buf[this._pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.init();
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            this.init();
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (this._pos >= this._count) {
                return -1;
            }
            if (this._pos + len > this._count) {
                len = this._count - this._pos;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this._buf, this._pos, b, off, len);
            this._pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            if ((long)this._pos + n > (long)this._count) {
                n = this._count - this._pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this._pos = (int)((long)this._pos + n);
            return n;
        }

        @Override
        public int available() {
            this.init();
            return this._count - this._pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this._mark = this._pos;
        }

        @Override
        public void reset() {
            this._pos = this._mark;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

