/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import manifold.internal.runtime.ManModuleReader;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class UrlClassLoaderWrapper {
    private static final Set<Integer> VISITED_LOADER_IDS = new HashSet<Integer>();
    private final ClassLoader _loader;
    private final MethodAndReceiver _getURLs;
    private final MethodAndReceiver _addUrl;

    static UrlClassLoaderWrapper wrapIfNotAlreadyVisited(ClassLoader loader) {
        int loaderId = System.identityHashCode(loader);
        if (VISITED_LOADER_IDS.contains(loaderId)) {
            return null;
        }
        VISITED_LOADER_IDS.add(loaderId);
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrap(loader);
        if (wrapped == null) {
            throw new IllegalStateException("Could not wrap loader: " + loader.getClass().getName());
        }
        return wrapped;
    }

    public static UrlClassLoaderWrapper wrap(ClassLoader loader) {
        MethodAndReceiver addUrl;
        MethodAndReceiver getURLs = UrlClassLoaderWrapper.findLoaderMethod(loader, "getURLs", new Class[0], List.class, URL[].class);
        if (getURLs != null && (addUrl = UrlClassLoaderWrapper.findLoaderMethod(loader, "addUrl", new Class[]{URL.class}, null)) != null) {
            return new UrlClassLoaderWrapper(loader, getURLs, addUrl);
        }
        return null;
    }

    private static MethodAndReceiver findLoaderMethod(ClassLoader cls, String methodName, Class[] paramTypes, Class ... returnType) {
        Field ucpField;
        Object receiver = cls;
        Method method = UrlClassLoaderWrapper.findMethod(cls.getClass(), methodName, paramTypes, returnType);
        if (method == null && (ucpField = UrlClassLoaderWrapper.findField(cls.getClass(), "ucp")) != null && (method = UrlClassLoaderWrapper.findMethod(ucpField.getType(), methodName, paramTypes, returnType)) != null) {
            try {
                ucpField.setAccessible(true);
                receiver = ucpField.get(cls);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (method != null) {
            method.setAccessible(true);
            return new MethodAndReceiver(method, receiver);
        }
        return null;
    }

    private static Method findMethod(Class cls, String methodName, Class[] paramTypes, Class[] returnTypes) {
        block0: for (Method m : cls.getDeclaredMethods()) {
            Class<?>[] types;
            if (!m.getName().equalsIgnoreCase(methodName) || (types = m.getParameterTypes()).length != paramTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].equals(types[i])) continue block0;
            }
            if (returnTypes == null) {
                return m;
            }
            for (Class t : returnTypes) {
                if (!t.isAssignableFrom(m.getReturnType())) continue;
                m.setAccessible(true);
                return m;
            }
        }
        return cls.getSuperclass() != null ? UrlClassLoaderWrapper.findMethod(cls.getSuperclass(), methodName, paramTypes, returnTypes) : null;
    }

    private static Field findField(Class<?> cls, String fieldName) {
        for (Field f : cls.getDeclaredFields()) {
            if (!f.getName().equalsIgnoreCase(fieldName)) continue;
            return f;
        }
        return cls.getSuperclass() != null ? UrlClassLoaderWrapper.findField(cls.getSuperclass(), fieldName) : null;
    }

    private UrlClassLoaderWrapper(ClassLoader loader, MethodAndReceiver getURLs, MethodAndReceiver addUrl) {
        this._loader = loader;
        this._getURLs = getURLs;
        this._addUrl = addUrl;
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    public void addURL(URL url) {
        try {
            this._addUrl._method.invoke(this._addUrl._receiver, url);
            if (JreUtil.isJava9Modular_runtime()) {
                this.wrapReaders();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void wrapReaders() {
        Map moduleToReader = (Map)ReflectUtil.field(this._loader, "moduleToReader").get();
        for (Object mr : moduleToReader.keySet()) {
            String scheme;
            Optional location = (Optional)ReflectUtil.method(mr, "location", new Class[0]).invoke(new Object[0]);
            URI uri = location.orElse(null);
            if (uri == null || !(scheme = uri.getScheme()).equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("jar")) continue;
            Object reader = moduleToReader.get(mr);
            Class<?> moduleReaderClass = ReflectUtil.type("java.lang.module.ModuleReader");
            ManModuleReader wrapper = new ManModuleReader(reader, ReflectUtil.field(this._loader, "ucp").get());
            Object proxy = Proxy.newProxyInstance(moduleReaderClass.getClassLoader(), new Class[]{moduleReaderClass}, (InvocationHandler)new ManModuleReaderInvocationHandler(wrapper));
            moduleToReader.put(mr, proxy);
        }
    }

    public List<URL> getURLs() {
        if (this._loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this._loader).getURLs();
            return urls == null ? Collections.emptyList() : Arrays.asList(urls);
        }
        ArrayList<URL> allUrls = new ArrayList<URL>(this.getClasspathUrls());
        if (JreUtil.isJava9Modular_runtime()) {
            allUrls.addAll(this.getModularUrls());
        }
        return Collections.unmodifiableList(allUrls);
    }

    private Set<URL> getModularUrls() {
        ReflectUtil.LiveFieldRef nameToModuleField;
        try {
            nameToModuleField = ReflectUtil.field(this._loader, "nameToModule");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashSet<URL> modulePath = new HashSet<URL>();
        Map nameToModule = (Map)nameToModuleField.get();
        for (Object mr : nameToModule.values()) {
            String scheme;
            Optional location = (Optional)ReflectUtil.method(mr, "location", new Class[0]).invoke(new Object[0]);
            URI uri = location.orElse(null);
            if (uri == null || !(scheme = uri.getScheme()).equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("jar")) continue;
            try {
                modulePath.add(new File(uri).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return modulePath;
    }

    private List<URL> getClasspathUrls() {
        try {
            List<URL> urls;
            List<URL> list = urls = this._getURLs._receiver == null ? null : this._getURLs._method.invoke(this._getURLs._receiver, new Object[0]);
            urls = urls == null ? Collections.emptyList() : (urls.getClass().isArray() ? Arrays.asList((URL[])urls) : urls);
            return urls;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MethodAndReceiver {
        Method _method;
        Object _receiver;

        MethodAndReceiver(Method method, Object receiver) {
            this._method = method;
            this._receiver = receiver;
        }
    }

    private static class ManModuleReaderInvocationHandler
    implements InvocationHandler {
        private final Object _wrapper;

        private ManModuleReaderInvocationHandler(Object wrapper) {
            this._wrapper = wrapper;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return ReflectUtil.method(this._wrapper, method.getName(), (Class[])method.getParameterTypes()).invoke(args);
        }
    }
}

