/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import manifold.internal.host.ManifoldHost;
import manifold.internal.runtime.UrlClassLoaderWrapper;

public class Bootstrap {
    public static final String MAN_CLASS_PROTOCOL = "manifoldclass";
    private static final String PROTOCOL_PACKAGE = "manifold.internal.runtime.protocols";
    private static Boolean CAN_WRAP = Boolean.FALSE;
    private static boolean _busy = false;

    private static void setupLoaderChainWithManifoldUrl(ClassLoader loader) {
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrapIfNotAlreadyVisited(loader);
        if (wrapped == null) {
            return;
        }
        Bootstrap.addManifoldClassUrl(wrapped);
        if (Bootstrap.canWrapChain() && loader != ClassLoader.getSystemClassLoader() && (loader = loader.getParent()) != null) {
            Bootstrap.setupLoaderChainWithManifoldUrl(loader);
        }
    }

    private static boolean canWrapChain(ClassLoader loader) {
        boolean bSysLoader;
        if (loader == null) {
            return false;
        }
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrap(loader);
        boolean bl = bSysLoader = loader == ClassLoader.getSystemClassLoader();
        if (bSysLoader) {
            return wrapped != null;
        }
        loader = loader.getParent();
        return wrapped != null && Bootstrap.canWrapChain(loader);
    }

    private static void addManifoldClassUrl(UrlClassLoaderWrapper urlLoader) {
        try {
            URL url = Bootstrap.makeUrl(urlLoader.getLoader());
            if (!urlLoader.getURLs().contains(url)) {
                urlLoader.addURL(url);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL makeUrl(ClassLoader loader) throws MalformedURLException {
        int loaderAddress = System.identityHashCode(loader);
        String spec = "manifoldclass://" + loaderAddress + "/";
        Bootstrap.addOurProtocolHandler();
        URL url = new URL(null, spec);
        return url;
    }

    public static void addOurProtocolHandler() {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Method put = Hashtable.class.getMethod("put", Object.class, Object.class);
            Field instanceField = Class.forName("manifold.internal.runtime.protocols.Handler").getField("INSTANCE");
            Object handler = instanceField.get(null);
            put.invoke(field.get(null), MAN_CLASS_PROTOCOL, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure manifold protocol handler", e);
        }
    }

    private static void removeOurProtocolHandler() {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Method remove = Hashtable.class.getMethod("remove", Object.class);
            remove.invoke(field.get(null), MAN_CLASS_PROTOCOL);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to cleanup manifold protocol handler", e);
        }
    }

    private static boolean addOurProtocolPackage() {
        String strProtocolProp = "java.protocol.handler.pkgs";
        String protocols = PROTOCOL_PACKAGE;
        String oldProp = System.getProperty(strProtocolProp);
        if (oldProp != null) {
            if (oldProp.contains(PROTOCOL_PACKAGE)) {
                return false;
            }
            protocols = protocols + '|' + oldProp;
        }
        System.setProperty(strProtocolProp, protocols);
        return true;
    }

    private static void removeOurProtocolPackage() {
        String strProtocolProp = "java.protocol.handler.pkgs";
        String protocols = System.getProperty(strProtocolProp);
        if (protocols != null) {
            protocols = protocols.replace("manifold.internal.runtime.protocols|", "");
            System.setProperty(strProtocolProp, protocols);
        }
    }

    public static synchronized boolean init() {
        if (_busy) {
            return false;
        }
        _busy = true;
        try {
            ClassLoader loader;
            if (Bootstrap.addOurProtocolPackage()) {
                ManifoldHost.bootstrap();
            }
            if ((loader = ManifoldHost.getActualClassLoader()) != null) {
                Bootstrap.setupLoaderChainWithManifoldUrl(loader);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            _busy = false;
        }
    }

    public static boolean canWrapChain() {
        return CAN_WRAP == null ? (CAN_WRAP = Boolean.valueOf(Bootstrap.canWrapChain(ManifoldHost.getActualClassLoader()))) : CAN_WRAP;
    }

    public static synchronized void cleanup() {
        Bootstrap.removeOurProtocolPackage();
        Bootstrap.removeOurProtocolHandler();
    }
}

