/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import manifold.api.fs.IDirectory;
import manifold.internal.host.ManifoldHost;

public class WriterJavaFileObject
extends SimpleJavaFileObject {
    private OutputStream _outputStream;

    public WriterJavaFileObject(String fqn) {
        super(WriterJavaFileObject.getUriFrom(fqn), JavaFileObject.Kind.CLASS);
    }

    public WriterJavaFileObject(String pkg, String filename) {
        super(WriterJavaFileObject.getUriFrom(pkg, filename), JavaFileObject.Kind.OTHER);
    }

    private static URI getUriFrom(String fqn) {
        String outRelativePath = fqn.replace('.', File.separatorChar) + ".class";
        IDirectory outputPath = ManifoldHost.getGlobalModule().getOutputPath().stream().findFirst().orElse(null);
        File file = new File(outputPath.getPath().getFileSystemPathString(), outRelativePath);
        return file.toURI();
    }

    private static URI getUriFrom(String fqn, String filename) {
        String outRelativePath = fqn.replace('.', File.separatorChar) + File.separatorChar + filename;
        IDirectory outputPath = ManifoldHost.getGlobalModule().getOutputPath().stream().findFirst().orElse(null);
        File file = new File(outputPath.getPath().getFileSystemPathString(), outRelativePath);
        return file.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream openOutputStream() throws IOException {
        this.throwIfInUse();
        WriterJavaFileObject writerJavaFileObject = this;
        synchronized (writerJavaFileObject) {
            this.throwIfInUse();
            File file = new File(this.toUri());
            if (!file.isFile()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this._outputStream = new BufferedOutputStream(new FileOutputStream(file));
            return this._outputStream;
        }
    }

    private void throwIfInUse() throws IOException {
        if (this._outputStream != null) {
            throw new IOException("OutputStream in use");
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

