/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.util.JavacTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.CompiledTypeProcessor;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;

public class TypeProcessor
extends CompiledTypeProcessor {
    TypeProcessor(JavacTask javacTask) {
        super(javacTask);
    }

    @Override
    public void process(TypeElement element, IssueReporter<JavaFileObject> issueReporter) {
        if (IDynamicJdk.isInitializing()) {
            return;
        }
        for (ITypeManifold sp : ManifoldHost.getCurrentModule().getTypeManifolds()) {
            if (!(sp instanceof ITypeProcessor)) continue;
            try {
                ((ITypeProcessor)((Object)sp)).process(element, this, issueReporter);
            }
            catch (Throwable e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                issueReporter.reportError("Fatal error processing with Manifold type processor: " + sp.getClass().getName() + "\non type: " + element.getQualifiedName() + "\nPlease report the error with the accompanying stack trace.\n" + stackTrace);
                throw e;
            }
        }
    }
}

