/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.internal.javac.JavacPlugin;
import manifold.util.ReflectUtil;

public class JavacFileManagerBridge<M extends JavaFileManager>
extends JavacFileManager {
    private final M fileManager;

    JavacFileManagerBridge(M fileManager, Context context) {
        super(context, false, Charset.defaultCharset());
        this.fileManager = fileManager;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.fileManager.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fileManager.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        Iterable<Path> iter;
        if (JavacPlugin.IS_JAVA_8) {
            return this.fileManager.hasLocation(location);
        }
        boolean hasLocation = this.fileManager.hasLocation(location);
        if (hasLocation && ((iter = this.getLocationAsPaths(location)) == null || !iter.iterator().hasNext())) {
            hasLocation = false;
        }
        return hasLocation;
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        try {
            return (Iterable)ReflectUtil.method(this.fileManager, "getLocationAsPaths", JavaFileManager.Location.class).invoke(location);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fileManager.isSupportedOption(option);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.fileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.fileManager.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() {
        try {
            this.fileManager.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.fileManager.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        try {
            Method getLocationForModule = JavaFileManager.class.getDeclaredMethod("getLocationForModule", JavaFileManager.Location.class, String.class);
            return (JavaFileManager.Location)getLocationForModule.invoke(this.fileManager, location, moduleName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        try {
            Method getLocationForModule = JavaFileManager.class.getDeclaredMethod("getLocationForModule", JavaFileManager.Location.class, JavaFileObject.class);
            return (JavaFileManager.Location)getLocationForModule.invoke(this.fileManager, location, fo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        try {
            Method getServiceLoader = JavaFileManager.class.getDeclaredMethod("getServiceLoader", JavaFileManager.Location.class, Class.class);
            return (ServiceLoader)getServiceLoader.invoke(this.fileManager, location, service);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        try {
            Method inferModuleName = JavaFileManager.class.getDeclaredMethod("inferModuleName", JavaFileManager.Location.class);
            return (String)inferModuleName.invoke(this.fileManager, location);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        try {
            Method listLocationsForModules = JavaFileManager.class.getDeclaredMethod("listLocationsForModules", JavaFileManager.Location.class);
            return (Iterable)listLocationsForModules.invoke(this.fileManager, location);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        try {
            Method contains = JavaFileManager.class.getDeclaredMethod("contains", JavaFileManager.Location.class, FileObject.class);
            return (Boolean)contains.invoke(this.fileManager, location, fo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

