/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import manifold.api.fs.IResource;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModule;
import manifold.api.host.ITypeLoaderListener;
import manifold.api.host.RefreshRequest;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.JavaParser;
import manifold.internal.javac.SrcClassUtil;
import manifold.util.ManClassUtil;
import manifold.util.Pair;

public class ClassSymbols {
    private static final Map<IModule, ClassSymbols> INSTANCES = new ConcurrentHashMap<IModule, ClassSymbols>();
    private final IModule _module;
    private JavacTool _javacTool;
    private volatile StandardJavaFileManager _fm;

    public static ClassSymbols instance(IModule module) {
        ClassSymbols classSymbols = INSTANCES.get(module);
        if (classSymbols == null) {
            classSymbols = new ClassSymbols(module);
            INSTANCES.put(module, classSymbols);
        }
        return classSymbols;
    }

    private ClassSymbols(IModule module) {
        this._module = module;
        ManifoldHost.addTypeLoaderListenerAsWeakRef(module, new CacheClearer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this._fm != null) {
            return;
        }
        ClassSymbols classSymbols = this;
        synchronized (classSymbols) {
            if (this._fm != null) {
                return;
            }
            this._javacTool = JavacTool.create();
            StandardJavaFileManager fm = this._javacTool.getStandardFileManager((DiagnosticListener)null, (Locale)null, Charset.forName("UTF-8"));
            try {
                fm.setLocation(StandardLocation.SOURCE_PATH, this._module.getCollectiveSourcePath().stream().map(IResource::toJavaFile).collect(Collectors.toList()));
                fm.setLocation(StandardLocation.CLASS_PATH, this._module.getCollectiveJavaClassPath().stream().map(IResource::toJavaFile).collect(Collectors.toList()));
                this._fm = fm;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BasicJavacTask getJavacTask() {
        this.init();
        StringWriter errors = new StringWriter();
        BasicJavacTask task = (BasicJavacTask)this._javacTool.getTask((Writer)errors, (JavaFileManager)this._fm, (DiagnosticListener)null, Arrays.asList("-proc:none", "-source", "1.8", "-Xprefer:source"), (Iterable)null, (Iterable)null);
        if (errors.getBuffer().length() > 0) {
            System.err.println(errors.getBuffer());
        }
        return task;
    }

    public Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(BasicJavacTask javacTask, String fqn) {
        JavacElements elementUtils = JavacElements.instance(javacTask.getContext());
        Symbol.ClassSymbol typeElement = elementUtils.getTypeElement(fqn);
        if (typeElement == null) {
            return this.getClassSymbolForProducedClass(fqn, new BasicJavacTask[1]);
        }
        JavacTrees trees = JavacTrees.instance(javacTask.getContext());
        TreePath path = trees.getPath(typeElement);
        if (path != null) {
            return new Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit>(typeElement, (JCTree.JCCompilationUnit)path.getCompilationUnit());
        }
        return new Pair<Symbol.ClassSymbol, Object>(typeElement, null);
    }

    public SrcClass makeSrcClassStub(String fqn) {
        return this.makeSrcClassStub(fqn, null, null);
    }

    public SrcClass makeSrcClassStub(String fqn, BasicJavacTask[] javacTaskOut, JCTree.JCCompilationUnit[] compUnit) {
        Symbol.ClassSymbol classSymbol;
        BasicJavacTask javacTask = javacTaskOut != null && javacTaskOut[0] != null ? javacTaskOut[0] : this.getJavacTask();
        Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> pair = this.getClassSymbol(javacTask, fqn);
        if (compUnit != null) {
            compUnit[0] = pair.getSecond();
        }
        if (javacTaskOut != null) {
            javacTaskOut[0] = javacTask;
        }
        if ((classSymbol = pair.getFirst()) == null) {
            return this.makeSrcClassStubFromProducedClass(fqn, compUnit);
        }
        return SrcClassUtil.instance().makeStub(this._module, fqn, classSymbol, pair.getSecond(), javacTask);
    }

    private SrcClass makeSrcClassStubFromProducedClass(String fqn, JCTree.JCCompilationUnit[] compUnit) {
        BasicJavacTask[] task = new BasicJavacTask[1];
        Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> pair = this.getClassSymbolForProducedClass(fqn, task);
        if (compUnit != null) {
            compUnit[0] = pair.getSecond();
        }
        Symbol.ClassSymbol classSymbol = pair.getFirst();
        return SrcClassUtil.instance().makeStub(this._module, fqn, classSymbol, pair.getSecond(), task[0]);
    }

    private Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbolForProducedClass(String fqn, BasicJavacTask[] task) {
        this.init();
        Pair<JavaFileObject, String> fileObj = JavaParser.instance().findJavaSource(fqn, null);
        if (fileObj == null) {
            return null;
        }
        StringWriter errors = new StringWriter();
        task[0] = (BasicJavacTask)this._javacTool.getTask((Writer)errors, (JavaFileManager)this._fm, (DiagnosticListener)null, Arrays.asList("-proc:none", "-source", "1.8", "-Xprefer:source"), (Iterable)null, Collections.singleton(fileObj.getFirst()));
        try {
            Iterable<? extends Element> elements = task[0].analyze();
            for (Element element : elements) {
                if (!(element instanceof Symbol.ClassSymbol) || !element.getSimpleName().contentEquals(ManClassUtil.getShortClassName(fqn))) continue;
                JavacTrees trees = JavacTrees.instance(task[0].getContext());
                TreePath path = trees.getPath(element);
                if (path != null) {
                    return new Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit>((Symbol.ClassSymbol)element, (JCTree.JCCompilationUnit)path.getCompilationUnit());
                }
                return new Pair<Symbol.ClassSymbol, Object>((Symbol.ClassSymbol)element, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StringBuffer errorText = errors.getBuffer();
        if (errorText.length() > 0) {
            throw new RuntimeException("Compile errors:\n" + errorText);
        }
        return null;
    }

    private class CacheClearer
    implements ITypeLoaderListener {
        private CacheClearer() {
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
        }

        @Override
        public void refreshed() {
            INSTANCES.remove(ClassSymbols.this._module);
        }
    }
}

