/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import manifold.api.host.NoBootstrap;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.runtime.Bootstrap;

class BootstrapInserter
extends TreeTranslator {
    private JavacPlugin _javacJacker;

    public BootstrapInserter(JavacPlugin javacJacker) {
        this._javacJacker = javacJacker;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        if (tree.sym != null && !tree.sym.isInner() && this.okToInsertBootstrap(tree)) {
            JCTree.JCStatement newNode = this.buildBootstrapStaticBlock();
            ArrayList<JCTree> newDefs = new ArrayList<JCTree>(tree.defs);
            newDefs.add(0, newNode);
            tree.defs = List.from(newDefs);
        }
        this.result = tree;
    }

    private boolean okToInsertBootstrap(JCTree.JCClassDecl tree) {
        return !this.annotatedWith_NoBootstrap((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations()) && !JavacPlugin.instance().isNoBootstrapping() && !this.skipForOtherReasons(tree);
    }

    private boolean skipForOtherReasons(JCTree.JCClassDecl tree) {
        if ((tree.getModifiers().flags & 0x2000L) != 0L) {
            return true;
        }
        if (tree.implementing != null) {
            for (JCTree.JCExpression iface : tree.implementing) {
                if (!iface.toString().contains("IManifoldHost")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean annotatedWith_NoBootstrap(List<JCTree.JCAnnotation> annotations) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().toString().endsWith(NoBootstrap.class.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private JCTree.JCStatement buildBootstrapStaticBlock() {
        TreeMaker make = this._javacJacker.getTreeMaker();
        JavacElements javacElems = this._javacJacker.getJavacElements();
        JCTree.JCMethodInvocation bootstrapInitCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, Bootstrap.class.getName() + ".init"), List.nil());
        return make.Block(8L, List.of(make.Exec(bootstrapInitCall)));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return this.memberAccess(make, javacElems, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }
}

