/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.script.Bindings;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFileSystem;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.host.ITypeLoaderListener;
import manifold.api.type.TypeName;
import manifold.internal.host.DefaultManifoldHost;

public class ManifoldHost {
    private static volatile IManifoldHost HOST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IManifoldHost host() {
        if (HOST != null) return HOST;
        Class<ManifoldHost> clazz = ManifoldHost.class;
        synchronized (ManifoldHost.class) {
            DefaultManifoldHost host;
            if (HOST != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return HOST;
            }
            try {
                ServiceLoader<IManifoldHost> loader = ServiceLoader.load(IManifoldHost.class, ManifoldHost.class.getClassLoader());
                Iterator<IManifoldHost> iterator = loader.iterator();
                if (iterator.hasNext()) {
                    IManifoldHost host2 = iterator.next();
                    while (host2 != null && !host2.accept()) {
                        host2 = iterator.hasNext() ? iterator.next() : null;
                    }
                    HOST = host2;
                    if (iterator.hasNext()) {
                        System.out.println("WARNING: Found multiple Manifold hosts, using first encountered: " + HOST.getClass().getName());
                    }
                } else {
                    loader = ServiceLoader.load(IManifoldHost.class);
                    iterator = loader.iterator();
                    if (iterator.hasNext()) {
                        IManifoldHost host3 = iterator.next();
                        while (host3 != null && !host3.accept()) {
                            host3 = iterator.hasNext() ? iterator.next() : null;
                        }
                        HOST = host3;
                        if (iterator.hasNext()) {
                            System.out.println("WARNING: Found multiple Manifold hosts, using first encountered: " + HOST.getClass().getName());
                        }
                    }
                }
            }
            catch (ServiceConfigurationError e) {
                e.printStackTrace();
            }
            if (HOST != null || !(host = new DefaultManifoldHost()).accept()) return HOST;
            HOST = host;
            // ** MonitorExit[var0] (shouldn't be in output)
            return HOST;
        }
    }

    public static IManifoldHost instance() {
        return ManifoldHost.host();
    }

    public static IFileSystem getFileSystem() {
        return ManifoldHost.host().getFileSystem();
    }

    public static ClassLoader getActualClassLoader() {
        return ManifoldHost.host().getActualClassLoader();
    }

    public static void bootstrap() {
        ManifoldHost.bootstrap(Collections.emptyList(), Collections.emptyList());
    }

    public static void bootstrap(List<File> sourcepath, List<File> classpath) {
        ManifoldHost.host().bootstrap(sourcepath, classpath);
    }

    public static IModule getGlobalModule() {
        return ManifoldHost.host().getGlobalModule();
    }

    public static IModule getCurrentModule() {
        return ManifoldHost.host().getCurrentModule();
    }

    public static void resetLanguageLevel() {
        ManifoldHost.host().resetLanguageLevel();
    }

    public static boolean isPathIgnored(String path) {
        return ManifoldHost.host().isPathIgnored(path);
    }

    public static String[] getAllReservedWords() {
        return ManifoldHost.host().getAllReservedWords();
    }

    public static Bindings createBindings() {
        return ManifoldHost.host().createBindings();
    }

    public static void addTypeLoaderListenerAsWeakRef(Object ctx, ITypeLoaderListener listener) {
        ManifoldHost.host().addTypeLoaderListenerAsWeakRef(ctx, listener);
    }

    public static JavaFileObject produceFile(String fqn, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        return ManifoldHost.host().produceFile(fqn, module, errorHandler);
    }

    public static void maybeAssignType(ClassLoader loader, String strType, URL url, BiConsumer<String, Supplier<byte[]>> assigner) {
        ManifoldHost.host().maybeAssignManifoldType(loader, strType, url, assigner);
    }

    public static void performLockedOperation(ClassLoader loader, Runnable operation) {
        ManifoldHost.host().performLockedOperation(loader, operation);
    }

    public static void initializeAndCompileNonJavaFiles(ProcessingEnvironment procEnv, JavaFileManager fileManager, List<String> files, Supplier<Set<String>> sourcePath, Supplier<List<String>> classpath, Supplier<List<String>> outputPath) {
        ManifoldHost.host().initializeAndCompileNonJavaFiles(procEnv, fileManager, files, sourcePath, classpath, outputPath);
    }

    public static Set<TypeName> getChildrenOfNamespace(String packageName) {
        return ManifoldHost.host().getChildrenOfNamespace(packageName);
    }

    public static boolean isBootstrapped() {
        return ManifoldHost.host().isBootstrapped();
    }
}

