/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.def.FileSystemImpl;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.host.ITypeLoaderListener;
import manifold.api.service.BaseService;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.internal.host.DefaultSingleModule;
import manifold.internal.host.ManifoldHost;
import manifold.internal.host.SimpleModule;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.runtime.UrlClassLoaderWrapper;
import manifold.util.BytecodeOptions;
import manifold.util.SourcePathUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class DefaultManifoldHost
extends BaseService
implements IManifoldHost {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private DefaultSingleModule _module;
    private List<File> _classpath;
    private LocklessLazyVar<IFileSystem> _fileSystem = LocklessLazyVar.make(() -> {
        if (BytecodeOptions.JDWP_ENABLED.get().booleanValue()) {
            return new FileSystemImpl(IFileSystem.CachingMode.NO_CACHING);
        }
        return new FileSystemImpl(IFileSystem.CachingMode.FULL_CACHING);
    });

    @Override
    public boolean isBootstrapped() {
        return this._module != null;
    }

    private void initDirPaths(List<IDirectory> classpath, List<IDirectory> sourcePath, List<IDirectory> outputPath) {
        this._module = new DefaultSingleModule(classpath, sourcePath, outputPath);
        this._module.initializeTypeManifolds();
    }

    @Override
    public IFileSystem getFileSystem() {
        return this._fileSystem.get();
    }

    @Override
    public ClassLoader getActualClassLoader() {
        if (JavacPlugin.instance() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return ManifoldHost.class.getClassLoader();
    }

    @Override
    public void bootstrap(List<File> sourcepath, List<File> classpath) {
        if (this.isBootstrapped()) {
            return;
        }
        this.preBootstrap();
        this.init(sourcepath, classpath);
    }

    @Override
    public IModule getGlobalModule() {
        return this._module;
    }

    @Override
    public IModule getCurrentModule() {
        return this._module;
    }

    @Override
    public void resetLanguageLevel() {
    }

    @Override
    public boolean isPathIgnored(String path) {
        return false;
    }

    @Override
    public String[] getAllReservedWords() {
        return JAVA_KEYWORDS;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public void addTypeLoaderListenerAsWeakRef(Object ctx, ITypeLoaderListener listener) {
    }

    @Override
    public JavaFileObject produceFile(String fqn, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        return module.produceFile(fqn, errorHandler);
    }

    @Override
    public void maybeAssignManifoldType(ClassLoader loader, String fqn, URL url, BiConsumer<String, Supplier<byte[]>> assigner) {
        Set<ITypeManifold> sps = this.getCurrentModule().findTypeManifoldsFor(fqn);
        if (!sps.isEmpty()) {
            assigner.accept(fqn, null);
        }
    }

    @Override
    public void performLockedOperation(ClassLoader loader, Runnable operation) {
        operation.run();
    }

    @Override
    public void initializeAndCompileNonJavaFiles(ProcessingEnvironment procEnv, JavaFileManager fileManager, List<String> files, Supplier<Set<String>> sourcePath, Supplier<List<String>> classpath, Supplier<List<String>> outputPath) {
        List<String> cp = classpath.get().stream().filter(e -> !SourcePathUtil.excludeFromSourcePath(e)).collect(Collectors.toList());
        Set sp = sourcePath.get().stream().filter(e -> !SourcePathUtil.excludeFromSourcePath(e)).collect(Collectors.toSet());
        List<String> op = outputPath.get();
        int i = 0;
        for (String p : op) {
            if (cp.contains(p)) continue;
            cp.add(i++, p);
        }
        ArrayList<String> all = new ArrayList<String>();
        for (String p : sp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        for (String p : cp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        this.initPaths(cp, all, op);
    }

    private void initPaths(List<String> classpath, List<String> sourcePath, List<String> outputPath) {
        IFileSystem fs = ManifoldHost.getFileSystem();
        List<IDirectory> cp = classpath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        List<IDirectory> sp = sourcePath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        List<IDirectory> op = outputPath.stream().map(path -> fs.getIDirectory(new File((String)path))).collect(Collectors.toList());
        this.initDirPaths(cp, sp, op);
    }

    @Override
    public Set<TypeName> getChildrenOfNamespace(String packageName) {
        return ((SimpleModule)this.getCurrentModule()).getChildrenOfNamespace(packageName);
    }

    public void init(List<File> sourcepath, List<File> classpath) {
        ArrayList<File> combined = new ArrayList<File>();
        if (classpath != null) {
            combined.addAll(classpath);
        }
        combined.addAll(this.deriveClasspathFrom(SourcePathUtil.class));
        this.setPaths(sourcepath, combined);
    }

    private void setPaths(List<File> sourcepath, List<File> classpath) {
        classpath = new ArrayList<File>(classpath);
        DefaultManifoldHost.removeDups(classpath);
        if (classpath.equals(this._classpath)) {
            return;
        }
        this._classpath = classpath;
        List<IDirectory> cp = this.createDefaultClassPath();
        cp.addAll(classpath.stream().map(file -> ManifoldHost.getFileSystem().getIDirectory((File)file)).collect(Collectors.toList()));
        DefaultManifoldHost.removeDups(cp);
        List sp = sourcepath.stream().map(file -> ManifoldHost.getFileSystem().getIDirectory((File)file)).filter(e -> !SourcePathUtil.excludeFromSourcePath(e.toJavaFile().getAbsolutePath())).collect(Collectors.toList());
        ArrayList<IDirectory> all = new ArrayList<IDirectory>();
        for (IDirectory p : sp) {
            if (all.contains(p)) continue;
            all.add(p);
        }
        for (IDirectory p : cp) {
            if (all.contains(p) || SourcePathUtil.excludeFromSourcePath(p.toJavaFile().getAbsolutePath())) continue;
            all.add(p);
        }
        this.initDirPaths(cp, all, Collections.emptyList());
    }

    private List<IDirectory> createDefaultClassPath() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(DefaultManifoldHost.removeQuotes(System.getProperty("java.class.path", "")));
        vals.add(System.getProperty("sun.boot.class.path", ""));
        vals.add(System.getProperty("java.ext.dirs", ""));
        return DefaultManifoldHost.expand(vals);
    }

    private static List<IDirectory> expand(List<String> paths) {
        LinkedHashSet<IDirectory> expanded = new LinkedHashSet<IDirectory>();
        for (String path : paths) {
            for (String pathElement : path.split(File.pathSeparator)) {
                if (pathElement.length() <= 0) continue;
                File filePath = new File(pathElement);
                IDirectory resource = ManifoldHost.getFileSystem().getIDirectory(filePath);
                expanded.add(resource);
            }
        }
        return new ArrayList<IDirectory>(expanded);
    }

    private static String removeQuotes(String classpath) {
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        return classpath;
    }

    private static void removeDups(List classpath) {
        for (int i = classpath.size() - 1; i >= 0; --i) {
            Object f = classpath.get(i);
            classpath.remove(i);
            if (classpath.contains(f)) continue;
            classpath.add(i, f);
        }
    }

    private List<File> deriveClasspathFrom(Class clazz) {
        LinkedList<File> ll = new LinkedList<File>();
        for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
            UrlClassLoaderWrapper wrap = UrlClassLoaderWrapper.wrap(loader);
            if (wrap == null) continue;
            for (URL url : wrap.getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (!file.exists() || ll.contains(file)) continue;
                    ll.add(file);
                }
                catch (Exception exception) {}
            }
        }
        return ll;
    }
}

