/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.host.IModuleComponent;
import manifold.api.host.RefreshKind;
import manifold.api.host.RefreshRequest;
import manifold.api.type.IModel;
import manifold.api.type.JavaTypeManifold;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.ext.IExtensionClassProducer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.StreamUtil;
import manifold.util.cache.FqnCache;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class AbstractExtensionProducer<M extends IModel>
extends JavaTypeManifold<M>
implements IExtensionClassProducer {
    private final LocklessLazyVar<Map<String, LocklessLazyVar<M>>> _extensionToModel = LocklessLazyVar.make(this::buildCache);
    private final LocklessLazyVar<Map<String, Set<IFile>>> _extensionToFiles = LocklessLazyVar.make(HashMap::new);

    @Override
    public void init(IModuleComponent moduleComponent) {
        super.init(moduleComponent, this::createModel);
    }

    protected abstract String getFileExt();

    protected abstract M createModel(String var1, Set<IFile> var2);

    protected abstract String makeExtensionClassName(String var1);

    protected abstract String deriveExtendedClassFrom(String var1);

    @Override
    public String findTopLevelFqn(String fqn) {
        if (this._extensionToModel.get().containsKey(fqn)) {
            return fqn;
        }
        return null;
    }

    private Map<String, LocklessLazyVar<M>> buildCache() {
        HashMap<String, LocklessLazyVar<M>> extensionToModel = new HashMap<String, LocklessLazyVar<M>>();
        FqnCache<IFile> extensionCache = this.getModule().getPathCache().getExtensionCache(this.getFileExt());
        Set<String> files = extensionCache.getFqns();
        for (String fileFqn : files) {
            IFile file = extensionCache.get(fileFqn);
            this.addFile(extensionToModel, file);
        }
        return extensionToModel;
    }

    private void addFile(Map<String, LocklessLazyVar<M>> extensionToModel, IFile file) {
        Set<String> extendedTypes = this.readExtendedTypes(file);
        for (String extended : extendedTypes) {
            String extension = this.makeExtensionClassName(extended);
            Set files = this._extensionToFiles.get().computeIfAbsent(extension, e -> new HashSet());
            files.add(file);
            extensionToModel.putIfAbsent(extension, LocklessLazyVar.make(() -> this.createModel(extension, files)));
        }
    }

    private void removeFile(IFile file) {
        for (String extension : this.getTypesForFile(file)) {
            this._extensionToModel.get().remove(extension);
            this._extensionToFiles.get().get(extension).remove(file);
        }
    }

    @Override
    protected ResourceFileTypeManifold.CacheClearer createCacheClearer() {
        return new MyCacheClearer();
    }

    @Override
    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        this._extensionToModel.clear();
        return kind;
    }

    @Override
    public boolean handlesFileExtension(String fileExtension) {
        return fileExtension.equalsIgnoreCase(this.getFileExt());
    }

    @Override
    protected Map<String, LocklessLazyVar<M>> getPeripheralTypes() {
        return this._extensionToModel.get();
    }

    @Override
    public boolean isInnerType(String topLevelFqn, String relativeInner) {
        return false;
    }

    @Override
    public boolean isExtendedType(String fqn) {
        String extension = this.makeExtensionClassName(fqn);
        return this._extensionToModel.get().containsKey(extension);
    }

    @Override
    public Set<String> getExtensionClasses(String extendedType) {
        return this.isExtendedType(extendedType) ? this.getExtensions(extendedType) : Collections.emptySet();
    }

    private Set<String> getExtensions(String extendedType) {
        String extension = this.makeExtensionClassName(extendedType);
        if (this._extensionToModel.get().containsKey(extension)) {
            return Collections.singleton(extension);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getExtendedTypes() {
        return this._extensionToModel.get().keySet().stream().map(this::deriveExtendedClassFrom).collect(Collectors.toSet());
    }

    @Override
    public String[] getTypesForFile(IFile file) {
        if (!this.handlesFile(file)) {
            return new String[0];
        }
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry<String, LocklessLazyVar<M>> entry : Objects.requireNonNull(this._extensionToModel.get()).entrySet()) {
            String extension = entry.getKey();
            IModel model = (IModel)Objects.requireNonNull(entry.getValue().get());
            if (!model.getFiles().contains(file)) continue;
            types.add(extension);
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    public Set<String> getExtendedTypesForFile(IFile file) {
        if (!this.handlesFile(file)) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry<String, LocklessLazyVar<M>> entry : Objects.requireNonNull(this._extensionToModel.get()).entrySet()) {
            String extension = entry.getKey();
            IModel model = (IModel)Objects.requireNonNull(entry.getValue().get());
            if (!model.getFiles().contains(file)) continue;
            types.add(this.deriveExtendedClassFrom(extension));
        }
        return types;
    }

    private Set<String> readExtendedTypes(IFile file) {
        String content;
        Objects.requireNonNull(file);
        try {
            content = StreamUtil.getContent(new InputStreamReader(file.openInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> extendedTypes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(content, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            StringTokenizer lineTokenizer = new StringTokenizer(line, "|");
            String extended = lineTokenizer.nextToken();
            extendedTypes.add(extended);
        }
        return extendedTypes;
    }

    static {
        Bootstrap.init();
    }

    private class MyCacheClearer
    extends ResourceFileTypeManifold.CacheClearer {
        private MyCacheClearer() {
        }

        @Override
        public void preRefresh(RefreshRequest request) {
            switch (request.kind) {
                case CREATION: {
                    AbstractExtensionProducer.this.addFile((Map)AbstractExtensionProducer.this._extensionToModel.get(), request.file);
                    break;
                }
                case MODIFICATION: {
                    AbstractExtensionProducer.this.removeFile(request.file);
                    AbstractExtensionProducer.this.addFile((Map)AbstractExtensionProducer.this._extensionToModel.get(), request.file);
                }
            }
        }

        @Override
        public void postRefresh(RefreshRequest request) {
            switch (request.kind) {
                case DELETION: {
                    AbstractExtensionProducer.this.removeFile(request.file);
                }
            }
        }
    }
}

