/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.extensions.java.util.stream.Stream;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.runtime.Bootstrap;

@Extension
public class ManifoldStreamCollectionsExt {
    public static <T> List<T> toList(@This Stream<T> thiz) {
        return thiz.collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(@This Stream<T> thiz) {
        return thiz.collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    public static <T, K, V> Map<K, V> toMap(@This Stream<T> thiz, Function<? super T, K> keyMapper, Function<? super T, V> valueMapper) {
        return thiz.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T, K> Map<K, T> toMap(@This Stream<T> thiz, Function<? super T, K> keyMapper) {
        return thiz.collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    public static <T, V> Map<V, List<T>> groupingBy(@This Stream<T> thiz, Function<? super T, V> valueMapper) {
        return thiz.collect(Collectors.groupingBy(valueMapper));
    }

    static {
        Bootstrap.init();
    }
}

