/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.extensions.java.lang.Iterable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import manifold.collections.extensions.java.util.Collection.ManifoldCollectionExt;
import manifold.collections.extensions.java.util.List.ManifoldListCollectionExt;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.runtime.Bootstrap;
import manifold.util.IndexedConsumer;
import manifold.util.IndexedFunction;
import manifold.util.IndexedPredicate;
import manifold.util.Pair;

@Extension
public class ManIterableExt {
    public static <T> T first(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            return (T)ManifoldListCollectionExt.first((List)thiz);
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        return iterator.next();
    }

    public static <T> T first(@This Iterable<T> thiz, Predicate<T> predicate) {
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            return element;
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    public static <T> int indexOfFirst(@This Iterable<T> thiz, Predicate<T> predicate) {
        int index = 0;
        for (T item : thiz) {
            if (predicate.test(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <T> T firstOrNull(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            if (((List)thiz).isEmpty()) {
                return null;
            }
            return (T)((List)thiz).get(0);
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static <T> T firstOrNull(@This Iterable<T> thiz, Predicate<T> predicate) {
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> T last(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            return (T)ManifoldListCollectionExt.last((List)thiz);
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        T last = iterator.next();
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    public static <T> T last(@This Iterable<T> thiz, Predicate<T> predicate) {
        T last = null;
        boolean found = false;
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            last = element;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return last;
    }

    public static <T> int indexOfLast(@This Iterable<T> thiz, Predicate<T> predicate) {
        int lastIndex = -1;
        int index = 0;
        for (T item : thiz) {
            if (predicate.test(item)) {
                lastIndex = index;
            }
            ++index;
        }
        return lastIndex;
    }

    public static <T> T lastOrNull(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            return ((List)thiz).isEmpty() ? null : (T)((List)thiz).get(((List)thiz).size() - 1);
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        T last = iterator.next();
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    public static <T> T lastOrNull(@This Iterable<T> thiz, Predicate<T> predicate) {
        T last = null;
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            last = element;
        }
        return last;
    }

    public static <T> T single(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            return (T)ManifoldListCollectionExt.single((List)thiz);
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("Collection is empty.");
        }
        T single = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Collection has more than one element.");
        }
        return single;
    }

    public static <T> T single(@This Iterable<T> thiz, Predicate<T> predicate) {
        T single = null;
        boolean found = false;
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            if (found) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single = element;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single;
    }

    public static <T> T singleOrNull(@This Iterable<T> thiz) {
        if (thiz instanceof List) {
            return ((List)thiz).size() == 1 ? (T)((List)thiz).get(0) : null;
        }
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        T single = iterator.next();
        if (iterator.hasNext()) {
            return null;
        }
        return single;
    }

    public static <T> T singleOrNull(@This Iterable<T> thiz, Predicate<T> predicate) {
        T single = null;
        boolean found = false;
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            if (found) {
                return null;
            }
            single = element;
            found = true;
        }
        if (!found) {
            return null;
        }
        return single;
    }

    public static <T> List<T> filterToList(@This Iterable<T> thiz, Predicate<T> predicate) {
        return ManIterableExt.filterTo(thiz, new ArrayList(), predicate);
    }

    public static <T, C extends Collection<? super T>> C filterTo(@This Iterable<T> thiz, C destination, Predicate<T> predicate) {
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            destination.add(element);
        }
        return destination;
    }

    public static <T> List<T> filterIndexedToList(@This Iterable<T> thiz, IndexedPredicate<T> predicate) {
        return ManIterableExt.filterIndexedTo(thiz, new ArrayList(), predicate);
    }

    public static <T, C extends Collection<? super T>> C filterIndexedTo(@This Iterable<T> thiz, C destination, IndexedPredicate<T> predicate) {
        ManIterableExt.forEachIndexed(thiz, (index, element) -> {
            if (predicate.test(index, element)) {
                destination.add(element);
            }
        });
        return destination;
    }

    public static <T> List<T> filterNotToList(@This Iterable<T> thiz, Predicate<T> predicate) {
        return ManIterableExt.filterNotTo(thiz, new ArrayList(), predicate);
    }

    public static <T, C extends Collection<? super T>> C filterNotTo(@This Iterable<T> thiz, C destination, Predicate<T> predicate) {
        for (T element : thiz) {
            if (predicate.test(element)) continue;
            destination.add(element);
        }
        return destination;
    }

    public static <T> List<T> reversed(@This Iterable<T> thiz) {
        List<T> list = ManIterableExt.toList(thiz);
        if (list.size() <= 1) {
            return list;
        }
        ManifoldListCollectionExt.reverse(list);
        return list;
    }

    public static <T> List<T> toList(@This Iterable<T> thiz) {
        if (thiz instanceof Collection) {
            return ManifoldCollectionExt.toList((Collection)thiz);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T elem : thiz) {
            list.add(elem);
        }
        return list;
    }

    public static <T> Set<T> toSet(@This Iterable<T> thiz) {
        if (thiz instanceof Collection) {
            return ManifoldCollectionExt.toSet((Collection)thiz);
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T elem : thiz) {
            set.add(elem);
        }
        return set;
    }

    public static <T, R> List<R> flatMap(@This Iterable<T> thiz, Function<T, Iterable<R>> transform) {
        return ManIterableExt.flatMapTo(thiz, new ArrayList(), transform);
    }

    public static <T, R, C extends Collection<R>> C flatMapTo(@This Iterable<T> thiz, C destination, Function<T, Iterable<R>> transform) {
        for (T element : thiz) {
            Iterable<R> list = transform.apply(element);
            ManifoldCollectionExt.addAll(destination, list);
        }
        return destination;
    }

    public static <T> List<T> distinctList(@This Iterable<T> thiz) {
        return ManifoldCollectionExt.toList(ManIterableExt.toSet(thiz));
    }

    public static <T, K> List<T> distinctBy(@This Iterable<T> thiz, Function<T, K> selector) {
        HashSet<K> set = new HashSet<K>();
        ArrayList<T> list = new ArrayList<T>();
        for (T e : thiz) {
            K key = selector.apply(e);
            if (!set.add(key)) continue;
            list.add(e);
        }
        return list;
    }

    public static <T> Set<T> intersect(@This Iterable<T> thiz, Iterable<T> other) {
        Set<T> set = ManIterableExt.toSet(thiz);
        set.retainAll(ManIterableExt.coerceToUniqueCollection(other));
        return set;
    }

    public static <T> Set<T> subtract(@This Iterable<T> thiz, Iterable<T> other) {
        Set<T> set = ManIterableExt.toSet(thiz);
        set.removeAll(ManIterableExt.coerceToUniqueCollection(other));
        return set;
    }

    public static <T> Set<T> union(@This Iterable<T> thiz, Iterable<T> other) {
        Set<T> set = ManIterableExt.toSet(thiz);
        ManifoldCollectionExt.addAll(set, other);
        return set;
    }

    private static <T> Collection<T> coerceToUniqueCollection(Iterable<T> source) {
        if (source instanceof Collection && ((Collection)source).size() <= 1) {
            return (Collection)source;
        }
        HashSet<T> set = new HashSet<T>();
        for (T elem : source) {
            set.add(elem);
        }
        return set;
    }

    public static <T> int count(@This Iterable<T> thiz) {
        if (thiz instanceof Collection) {
            return ((Collection)thiz).size();
        }
        int count = 0;
        for (T element : thiz) {
            ++count;
        }
        return count;
    }

    public static <T> int count(@This Iterable<T> thiz, Predicate<T> predicate) {
        int count = 0;
        for (T element : thiz) {
            if (!predicate.test(element)) continue;
            ++count;
        }
        return count;
    }

    public static <T> T maxWith(@This Iterable<T> thiz, Comparator<T> comparator) {
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        T max = iterator.next();
        while (iterator.hasNext()) {
            T e = iterator.next();
            if (comparator.compare(max, e) >= 0) continue;
            max = e;
        }
        return max;
    }

    public static <T> T minWith(@This Iterable<T> thiz, Comparator<T> comparator) {
        Iterator<T> iterator = thiz.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        T min = iterator.next();
        while (iterator.hasNext()) {
            T e = iterator.next();
            if (comparator.compare(min, e) <= 0) continue;
            min = e;
        }
        return min;
    }

    public static <T> Pair<List<T>, List<T>> partition(@This Iterable<T> thiz, Predicate<T> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (T element : thiz) {
            if (predicate.test(element)) {
                first.add(element);
                continue;
            }
            second.add(element);
        }
        return new Pair<List<T>, List<T>>(first, second);
    }

    private static <T> int collectionSizeOrDefault(Iterable<T> thiz, int def) {
        return thiz instanceof Collection ? ((Collection)thiz).size() : def;
    }

    public static <T, R> List<R> mapToList(@This Iterable<T> thiz, Function<T, R> transform) {
        return ManIterableExt.mapTo(thiz, new ArrayList(ManIterableExt.collectionSizeOrDefault(thiz, 10)), transform);
    }

    public static <T, R> List<R> mapIndexed(@This Iterable<T> thiz, IndexedFunction<T, R> transform) {
        return ManIterableExt.mapIndexedTo(thiz, new ArrayList(ManIterableExt.collectionSizeOrDefault(thiz, 10)), transform);
    }

    public static <T, R> List<R> mapIndexedNotNull(@This Iterable<T> thiz, IndexedFunction<T, R> transform) {
        return ManIterableExt.mapIndexedNotNullTo(thiz, new ArrayList(), transform);
    }

    public static <T, R, C extends Collection<? super R>> C mapIndexedNotNullTo(@This Iterable<T> thiz, C destination, IndexedFunction<T, R> transform) {
        ManIterableExt.forEachIndexed(thiz, (index, element) -> {
            Object result = transform.apply(index, element);
            if (result != null) {
                destination.add(result);
            }
        });
        return destination;
    }

    public static <T, R, C extends Collection<? super R>> C mapIndexedTo(@This Iterable<T> thiz, C destination, IndexedFunction<T, R> transform) {
        int index = 0;
        for (T item : thiz) {
            destination.add(transform.apply(index++, item));
        }
        return destination;
    }

    public static <T, R> List<R> mapNotNull(@This Iterable<T> thiz, Function<T, R> transform) {
        return ManIterableExt.mapNotNullTo(thiz, new ArrayList(), transform);
    }

    public static <T, R, C extends Collection<? super R>> C mapNotNullTo(@This Iterable<T> thiz, C destination, Function<T, R> transform) {
        thiz.forEach(element -> {
            Object result = transform.apply(element);
            if (result != null) {
                destination.add(result);
            }
        });
        return destination;
    }

    public static <T, R, C extends Collection<? super R>> C mapTo(@This Iterable<T> thiz, C destination, Function<T, R> transform) {
        for (T item : thiz) {
            destination.add(transform.apply(item));
        }
        return destination;
    }

    public static <T> List<T> subList(@This Iterable<T> thiz, int fromIndex) {
        return ManIterableExt.subList(thiz, fromIndex, -1);
    }

    public static <T> List<T> subList(@This Iterable<T> thiz, int fromIndex, int toIndex) {
        boolean toEnd;
        if (thiz instanceof Collection && ((Collection)thiz).isEmpty()) {
            return Collections.emptyList();
        }
        boolean bl = toEnd = toIndex < 0;
        if (thiz instanceof List) {
            return ((List)thiz).subList(fromIndex, !toEnd ? toIndex : ((List)thiz).size());
        }
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> iter = thiz.iterator();
        for (int i = 0; (toEnd || i < toIndex) && iter.hasNext(); ++i) {
            T elem = iter.next();
            if (i < fromIndex) continue;
            list.add(elem);
        }
        return ManifoldListCollectionExt.optimizeReadOnlyList(list);
    }

    public static <T> void forEachIndexed(@This Iterable<T> thiz, IndexedConsumer<T> action) {
        int index = 0;
        for (T item : thiz) {
            action.accept(index++, item);
        }
    }

    public static <T> String joinToString(@This Iterable<T> thiz, CharSequence separator) {
        return ManIterableExt.joinTo(thiz, new StringBuilder(), separator).toString();
    }

    public static <T, A extends Appendable> A joinTo(@This Iterable<T> thiz, A buffer, CharSequence separator) {
        int count = 0;
        try {
            for (T e : thiz) {
                if (count++ > 0) {
                    buffer.append(separator);
                }
                buffer.append(e.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public static <T, R> R fold(@This Iterable<T> thiz, R initial, BiFunction<R, T, R> operation) {
        R accumulator = initial;
        for (T element : thiz) {
            accumulator = operation.apply(accumulator, element);
        }
        return accumulator;
    }

    static {
        Bootstrap.init();
    }
}

