/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.type;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.AbstractTypeSystemListener;
import manifold.api.host.IModule;
import manifold.api.host.IModuleComponent;
import manifold.api.host.RefreshKind;
import manifold.api.host.RefreshRequest;
import manifold.api.service.BaseService;
import manifold.api.type.IModel;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.internal.host.ManifoldHost;
import manifold.util.ManClassUtil;
import manifold.util.StreamUtil;
import manifold.util.cache.FqnCache;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class ResourceFileTypeManifold<M extends IModel>
extends BaseService
implements ITypeManifold {
    private IModuleComponent _typeLoader;
    private LocklessLazyVar<FqnCache<LocklessLazyVar<M>>> _fqnToModel;
    private String _typeFactoryFqn;
    private BiFunction<String, Set<IFile>, M> _modelMapper;
    private CacheClearer _cacheClearer;

    @Override
    public void init(IModuleComponent tl) {
        this._typeLoader = tl;
    }

    protected void init(IModuleComponent typeLoader, BiFunction<String, Set<IFile>, M> modelMapper) {
        this.init(typeLoader, modelMapper, null);
    }

    protected void init(IModuleComponent typeLoader, BiFunction<String, Set<IFile>, M> modelMapper, String typeFactoryFqn) {
        this._typeLoader = typeLoader;
        this._typeFactoryFqn = typeFactoryFqn;
        this._modelMapper = modelMapper;
        this._fqnToModel = LocklessLazyVar.make(this::buildFqnToModelCache);
        this._cacheClearer = this.createCacheClearer();
        ManifoldHost.addTypeLoaderListenerAsWeakRef(this.getModule(), this._cacheClearer);
    }

    protected CacheClearer createCacheClearer() {
        return new CacheClearer();
    }

    private FqnCache<LocklessLazyVar<M>> buildFqnToModelCache() {
        FqnCache<LocklessLazyVar<M>> fqnToModel = new FqnCache<LocklessLazyVar<M>>();
        Map<String, Set<IFile>> primaryFqnToFiles = this.buildPrimaryFqnToFilesMap();
        for (Map.Entry<String, Set<IFile>> entry : primaryFqnToFiles.entrySet()) {
            String primaryFqnNoMinus;
            String primaryFqn = entry.getKey();
            Set<IFile> files = entry.getValue();
            LocklessLazyVar<IModel> model = null;
            if (primaryFqn.charAt(0) != '-') {
                model = LocklessLazyVar.make(() -> (IModel)this._modelMapper.apply(primaryFqn, files));
                fqnToModel.add(primaryFqn, model);
                primaryFqnNoMinus = primaryFqn;
            } else {
                primaryFqnNoMinus = primaryFqn.substring(1);
            }
            for (IFile file : files) {
                for (String addFqn : this.getAdditionalTypes(primaryFqnNoMinus, file)) {
                    if (model == null) {
                        model = LocklessLazyVar.make(() -> (IModel)this._modelMapper.apply(primaryFqnNoMinus, files));
                    }
                    fqnToModel.add(addFqn, model);
                }
            }
        }
        Map<String, LocklessLazyVar<M>> peripheralTypes = this.getPeripheralTypes();
        if (peripheralTypes != null) {
            fqnToModel.addAll(peripheralTypes);
        }
        return fqnToModel;
    }

    private Map<String, Set<IFile>> buildPrimaryFqnToFilesMap() {
        HashMap<String, Set<IFile>> primaryFqnToFiles = new HashMap<String, Set<IFile>>();
        Map<String, FqnCache<IFile>> extensionCaches = this.getModule().getPathCache().getExtensionCaches();
        for (Map.Entry<String, FqnCache<IFile>> entry : extensionCaches.entrySet()) {
            String ext = entry.getKey();
            if (!this.handlesFileExtension(ext)) continue;
            FqnCache<IFile> fileCache = entry.getValue();
            for (String fqn : fileCache.getFqns()) {
                String primaryFqn;
                IFile file = fileCache.get(fqn);
                if (file == null || !this.handlesFile(file) || (primaryFqn = this.getTypeNameForFile(fqn, file)) == null) continue;
                String pfqn = primaryFqn.isEmpty() ? '-' + fqn : primaryFqn;
                ConcurrentHashSet<IFile> files = (ConcurrentHashSet<IFile>)primaryFqnToFiles.get(pfqn);
                if (files == null) {
                    files = new ConcurrentHashSet<IFile>();
                }
                if (this.isDuplicate(file, files)) continue;
                files.add(file);
                primaryFqnToFiles.put(pfqn, files);
            }
        }
        return primaryFqnToFiles;
    }

    protected boolean isDuplicate(IFile file, Set<IFile> files) {
        Set<String> fqnForFile = this.getModule().getPathCache().getFqnForFile(file);
        for (IFile f : files) {
            Set<String> fqn = this.getModule().getPathCache().getFqnForFile(f);
            if (!fqnForFile.equals(fqn)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, LocklessLazyVar<M>> getPeripheralTypes() {
        return Collections.emptyMap();
    }

    protected String getTypeNameForFile(String defaultFqn, IFile file) {
        return defaultFqn;
    }

    protected Set<String> getAdditionalTypes(String fqnForFile, IFile file) {
        return Collections.emptySet();
    }

    public abstract boolean isInnerType(String var1, String var2);

    protected abstract String contribute(String var1, String var2, M var3, DiagnosticListener<JavaFileObject> var4);

    protected M getModel(String topLevel) {
        LocklessLazyVar<M> lazyModel = this._fqnToModel.get().get(topLevel);
        return (M)(lazyModel == null ? null : (IModel)lazyModel.get());
    }

    @Override
    public boolean handlesFile(IFile file) {
        return this.handlesFileExtension(file.getExtension());
    }

    @Override
    public String[] getTypesForFile(IFile file) {
        if (!this.handlesFile(file)) {
            return new String[0];
        }
        Set<String> fqns = this.getModule().getPathCache().getFqnForFile(file);
        HashSet<String> aliasedFqns = new HashSet<String>();
        if (fqns != null) {
            for (String fqn : fqns) {
                if ((fqn = this.getTypeNameForFile(fqn, file)) == null) continue;
                aliasedFqns.add(fqn);
            }
        }
        return aliasedFqns.toArray(new String[aliasedFqns.size()]);
    }

    public IModule getModule() {
        return this._typeLoader.getModule();
    }

    @Override
    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        this._fqnToModel.clear();
        return kind;
    }

    @Override
    public IModuleComponent getTypeLoader() {
        return this._typeLoader;
    }

    @Override
    public boolean isType(String fqn) {
        String topLevel = this.findTopLevelFqn(fqn = fqn.replace('$', '.'));
        if (topLevel == null) {
            return false;
        }
        if (topLevel.equals(fqn)) {
            return true;
        }
        return this.isInnerType(topLevel, fqn.substring(topLevel.length() + 1));
    }

    @Override
    public boolean isPackage(String pkg) {
        return !this.getTypeNames(pkg).isEmpty();
    }

    public String findTopLevelFqn(String fqn) {
        LocklessLazyVar<M> lazyModel;
        while ((lazyModel = this._fqnToModel.get().get(fqn)) == null) {
            int iDot = fqn.lastIndexOf(46);
            if (iDot <= 0) {
                return null;
            }
            fqn = fqn.substring(0, iDot);
        }
        return fqn;
    }

    @Override
    public boolean isTopLevelType(String fqn) {
        return this._fqnToModel.get().get(fqn) != null;
    }

    @Override
    public String getPackage(String fqn) {
        String topLevel = this.findTopLevelFqn(fqn);
        return ManClassUtil.getPackage(topLevel);
    }

    @Override
    public String contribute(String fqn, String existing, DiagnosticListener<JavaFileObject> errorHandler) {
        String topLevel = this.findTopLevelFqn(fqn);
        LocklessLazyVar<M> lazyModel = this._fqnToModel.get().get(topLevel);
        String source = this.contribute(topLevel, existing, (IModel)lazyModel.get(), errorHandler);
        lazyModel.clear();
        return source;
    }

    @Override
    public Collection<String> getAllTypeNames() {
        return this._fqnToModel.get().getFqns();
    }

    @Override
    public Collection<TypeName> getTypeNames(String namespace) {
        return this.getAllTypeNames().stream().filter(fqn -> ManClassUtil.getPackage(fqn).equals(namespace)).map(fqn -> new TypeName((String)fqn, this._typeLoader, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC)).collect(Collectors.toSet());
    }

    @Override
    public List<IFile> findFilesForType(String fqn) {
        String topLevel = this.findTopLevelFqn(fqn);
        if (topLevel == null) {
            return Collections.emptyList();
        }
        M model = this.getModel(topLevel);
        return model != null ? new ArrayList<IFile>(model.getFiles()) : Collections.emptyList();
    }

    @Override
    public void clear() {
        this._fqnToModel.clear();
    }

    @Override
    public <T> List<T> getInterface(Class<T> apiInterface) {
        if (this._typeFactoryFqn == null || this._typeFactoryFqn.isEmpty()) {
            return super.getInterface(apiInterface);
        }
        if (this._fqnToModel != null && apiInterface.getName().equals("editor.plugin.typeloader.ITypeFactory")) {
            try {
                return Collections.singletonList(Class.forName(this._typeFactoryFqn).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.getInterface(apiInterface);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContent(IFile file) {
        if (file == null) return null;
        try (InputStream inputStream = file.openInputStream();){
            String string = StreamUtil.getContent(new InputStreamReader(inputStream));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected class CacheClearer
    extends AbstractTypeSystemListener {
        protected CacheClearer() {
        }

        @Override
        public void refreshed() {
            ResourceFileTypeManifold.this.clear();
        }

        public void preRefresh(RefreshRequest request) {
        }

        public void postRefresh(RefreshRequest request) {
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            IModule refreshModule = request.module;
            if (refreshModule != null && refreshModule != ResourceFileTypeManifold.this.getModule()) {
                return;
            }
            if (request.file == null || !ResourceFileTypeManifold.this.handlesFile(request.file)) {
                return;
            }
            Set<ITypeManifold> sps = ResourceFileTypeManifold.this.getModule().findTypeManifoldsFor(request.file);
            if (!sps.contains(ResourceFileTypeManifold.this)) {
                return;
            }
            this.preRefresh(request);
            switch (request.kind) {
                case MODIFICATION: {
                    for (String type : ResourceFileTypeManifold.this.getTypesForFile(request.file)) {
                        this.modifiedType(Collections.singleton(request.file), type);
                    }
                    break;
                }
                case CREATION: {
                    for (String type : ResourceFileTypeManifold.this.getTypesForFile(request.file)) {
                        this.createdType(Collections.singleton(request.file), type);
                    }
                    break;
                }
                case DELETION: {
                    for (String type : ResourceFileTypeManifold.this.getTypesForFile(request.file)) {
                        this.deletedType(Collections.singleton(request.file), type);
                    }
                    break;
                }
            }
            this.postRefresh(request);
        }

        public void deletedType(Set<IFile> files, String type) {
            Object lazyModel = ResourceFileTypeManifold.this.getModel(type);
            if (lazyModel != null) {
                for (IFile file : files) {
                    lazyModel.removeFile(file);
                }
                if (lazyModel.getFiles().size() == 0) {
                    ((FqnCache)ResourceFileTypeManifold.this._fqnToModel.get()).remove(type);
                }
            }
        }

        public void createdType(Set<IFile> files, String type) {
            Object lazyModel = ResourceFileTypeManifold.this.getModel(type);
            if (lazyModel != null) {
                for (IFile file : files) {
                    lazyModel.addFile(file);
                }
            } else {
                ((FqnCache)ResourceFileTypeManifold.this._fqnToModel.get()).add(type, LocklessLazyVar.make(() -> (IModel)ResourceFileTypeManifold.this._modelMapper.apply(type, files)));
            }
        }

        public void modifiedType(Set<IFile> files, String type) {
            Object lazyModel = ResourceFileTypeManifold.this.getModel(type);
            if (lazyModel != null) {
                for (IFile file : files) {
                    lazyModel.updateFile(file);
                }
            } else {
                ((FqnCache)ResourceFileTypeManifold.this._fqnToModel.get()).add(type, LocklessLazyVar.make(() -> (IModel)ResourceFileTypeManifold.this._modelMapper.apply(type, files)));
            }
        }
    }
}

