/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.type.AbstractSingleFileModel;
import manifold.util.JsonUtil;
import manifold.util.cache.FqnCache;

class Model
extends AbstractSingleFileModel {
    private FqnCache<String> _cache;

    public Model(String fqn, Set<IFile> files) {
        super(fqn, files);
        this.buildCache(fqn, this.getFile());
    }

    public Model(String fqn, FqnCache<String> cache) {
        super(fqn, Collections.emptySet());
        this._cache = cache;
    }

    public FqnCache<String> getCache() {
        return this._cache;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.buildCache(this.getFqn(), file);
    }

    private void buildCache(String fqn, IFile file) {
        try (InputStream propertiesStream = file.openInputStream();){
            Properties properties = new Properties();
            properties.load(propertiesStream);
            FqnCache<String> cache = new FqnCache<String>(fqn, true, JsonUtil::makeIdentifier);
            for (String key : properties.stringPropertyNames()) {
                cache.add(key, properties.getProperty(key));
            }
            this._cache = cache;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

