/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.script.Bindings;
import manifold.api.fs.IFile;
import manifold.api.json.DynamicType;
import manifold.api.json.ErrantType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSimpleType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.ArrayTransformer;
import manifold.api.json.schema.IllegalSchemaTypeName;
import manifold.api.json.schema.JsonSchemaTransformerSession;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.ObjectTransformer;
import manifold.api.json.schema.Type;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.IIssue;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;
import manifold.util.Pair;
import manifold.util.StreamUtil;
import manifold.util.cache.FqnCache;

public class JsonSchemaTransformer {
    private static final String JSCH_SCHEMA = "$schema";
    private static final String JSCH_TYPE = "type";
    private static final String JSCH_NAME = "name";
    private static final String JSCH_ID = "$id";
    private static final String JSCH_REF = "$ref";
    private static final String JSCH_ENUM = "enum";
    private static final String JSCH_ALL_OF = "allOf";
    private static final String JSCH_ONE_OF = "oneOf";
    private static final String JSCH_ANY_OF = "anyOf";
    private static final String JSCH_REQUIRED = "required";
    static final String JSCH_DEFINITIONS = "definitions";
    static final String JSCH_PROPERTIES = "properties";
    private FqnCache<IJsonType> _typeByFqn = new FqnCache("doc", true, JsonUtil::makeIdentifier);

    private JsonSchemaTransformer() {
    }

    public static boolean isSchema(Bindings bindings) {
        return bindings.get(JSCH_SCHEMA) != null || bindings.get(JSCH_ID) != null || bindings.get(JSCH_TYPE) != null && (bindings.get(JSCH_TYPE).equals(Type.Object.getName()) || bindings.get(JSCH_TYPE).equals(Type.Array.getName()));
    }

    public static IJsonType transform(String name, Bindings docObj) {
        return JsonSchemaTransformer.transform(name, null, docObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJsonType transform(String name, URL source, Bindings docObj) {
        if (!JsonSchemaTransformer.isSchema(docObj)) {
            ErrantType errant = new ErrantType(source, name);
            errant.addIssue(new JsonIssue(IIssue.Kind.Error, null, "The Json object from '" + source + "' does not contain a '$schema' element."));
            return errant;
        }
        JsonSchemaTransformer transformer = new JsonSchemaTransformer();
        JsonSchemaTransformerSession session = JsonSchemaTransformerSession.instance();
        session.pushTransformer(transformer);
        try {
            name = name == null || name.isEmpty() ? JsonSchemaTransformer.getJSchema_Name(docObj) : name;
            IJsonType cachedType = JsonSchemaTransformer.findTopLevelCachedType(name, source, docObj);
            if (cachedType != null) {
                IJsonType iJsonType = cachedType;
                return iJsonType;
            }
            IJsonType iJsonType = transformer.transformType(null, source, name, docObj);
            return iJsonType;
        }
        finally {
            session.popTransformer(transformer);
        }
    }

    private static IJsonType findTopLevelCachedType(String name, URL source, Bindings docObj) {
        String id;
        Pair<IJsonType, JsonSchemaTransformer> pair;
        if (source != null && (pair = JsonSchemaTransformerSession.instance().getCachedBaseType(source)) != null) {
            return pair.getFirst();
        }
        Object value = docObj.get(JSCH_ID);
        if (value == null) {
            return null;
        }
        Token token = null;
        if (value instanceof Pair) {
            id = (String)((Pair)value).getSecond();
            token = ((Token[])((Pair)value).getFirst())[1];
        } else {
            id = (String)value;
        }
        if (id == null || id.isEmpty()) {
            return null;
        }
        try {
            URL url = new URL(id);
            Pair<IJsonType, JsonSchemaTransformer> pair2 = JsonSchemaTransformerSession.instance().getCachedBaseType(url);
            if (pair2 != null) {
                return pair2.getFirst();
            }
        }
        catch (MalformedURLException e) {
            ErrantType errant = new ErrantType(null, name);
            errant.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Malformed URL id: " + id));
            return errant;
        }
        return null;
    }

    private static String getJSchema_Name(Bindings docObj) {
        Object value = docObj.get(JSCH_NAME);
        String name = value instanceof Pair ? (String)((Pair)value).getSecond() : (String)value;
        return name;
    }

    private static Bindings getJSchema_Definitions(Bindings docObj) {
        Object value = docObj.get(JSCH_DEFINITIONS);
        return JsonSchemaTransformer.getBindings(value);
    }

    private static Bindings getBindings(Object value) {
        Bindings bindings = value instanceof Pair ? (Bindings)((Pair)value).getSecond() : (Bindings)value;
        return bindings;
    }

    private static Bindings getJSchema_Properties(Bindings docObj) {
        Object value = docObj.get(JSCH_PROPERTIES);
        return JsonSchemaTransformer.getBindings(value);
    }

    private static List getJSchema_Enum(Bindings docObj) {
        Object value = docObj.get(JSCH_ENUM);
        List list = value instanceof Pair ? (List)((Pair)value).getSecond() : (List)value;
        return list;
    }

    private static List getJSchema_AllOf(Bindings docObj) {
        Object value = docObj.get(JSCH_ALL_OF);
        List list = value instanceof Pair ? (List)((Pair)value).getSecond() : (List)value;
        return list;
    }

    private static List getJSchema_AnyOf(Bindings docObj) {
        Object value = docObj.get(JSCH_ANY_OF);
        List list = value instanceof Pair ? (List)((Pair)value).getSecond() : (List)value;
        return list;
    }

    private static List getJSchema_OneOf(Bindings docObj) {
        Object value = docObj.get(JSCH_ONE_OF);
        List list = value instanceof Pair ? (List)((Pair)value).getSecond() : (List)value;
        return list;
    }

    private List<IJsonType> transformDefinitions(JsonSchemaType parent, String nameQualifier, URL enclosing, Bindings jsonObj) {
        return this.transformDefinitions(new JsonStructureType(parent, enclosing, nameQualifier), enclosing, jsonObj);
    }

    private List<IJsonType> transformDefinitions(JsonSchemaType parent, URL enclosing, Bindings jsonObj) {
        Bindings definitions = JsonSchemaTransformer.getJSchema_Definitions(jsonObj);
        if (definitions == null) {
            return null;
        }
        JsonStructureType definitionsHolder = new JsonStructureType(parent, enclosing, JSCH_DEFINITIONS);
        ArrayList<IJsonType> result = new ArrayList<IJsonType>();
        this.cacheByFqn(definitionsHolder);
        for (Map.Entry entry : definitions.entrySet()) {
            Token[] tokens = null;
            try {
                Bindings bindings;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Pair) {
                    bindings = (Bindings)((Pair)value).getSecond();
                    tokens = (Token[])((Pair)value).getFirst();
                } else {
                    bindings = (Bindings)value;
                }
                IJsonType type = this.transformType(definitionsHolder, enclosing, name, bindings);
                if (tokens != null && type instanceof JsonStructureType) {
                    ((JsonStructureType)type).setToken(tokens[0]);
                }
                result.add(type);
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, (Token)(tokens != null ? tokens[1] : null), e.getMessage()));
            }
        }
        return result;
    }

    private IJsonType findLocalRef(String localRef, URL enclosing) {
        Pair<IJsonType, JsonSchemaTransformer> cachedBaseType;
        if ((localRef = this.makeLocalRef(localRef)).isEmpty() && (cachedBaseType = JsonSchemaTransformerSession.instance().getCachedBaseType(enclosing)) != null) {
            return cachedBaseType.getFirst();
        }
        return this._typeByFqn.get(localRef);
    }

    private String makeLocalRef(String localRef) {
        if (localRef.isEmpty()) {
            return "";
        }
        char firstChar = (localRef = localRef.replace('/', '.')).charAt(0);
        if (firstChar == '.' || firstChar == '#') {
            localRef = localRef.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(localRef, ".");
        while (tokenizer.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            String token = tokenizer.nextToken();
            token = JsonUtil.makeIdentifier(token);
            sb.append(token);
        }
        return sb.toString();
    }

    void cacheByFqn(JsonSchemaType type) {
        this._typeByFqn.add(type.getFqn(), type);
    }

    private void cacheSimpleByFqn(JsonSchemaType parent, String name, IJsonType type) {
        if (parent instanceof JsonListType) {
            return;
        }
        this._typeByFqn.add(parent.getFqn() + '.' + name, type);
    }

    private void cacheById(IJsonParentType parent, IJsonType type, Bindings jsonObj) {
        String id;
        Object value = jsonObj.get(JSCH_ID);
        if (value == null) {
            return;
        }
        Token[] tokens = null;
        if (value instanceof Pair) {
            id = (String)((Pair)value).getSecond();
            tokens = (Token[])((Pair)value).getFirst();
        } else {
            id = (String)value;
        }
        this.cacheById(parent, type, id, tokens != null ? tokens[1] : null);
    }

    private void cacheById(IJsonParentType parent, IJsonType type, String id, Token token) {
        if (id.isEmpty()) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Relative 'id' is invalid: empty"));
            return;
        }
        String localRef = this.makeLocalRef(id);
        if (localRef.isEmpty()) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Relative 'id' is invalid: " + id));
            return;
        }
        IJsonType existing = this.findLocalRef(id, null);
        if (existing != null) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Id '" + id + "' already assigned to type '" + existing.getName() + "'"));
        } else {
            this._typeByFqn.add(localRef, type);
        }
    }

    IJsonType transformType(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        IJsonType result;
        String type;
        Object value = jsonObj.get(JSCH_TYPE);
        Token token = null;
        if (value instanceof Pair) {
            type = (String)((Pair)value).getSecond();
            token = ((Token[])((Pair)value).getFirst())[1];
        } else {
            type = (String)value;
        }
        if (type == null && this.isPropertiesDefined(jsonObj)) {
            type = Type.Object.getName();
        }
        Runnable transform = null;
        boolean bRef = jsonObj.containsKey(JSCH_REF);
        if (type == null || bRef || this.isCombination(jsonObj)) {
            JsonStructureType refParent = new JsonStructureType(parent, enclosing, name);
            if (bRef && parent == null) {
                Object refValue = jsonObj.get(JSCH_REF);
                if (refValue instanceof Pair) {
                    token = ((Token[])((Pair)refValue).getFirst())[0];
                }
                refParent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "'$ref' not allowed at root level"));
                result = refParent;
            } else {
                this.transformDefinitions(parent, enclosing, name, jsonObj, refParent);
                result = this.findReferenceTypeOrCombinationType(parent, enclosing, name, jsonObj);
                if (result != parent) {
                    this.transferIssuesFromErrantType(parent, result, jsonObj);
                }
            }
        } else {
            switch (Type.fromName(type)) {
                case Object: {
                    result = new JsonStructureType(parent, enclosing, name);
                    transform = () -> ObjectTransformer.transform(this, (JsonStructureType)result, jsonObj);
                    break;
                }
                case Array: {
                    result = new JsonListType(name, enclosing, parent);
                    transform = () -> ArrayTransformer.transform(this, name, (JsonListType)result, jsonObj);
                    break;
                }
                case String: {
                    result = JsonSimpleType.String;
                    this.cacheSimpleByFqn(parent, name, result);
                    break;
                }
                case Number: {
                    result = JsonSimpleType.Double;
                    this.cacheSimpleByFqn(parent, name, result);
                    break;
                }
                case Integer: {
                    result = JsonSimpleType.Integer;
                    this.cacheSimpleByFqn(parent, name, result);
                    break;
                }
                case Boolean: {
                    result = JsonSimpleType.Boolean;
                    this.cacheSimpleByFqn(parent, name, result);
                    break;
                }
                case Dynamic: 
                case Null: {
                    result = DynamicType.instance();
                    this.cacheSimpleByFqn(parent, name, result);
                    break;
                }
                default: {
                    throw new IllegalSchemaTypeName(type, token);
                }
            }
            this.transformDefinitions(parent, enclosing, name, jsonObj, result);
        }
        this.cacheById(parent, result, jsonObj);
        if (parent == null && enclosing != null) {
            JsonSchemaTransformerSession.instance().cacheBaseType(enclosing, new Pair<IJsonType, JsonSchemaTransformer>(result, this));
        }
        if (transform != null) {
            transform.run();
        }
        return result;
    }

    private boolean isCombination(Bindings jsonObj) {
        return (jsonObj.containsKey(JSCH_ALL_OF) || jsonObj.containsKey(JSCH_ONE_OF) || jsonObj.containsKey(JSCH_ANY_OF)) && !this.isPropertiesDefined(jsonObj);
    }

    private boolean isPropertiesDefined(Bindings jsonObj) {
        return jsonObj.get(JSCH_PROPERTIES) instanceof Bindings || jsonObj.get(JSCH_PROPERTIES) instanceof Pair && ((Pair)jsonObj.get(JSCH_PROPERTIES)).getSecond() instanceof Bindings;
    }

    private void transformDefinitions(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj, IJsonType result) {
        List<IJsonType> definitions = result instanceof JsonSchemaType ? this.transformDefinitions((JsonSchemaType)result, enclosing, jsonObj) : this.transformDefinitions(parent, name, enclosing, jsonObj);
        result.setDefinitions(definitions);
    }

    private void transferIssuesFromErrantType(JsonSchemaType parent, IJsonType result, Bindings jsonObj) {
        if (result instanceof ErrantType) {
            Object value = jsonObj.get(JSCH_REF);
            Token token = null;
            if (value instanceof Pair) {
                token = ((Token[])((Pair)value).getFirst())[1];
            }
            for (JsonIssue issue : ((ErrantType)result).getIssues()) {
                parent.addIssue(new JsonIssue(issue.getKind(), token, issue.getMessage()));
            }
        }
    }

    private IJsonType findReferenceTypeOrCombinationType(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        IJsonType result = this.findReference(parent, enclosing, jsonObj);
        if (result == null && (result = this.transformCombination(parent, enclosing, name, jsonObj)) == null && (result = this.deriveTypeFromEnum(jsonObj)) == null) {
            result = DynamicType.instance();
        }
        return result;
    }

    private IJsonType deriveTypeFromEnum(Bindings bindings) {
        List list = JsonSchemaTransformer.getJSchema_Enum(bindings);
        if (list == null) {
            return null;
        }
        IJsonType type = null;
        for (Object elem : list) {
            IJsonType csr = Json.transformJsonObject("", null, elem);
            if (type == null) {
                type = csr;
                continue;
            }
            if (type.equals(csr)) continue;
            type = DynamicType.instance();
        }
        return type;
    }

    private IJsonType transformCombination(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        IJsonType type = this.transformAllOf(parent, enclosing, name, jsonObj);
        if (type != null) {
            return type;
        }
        type = this.transformAnyOf(parent, enclosing, name, jsonObj);
        if (type != null) {
            return type;
        }
        return this.transformOneOf(parent, enclosing, name, jsonObj);
    }

    private JsonStructureType transformAllOf(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        List list = JsonSchemaTransformer.getJSchema_AllOf(jsonObj);
        if (list == null) {
            return null;
        }
        JsonStructureType type = this.buildHierarchy(parent, enclosing, name, list);
        if (type != null) {
            for (Object elem : list) {
                Bindings elemBindings;
                Bindings properties;
                if (elem instanceof Pair) {
                    elem = ((Pair)elem).getSecond();
                }
                if (!(elem instanceof Bindings) || (properties = JsonSchemaTransformer.getJSchema_Properties(elemBindings = (Bindings)elem)) == null) continue;
                ObjectTransformer.transform(this, type, elemBindings);
            }
        }
        return type;
    }

    private IJsonType transformAnyOf(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        List list = JsonSchemaTransformer.getJSchema_AnyOf(jsonObj);
        if (list == null) {
            return null;
        }
        return this.buildUnion(parent, enclosing, name, list);
    }

    private IJsonType transformOneOf(JsonSchemaType parent, URL enclosing, String name, Bindings jsonObj) {
        List list = JsonSchemaTransformer.getJSchema_OneOf(jsonObj);
        if (list == null) {
            return null;
        }
        return this.buildUnion(parent, enclosing, name, list);
    }

    private JsonStructureType buildHierarchy(JsonSchemaType parent, URL enclosing, String name, List list) {
        JsonStructureType type = null;
        for (Object elem : list) {
            if (elem instanceof Pair) {
                elem = ((Pair)elem).getSecond();
            }
            if (!(elem instanceof Bindings) || !this.isTypeDescriptor((Bindings)elem)) continue;
            Bindings elemBindings = (Bindings)elem;
            IJsonType ref = this.findReference(parent, enclosing, elemBindings);
            if (ref != null) {
                type = type == null ? new JsonStructureType(parent, enclosing, name) : type;
                type.addSuper((IJsonParentType)ref);
                continue;
            }
            Bindings properties = JsonSchemaTransformer.getJSchema_Properties(elemBindings);
            if (properties == null) continue;
            type = type == null ? new JsonStructureType(parent, enclosing, name) : type;
            ObjectTransformer.transform(this, type, elemBindings);
        }
        return type;
    }

    private IJsonType buildUnion(JsonSchemaType parent, URL enclosing, String name, List list) {
        JsonUnionType type = new JsonUnionType(parent, enclosing, name);
        int i = 0;
        for (Object elem : list) {
            if (elem instanceof Pair) {
                elem = ((Pair)elem).getSecond();
            }
            if (!(elem instanceof Bindings) || !this.isTypeDescriptor((Bindings)elem)) continue;
            String simpleName = "Option" + i++;
            IJsonType typePart = this.transformType(type, enclosing, simpleName, (Bindings)elem);
            if (typePart == null || !typePart.getName().equals(simpleName)) {
                --i;
            }
            if (typePart == null) continue;
            type.addConstituent(typePart.getName(), typePart);
        }
        if (!type.getConstituents().isEmpty()) {
            if (parent != null) {
                parent.addChild(type.getLabel(), type);
            }
            return type;
        }
        return null;
    }

    private boolean isTypeDescriptor(Bindings elem) {
        return elem.size() != 1 || !elem.containsKey(JSCH_REQUIRED);
    }

    private IJsonType findReference(JsonSchemaType parent, URL enclosing, Bindings jsonObj) {
        URI uri;
        String ref;
        Object value = jsonObj.get(JSCH_REF);
        Token token = null;
        if (value instanceof Pair) {
            ref = (String)((Pair)value).getSecond();
            token = ((Token[])((Pair)value).getFirst())[1];
        } else {
            ref = (String)value;
        }
        if (ref == null) {
            return null;
        }
        try {
            uri = new URI(ref);
        }
        catch (URISyntaxException e) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Invalid URI syntax: " + ref));
            return null;
        }
        String filePart = uri.getRawSchemeSpecificPart();
        if (filePart != null && !filePart.isEmpty()) {
            IJsonType definition;
            Pair<IJsonType, JsonSchemaTransformer> pair = this.findBaseType(token, parent, enclosing, uri, filePart);
            IJsonType iJsonType = definition = pair == null ? null : this.findFragmentType(enclosing, uri, pair);
            if (definition == null) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Invalid URI: " + uri));
            }
            return definition;
        }
        String fragment = uri.getFragment();
        if (fragment != null) {
            IJsonType localRef = this.findLocalRef(fragment, enclosing);
            if (localRef == null) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Invalid URI fragment: " + fragment));
                localRef = new ErrantType(enclosing, fragment);
            }
            return localRef;
        }
        throw new UnsupportedOperationException("Unhandled URI: " + ref);
    }

    private IJsonType findFragmentType(URL enclosing, URI uri, Pair<IJsonType, JsonSchemaTransformer> pair) {
        String fragment = uri.getFragment();
        IJsonType baseType = pair.getFirst();
        if (fragment == null || fragment.isEmpty()) {
            return baseType;
        }
        JsonSchemaTransformer tx = pair.getSecond();
        return tx.findLocalRef(fragment, enclosing);
    }

    private Pair<IJsonType, JsonSchemaTransformer> findBaseType(Token token, JsonSchemaType parent, URL enclosing, URI uri, String filePart) {
        IJsonType baseType;
        URL url;
        String scheme = uri.getScheme();
        try {
            url = scheme != null ? new URL(scheme + ':' + filePart) : new URL(enclosing, filePart);
        }
        catch (MalformedURLException e) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Malformed URL: " + uri));
            return null;
        }
        Pair<IJsonType, JsonSchemaTransformer> pair = JsonSchemaTransformerSession.instance().getCachedBaseType(url);
        IJsonType iJsonType = baseType = pair == null ? null : pair.getFirst();
        if (baseType == null) {
            Bindings bindings;
            String otherFileContent;
            try {
                InputStream input;
                String protocol = url.getProtocol();
                if (protocol != null && protocol.equals("file")) {
                    IFile file = ManifoldHost.getFileSystem().getIFile(url);
                    input = file.openInputStream();
                } else {
                    input = url.openStream();
                }
                try (InputStream sheeeeit = input;){
                    otherFileContent = StreamUtil.getContent(new InputStreamReader(sheeeeit));
                }
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, e.getMessage()));
                return null;
            }
            try {
                bindings = Json.fromJson(otherFileContent);
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Error: " + e.getMessage()));
                return null;
            }
            String name = new File(uri.getPath()).getName();
            int iDot = name.lastIndexOf(46);
            if (iDot > 0) {
                name = name.substring(0, iDot);
            }
            baseType = JsonSchemaTransformer.transform(name, url, bindings);
            pair = new Pair<IJsonType, JsonSchemaTransformer>(baseType, this);
            JsonSchemaTransformerSession.instance().cacheBaseType(url, pair);
        }
        return pair;
    }

    static {
        Bootstrap.init();
    }
}

