/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.json.ErrantType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssueContainer;
import manifold.api.json.JsonStructureType;
import manifold.api.json.schema.IllegalSchemaTypeName;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JavacDiagnostic;

class JsonModel
extends AbstractSingleFileModel {
    private IJsonParentType _type;
    private JsonIssueContainer _issues;

    JsonModel(String fqn, Set<IFile> files) {
        super(fqn, files);
        this.init();
    }

    private void init() {
        block9: {
            Bindings bindings;
            this._issues = null;
            try {
                bindings = Json.fromJson(ResourceFileTypeManifold.getContent(this.getFile()), false, true);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ScriptException) {
                    this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
                }
                bindings = new SimpleBindings();
            }
            try {
                try {
                    IJsonType type = Json.transformJsonObject(this.getFile().getBaseName(), this.getFile().toURI().toURL(), null, bindings);
                    if (type instanceof IJsonParentType) {
                        this._type = (IJsonParentType)type;
                        break block9;
                    }
                    this._type = new JsonStructureType(null, this.getFile().toURI().toURL(), this.getFile().getBaseName());
                }
                catch (IllegalSchemaTypeName e) {
                    this._type = new ErrantType(this.getFile().toURI().toURL(), e.getTypeName());
                    if (this._issues == null) {
                        this._issues = new JsonIssueContainer(this.getFile());
                    }
                    this._issues.addIssues(e);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IJsonParentType getType() {
        return this._type;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        List<IIssue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : issues) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report(new JavacDiagnostic(file, kind, issue.getStartOffset(), issue.getLine(), issue.getColumn(), issue.getMessage()));
        }
    }

    private List<IIssue> getIssues() {
        ArrayList<IIssue> allIssues = new ArrayList<IIssue>();
        if (this._issues != null) {
            allIssues.addAll(this._issues.getIssues());
        }
        if (this._type != null) {
            allIssues.addAll(this._type.getIssues());
        }
        return allIssues;
    }

    static {
        Bootstrap.init();
    }
}

