/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.host;

import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.host.IModuleComponent;
import manifold.api.host.RefreshKind;

public class RefreshRequest {
    public final IFile file;
    public final IModule module;
    public final IModuleComponent typeLoader;
    public final RefreshKind kind;
    public final String[] types;

    public RefreshRequest(IFile file, String[] types, IModule module, IModuleComponent typeLoader, RefreshKind kind) {
        this.file = file;
        this.kind = kind;
        this.types = types;
        this.module = module;
        this.typeLoader = typeLoader;
    }

    public RefreshRequest(IFile file, String[] types, IModuleComponent typeLoader, RefreshKind kind) {
        this(file, types, RefreshRequest.getModule(typeLoader), typeLoader, kind);
    }

    public RefreshRequest(String[] allTypes, RefreshRequest request, IModuleComponent typeLoader) {
        this(request.file, allTypes, typeLoader, request.kind);
    }

    private static IModule getModule(IModuleComponent typeLoader) {
        if (typeLoader == null) {
            throw new RuntimeException("A refresh request must have a valid typeloader");
        }
        return typeLoader.getModule();
    }

    public String toString() {
        String s = (Object)((Object)this.kind) + " of ";
        for (String type : this.types) {
            s = s + type + ", ";
        }
        s = s + "from " + (this.typeLoader != null ? this.typeLoader : this.module);
        return s;
    }
}

