/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.host;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import manifold.api.darkj.DarkJavaTypeManifold;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.image.ImageTypeManifold;
import manifold.api.properties.PropertiesTypeManifold;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.JavaTypeManifold;

public interface IModuleComponent {
    public IModule getModule();

    default public Set<ITypeManifold> findTypeManifoldsFor(String fqn) {
        HashSet<ITypeManifold> tms = new HashSet<ITypeManifold>(2);
        for (ITypeManifold tm : this.getModule().getTypeManifolds()) {
            if (!tm.isType(fqn)) continue;
            tms.add(tm);
        }
        return tms;
    }

    default public Set<ITypeManifold> findTypeManifoldsFor(IFile file) {
        HashSet<ITypeManifold> tms = new HashSet<ITypeManifold>(2);
        for (ITypeManifold tm : this.getModule().getTypeManifolds()) {
            if (!tm.handlesFile(file)) continue;
            tms.add(tm);
        }
        return tms;
    }

    default public SortedSet<ITypeManifold> loadTypeManifolds() {
        TreeSet<ITypeManifold> typeManifolds = new TreeSet<ITypeManifold>(this.getTypeManifoldSorter());
        this.loadBuiltIn(typeManifolds);
        this.loadRegistered(typeManifolds);
        return typeManifolds;
    }

    default public Comparator<ITypeManifold> getTypeManifoldSorter() {
        return (tm1, tm2) -> tm1.getContributorKind() == ContributorKind.Supplemental ? 1 : -1;
    }

    default public void loadBuiltIn(Set<ITypeManifold> tms) {
        JavaTypeManifold tm = new PropertiesTypeManifold();
        tms.add(tm);
        tm = new ImageTypeManifold();
        tms.add(tm);
        tm = new DarkJavaTypeManifold();
        tms.add(tm);
    }

    default public void loadRegistered(Set<ITypeManifold> tms) {
        ServiceLoader<ITypeManifold> loader = ServiceLoader.load(ITypeManifold.class);
        Iterator<ITypeManifold> iterator = loader.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                try {
                    ITypeManifold sp = iterator.next();
                    tms.add(sp);
                }
                catch (ServiceConfigurationError sp) {}
            }
        }
        if (Thread.currentThread().getContextClassLoader() != this.getClass().getClassLoader()) {
            loader = ServiceLoader.load(ITypeManifold.class, this.getClass().getClassLoader());
            iterator = loader.iterator();
            while (iterator.hasNext()) {
                try {
                    ITypeManifold tm = iterator.next();
                    if (!this.isAbsent(tms, tm)) continue;
                    tms.add(tm);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {}
            }
        }
    }

    default public boolean isAbsent(Set<ITypeManifold> typeManifolds, ITypeManifold tm) {
        for (ITypeManifold existingSp : typeManifolds) {
            if (!existingSp.getClass().equals(tm.getClass())) continue;
            return false;
        }
        return true;
    }
}

