/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.host;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.script.Bindings;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFileSystem;
import manifold.api.host.IModule;
import manifold.api.host.ITypeLoaderListener;
import manifold.api.service.IService;
import manifold.api.type.TypeName;
import manifold.internal.javac.JavacPlugin;
import manifold.util.NecessaryEvilUtil;

public interface IManifoldHost
extends IService {
    default public boolean accept() {
        try {
            JavacPlugin javacPlugin = JavacPlugin.instance();
            if (javacPlugin != null) {
                List<String> outputPath = javacPlugin.deriveOutputPath();
                for (String path : outputPath) {
                    String fqn = this.getClass().getName();
                    File classFile = new File(path, fqn = fqn.replace('.', File.separatorChar) + ".class");
                    if (!classFile.isFile()) continue;
                    return false;
                }
            }
        }
        catch (IllegalAccessError illegalAccessError) {
            // empty catch block
        }
        return true;
    }

    public ClassLoader getActualClassLoader();

    public boolean isBootstrapped();

    default public void preBootstrap() {
        NecessaryEvilUtil.bypassJava9Security();
    }

    public void bootstrap(List<File> var1, List<File> var2);

    public IModule getGlobalModule();

    public void resetLanguageLevel();

    public boolean isPathIgnored(String var1);

    public String[] getAllReservedWords();

    public Bindings createBindings();

    public void addTypeLoaderListenerAsWeakRef(Object var1, ITypeLoaderListener var2);

    public JavaFileObject produceFile(String var1, IModule var2, DiagnosticListener<JavaFileObject> var3);

    public void maybeAssignManifoldType(ClassLoader var1, String var2, URL var3, BiConsumer<String, Supplier<byte[]>> var4);

    public void performLockedOperation(ClassLoader var1, Runnable var2);

    public void initializeAndCompileNonJavaFiles(ProcessingEnvironment var1, JavaFileManager var2, List<String> var3, Supplier<Set<String>> var4, Supplier<List<String>> var5, Supplier<List<String>> var6);

    public Set<TypeName> getChildrenOfNamespace(String var1);

    public IModule getCurrentModule();

    public IFileSystem getFileSystem();
}

