/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.ElementKind;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.util.ManClassUtil;

public class SrcClass
extends SrcStatement<SrcClass> {
    private String _package;
    private List<String> _imports;
    private final Kind _kind;
    private SrcType _superClass;
    private final SrcClass _enclosingClass;
    private List<SrcType> _interfaces = new ArrayList<SrcType>();
    private List<SrcField> _fields = new ArrayList<SrcField>();
    private List<SrcField> _enumConsts = new ArrayList<SrcField>();
    private List<SrcConstructor> _constructors = new ArrayList<SrcConstructor>();
    private List<AbstractSrcMethod> _methods = new ArrayList<AbstractSrcMethod>();
    private List<SrcStatementBlock> _staticBlocks = new ArrayList<SrcStatementBlock>();
    private TreeMap<String, SrcGetProperty> _getProperties = new TreeMap();
    private TreeMap<String, SrcSetProperty> _setProperties = new TreeMap();
    private List<SrcClass> _innerClasses = new ArrayList<SrcClass>();
    private List<SrcType> _typeVars;

    public SrcClass(String fqn, Kind kind) {
        this(fqn, null, kind);
    }

    public SrcClass(String fqn, SrcClass enclosingClass, Kind kind) {
        super(enclosingClass);
        this.fullName(fqn);
        this._enclosingClass = enclosingClass;
        this._kind = kind;
        this._imports = new ArrayList<String>();
        this._typeVars = new ArrayList<SrcType>();
    }

    private SrcClass fullName(String fqn) {
        this._package = ManClassUtil.getPackage(fqn);
        return (SrcClass)this.name(ManClassUtil.getShortClassName(fqn));
    }

    public SrcClass superClass(SrcType superClass) {
        this._superClass = superClass;
        return this;
    }

    public SrcClass superClass(Class superClass) {
        this._superClass = new SrcType(superClass);
        return this;
    }

    public SrcClass superClass(String superClass) {
        this._superClass = new SrcType(superClass);
        return this;
    }

    public SrcClass addInterface(SrcType iface) {
        this._interfaces.add(iface);
        iface.setOwner(this);
        return this;
    }

    public SrcClass addInterface(Class iface) {
        SrcType t = new SrcType(iface);
        return this.addInterface(t);
    }

    public SrcClass addInterface(String iface) {
        SrcType t = new SrcType(iface);
        return this.addInterface(t);
    }

    public SrcClass addField(SrcField field) {
        this._fields.add(field);
        field.setOwner(this);
        return this;
    }

    public SrcClass addEnumConst(SrcField enumConst) {
        this._enumConsts.add(enumConst);
        enumConst.setOwner(this);
        return this;
    }

    public SrcClass addConstructor(SrcConstructor ctor) {
        this._constructors.add(ctor);
        ctor.setOwner(this);
        return this;
    }

    public SrcClass addMethod(AbstractSrcMethod method) {
        this._methods.add(method);
        method.setOwner(this);
        return this;
    }

    public SrcClass addGetProperty(SrcGetProperty property) {
        this._getProperties.put(property.getSimpleName(), property);
        property.setOwner(this);
        return this;
    }

    public SrcClass addSetProperty(SrcSetProperty property) {
        this._setProperties.put(property.getSimpleName(), property);
        property.setOwner(this);
        return this;
    }

    public SrcClass addInnerClass(SrcClass innerClass) {
        this._innerClasses.add(innerClass);
        innerClass.setOwner(this);
        return this;
    }

    public SrcClass addStaticBlock(SrcStatementBlock block) {
        this._staticBlocks.add(block);
        block.setOwner(this);
        return this;
    }

    public SrcClass imports(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this._imports.add(c.getName());
        }
        return this;
    }

    public SrcClass imports(String ... classes) {
        for (String c : classes) {
            this._imports.add(c);
        }
        return this;
    }

    public SrcClass addImport(Class cls) {
        return this.addImport(cls.getName());
    }

    public SrcClass addImport(String path) {
        this._imports.add(path);
        return this;
    }

    public SrcClass addStaticImport(String path) {
        this._imports.add(" static " + path);
        return this;
    }

    public String getPackage() {
        return this._package;
    }

    public Kind getKind() {
        return this._kind;
    }

    public SrcType getSuperClass() {
        return this._superClass;
    }

    public SrcClass getEnclosingClass() {
        return this._enclosingClass;
    }

    public List<SrcType> getInterfaces() {
        return this._interfaces;
    }

    public List<SrcField> getFields() {
        return this._fields;
    }

    public List<SrcField> getEnumConsts() {
        return this._enumConsts;
    }

    public List<SrcConstructor> getConstructors() {
        return this._constructors;
    }

    public List<AbstractSrcMethod> getMethods() {
        return this._methods;
    }

    public List<SrcStatementBlock> getStaticBlocks() {
        return this._staticBlocks;
    }

    public List<SrcClass> getInnerClasses() {
        return this._innerClasses;
    }

    public void addTypeVar(SrcType typeVar) {
        this._typeVars.add(typeVar);
    }

    public String getName() {
        return (this._package.isEmpty() ? "" : this._package + '.') + this.getSimpleName();
    }

    public boolean isInterface() {
        return this._kind == Kind.Interface;
    }

    public boolean isEnum() {
        return this._kind == Kind.Enum;
    }

    public boolean isAnnotation() {
        return this._kind == Kind.Annotation;
    }

    public List<SrcType> getTypeVariables() {
        return this._typeVars;
    }

    public StringBuilder render() {
        return this.render(0);
    }

    public StringBuilder render(int indent) {
        return this.render(new StringBuilder(), indent);
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        return this.render(sb, indent, true);
    }

    public StringBuilder render(StringBuilder sb, int indent, boolean includePackage) {
        if (includePackage) {
            this.renderPackage(sb);
        }
        if (this._kind == Kind.Enum) {
            this.renderEnum(sb, indent);
        } else if (this._kind == Kind.Annotation) {
            this.renderAnnotation(sb, indent);
        } else {
            this.renderClassOrInterface(sb, indent);
        }
        return sb;
    }

    private void renderPackage(StringBuilder sb) {
        sb.append("/* Generated */\n");
        if (!this._package.isEmpty()) {
            sb.append("package ").append(this._package).append(";\n\n");
        }
        for (String u : this._imports) {
            sb.append("import ").append(u).append(";\n");
        }
    }

    private void renderAnnotation(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, this.getModifiers() & 0xFFFFFFFFFFFFFBEFL, false, 1);
        sb.append("@interface ").append(this.getSimpleName()).append(" {\n");
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderEnum(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, this.getModifiers() & 0xFFFFFFFFFFFFFFEFL, false, 1);
        sb.append("enum ").append(this.getSimpleName()).append(this.renderClassImplements(sb)).append(" {\n");
        this.renderEnumConstants(sb, indent + 2);
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderEnumConstants(StringBuilder sb, int indent) {
        for (int i = 0; i < this._enumConsts.size(); ++i) {
            SrcField c = this._enumConsts.get(i);
            c.renderAnnotations(sb, indent, false);
            sb.append(i > 0 ? ",\n" : "").append(this.indent(sb, indent)).append(c.getSimpleName()).append(i == this._enumConsts.size() - 1 ? ";\n\n" : "");
        }
    }

    private void renderClassOrInterface(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, false, 1);
        sb.append(this._kind == Kind.Interface ? "interface " : "class ").append(this.getSimpleName()).append(this.renderTypeVars(this._typeVars, sb)).append(this.genClassExtends(sb)).append(this.renderClassImplements(sb)).append(" {\n");
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderClassFeatures(StringBuilder sb, int indent) {
        this.renderFields(sb, indent);
        this.renderConstructors(sb, indent);
        this.renderProperties(sb, indent);
        this.renderMethods(sb, indent);
        this.renderInnerClasses(sb, indent);
        this.renderStaticBlocks(sb, indent);
    }

    private String renderClassImplements(StringBuilder sb) {
        if (this._interfaces.size() == 0) {
            return "";
        }
        if (this.getKind() == Kind.Interface) {
            sb.append(" extends ");
        } else {
            sb.append(" implements ");
        }
        for (int i = 0; i < this._interfaces.size(); ++i) {
            SrcType iface = this._interfaces.get(i);
            sb.append(i > 0 ? ", " : "");
            iface.render(sb, 0);
        }
        return "";
    }

    private String genClassExtends(StringBuilder sb) {
        if (this._superClass == null) {
            return "";
        }
        sb.append(" extends ");
        this._superClass.render(sb, 0);
        return "";
    }

    private void renderFields(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// fields //\n");
        for (SrcField field : this._fields) {
            field.render(sb, indent);
        }
    }

    private void renderMethods(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// methods //\n");
        for (AbstractSrcMethod method : this._methods) {
            method.render(sb, indent);
        }
    }

    private void renderStaticBlocks(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// static blocks //\n");
        for (SrcStatementBlock block : this._staticBlocks) {
            sb.append("\n").append(this.indent(sb, indent)).append("static {");
            block.render(sb, indent);
            sb.append("\n").append(this.indent(sb, indent)).append("}");
        }
    }

    private void renderConstructors(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// constructors //\n");
        for (SrcConstructor ctor : this._constructors) {
            ctor.render(sb, indent);
        }
    }

    private void renderProperties(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// properties //\n");
        for (Map.Entry<String, SrcGetProperty> entry : this._getProperties.entrySet()) {
            entry.getValue().render(sb, indent);
            SrcSetProperty srcSetProperty = this._setProperties.get(entry.getKey());
            if (srcSetProperty != null) {
                srcSetProperty.render(sb, indent);
            }
            sb.append("\n");
        }
        for (Map.Entry<String, AbstractSrcMethod> entry : this._setProperties.entrySet()) {
            SrcGetProperty srcGetProperty = this._getProperties.get(entry.getKey());
            if (srcGetProperty != null) continue;
            ((SrcSetProperty)entry.getValue()).render(sb, indent);
        }
    }

    private void renderInnerClasses(StringBuilder sb, int indent) {
        sb.append("\n").append(this.indent(sb, indent)).append("// inner classes //\n");
        for (SrcClass innerClass : this._innerClasses) {
            innerClass.render(sb, indent, false);
        }
    }

    public static enum Kind {
        Class,
        Interface,
        Annotation,
        Enum;


        public static Kind from(ElementKind kind) {
            switch (kind) {
                case ENUM: {
                    return Enum;
                }
                case CLASS: {
                    return Class;
                }
                case ANNOTATION_TYPE: {
                    return Annotation;
                }
                case INTERFACE: {
                    return Interface;
                }
            }
            throw new IllegalArgumentException("Bad kind: " + (Object)((Object)kind));
        }
    }
}

