/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.physical;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import manifold.api.fs.IFile;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.physical.IPhysicalFileSystem;
import manifold.api.fs.physical.PhysicalResourceImpl;

public class PhysicalFileImpl
extends PhysicalResourceImpl
implements IFile {
    public PhysicalFileImpl(ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        super(path, backingFileSystem);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.toJavaFile());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.toJavaFile());
    }

    @Override
    public OutputStream openOutputStreamForAppend() throws IOException {
        return new FileOutputStream(this.toJavaFile(), true);
    }

    @Override
    public String getExtension() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(lastDot + 1);
        }
        return "";
    }

    @Override
    public String getBaseName() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(0, lastDot);
        }
        return this.getName();
    }

    @Override
    public boolean create() {
        try {
            return this.toJavaFile().createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

