/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IDirectoryUtil;
import manifold.api.fs.IFile;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.physical.IFileMetadata;
import manifold.api.fs.physical.IPhysicalFileSystem;
import manifold.api.fs.physical.PhysicalFileImpl;
import manifold.api.fs.physical.PhysicalResourceImpl;

public class PhysicalDirectoryImpl
extends PhysicalResourceImpl
implements IDirectory {
    public PhysicalDirectoryImpl(ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        super(path, backingFileSystem);
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public IDirectory dir(String relativePath) {
        ResourcePath absolutePath = this._path.join(relativePath);
        return new PhysicalDirectoryImpl(absolutePath, this._backingFileSystem);
    }

    @Override
    public IFile file(String path) {
        ResourcePath absolutePath = this._path.join(path);
        return new PhysicalFileImpl(absolutePath, this._backingFileSystem);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this._backingFileSystem.mkdir(this._path);
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<PhysicalDirectoryImpl> dirs = new ArrayList<PhysicalDirectoryImpl>();
        for (IFileMetadata iFileMetadata : this._backingFileSystem.listFiles(this._path)) {
            if (!iFileMetadata.isDir()) continue;
            dirs.add(new PhysicalDirectoryImpl(this._path.join(iFileMetadata.name()), this._backingFileSystem));
        }
        return dirs;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<PhysicalFileImpl> files = new ArrayList<PhysicalFileImpl>();
        for (IFileMetadata iFileMetadata : this._backingFileSystem.listFiles(this._path)) {
            if (!iFileMetadata.isFile()) continue;
            files.add(new PhysicalFileImpl(this._path.join(iFileMetadata.name()), this._backingFileSystem));
        }
        return files;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

