/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.jar;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarEntry;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.jar.IJarFileDirectory;
import manifold.api.fs.jar.JarFileDirectoryImpl;

public abstract class JarEntryResourceImpl
implements IResource {
    protected JarEntry _entry;
    protected IJarFileDirectory _parent;
    protected JarFileDirectoryImpl _jarFile;
    protected String _name;
    private boolean _exists = false;

    protected JarEntryResourceImpl(String name, IJarFileDirectory parent, JarFileDirectoryImpl jarFile) {
        this._name = name;
        this._parent = parent;
        this._jarFile = jarFile;
    }

    public void setEntry(JarEntry entry) {
        this._entry = entry;
        this.setExists();
    }

    protected void setExists() {
        this._exists = true;
        if (this.getParent() instanceof JarEntryResourceImpl) {
            ((JarEntryResourceImpl)((Object)this.getParent())).setExists();
        }
    }

    @Override
    public IDirectory getParent() {
        return this._parent;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean exists() {
        return this._exists;
    }

    @Override
    public boolean delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toURI() {
        try {
            return new URI("jar:" + this._jarFile.toURI().toString() + "!/" + this.getEntryName().replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getEntryName() {
        if (this._entry != null) {
            return this._entry.getName();
        }
        String result = this._name;
        IDirectory parent = this._parent;
        while (!(parent instanceof JarFileDirectoryImpl)) {
            result = parent.getName() + "/" + result;
            parent = parent.getParent();
        }
        return result;
    }

    @Override
    public ResourcePath getPath() {
        return this._parent.getPath().join(this._name);
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return dir.getPath().isDescendant(this.getPath());
    }

    @Override
    public File toJavaFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isJavaFile() {
        return false;
    }

    public String toString() {
        return this.getPath().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JarEntryResourceImpl) {
            return this.getPath().equals(((JarEntryResourceImpl)obj).getPath());
        }
        return false;
    }

    @Override
    public boolean create() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return true;
    }
}

