/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.def.JavaDirectoryImpl;
import manifold.internal.host.ManifoldHost;

public abstract class JavaResourceImpl
implements IResource,
Serializable {
    protected File _file;

    protected JavaResourceImpl(File file) {
        this._file = file.getAbsoluteFile();
    }

    @Override
    public IDirectory getParent() {
        File parentFile = this._file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return ManifoldHost.getFileSystem().getIDirectory(parentFile);
    }

    @Override
    public String getName() {
        return this._file.getName();
    }

    @Override
    public boolean delete() throws IOException {
        return this._file.delete();
    }

    @Override
    public URI toURI() {
        return this._file.toURI();
    }

    @Override
    public ResourcePath getPath() {
        return ResourcePath.parse(this._file.getAbsolutePath());
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        if (!(dir instanceof JavaDirectoryImpl)) {
            return false;
        }
        File javadir = ((JavaDirectoryImpl)dir)._file;
        for (File javafile = this._file.getParentFile(); javafile != null; javafile = javafile.getParentFile()) {
            if (!javafile.equals(javadir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public File toJavaFile() {
        return this._file;
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaResourceImpl) {
            return this._file.equals(((JavaResourceImpl)obj)._file);
        }
        return false;
    }

    public int hashCode() {
        return this._file.hashCode();
    }

    public String toString() {
        return this._file.toString();
    }

    @Override
    public boolean create() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return false;
    }
}

