/*
 * Decompiled with CFR 0.152.
 */
package com.furdei.furdroid.security.encryption;

import android.content.Context;
import com.furdei.furdroid.security.encryption.EncryptedTableSettings;
import com.furdei.furdroid.security.encryption.EncryptionSettings;
import com.furdei.furdroid.security.encryption.EncryptionSettingsProvider;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class EncryptionSettingsParser
implements EncryptionSettingsProvider {
    private XmlPullParser parser;
    private static final String ENCRYPTION_TAG = "encryption";
    private static final String TABLE_TAG = "table";
    private static final String COLUMN_TAG = "column";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ENCRYPTION_TAG_EXPECTED = "<encryption> tag is expected";
    private static final String TABLE_TAG_EXPECTED = "<table> tag is expected";
    private static final String COLUMN_TAG_EXPECTED = "<column> tag is expected";
    private static final String TABLE_MUST_HAVE_NAME = "<table> tag must have 'name' attribute";
    private static final String COLUMN_MUST_HAVE_NAME = "<column> tag must have 'name' attribute";
    private static final String NAME_IS_EMPTY = "'name' attribute is empty";

    public EncryptionSettingsParser(XmlPullParser parser) {
        this.parser = parser;
    }

    public EncryptionSettingsParser(Context context, int settingsXmlResourceId) {
        this((XmlPullParser)context.getResources().getXml(settingsXmlResourceId));
    }

    @Override
    public EncryptionSettings getEncryptionSettings() {
        try {
            HashMap<String, EncryptedTableSettings> encTables = new HashMap<String, EncryptedTableSettings>();
            boolean found = false;
            while (!found && this.parser.getEventType() != 1) {
                this.parser.next();
                found = this.parser.getEventType() == 2 && ENCRYPTION_TAG.equals(this.parser.getName());
            }
            if (!found) {
                throw new IllegalStateException(ENCRYPTION_TAG_EXPECTED);
            }
            while (this.parser.nextTag() != 3) {
                String tagName = this.parser.getName();
                if (!TABLE_TAG.equals(tagName)) {
                    throw new IllegalStateException(TABLE_TAG_EXPECTED);
                }
                int attrsCount = this.parser.getAttributeCount();
                if (attrsCount != 1) {
                    throw new IllegalStateException(TABLE_MUST_HAVE_NAME);
                }
                String attrName = this.parser.getAttributeName(0);
                if (!NAME_ATTRIBUTE.equals(attrName)) {
                    throw new IllegalStateException(TABLE_MUST_HAVE_NAME);
                }
                String tableName = this.parser.getAttributeValue(0);
                if (tableName == null || tableName.trim().length() == 0) {
                    throw new IllegalStateException(NAME_IS_EMPTY);
                }
                EncryptedTableSettings encTable = new EncryptedTableSettings(tableName);
                while (this.parser.nextTag() != 3) {
                    tagName = this.parser.getName();
                    if (!COLUMN_TAG.equals(tagName)) {
                        throw new IllegalStateException(COLUMN_TAG_EXPECTED);
                    }
                    attrsCount = this.parser.getAttributeCount();
                    if (attrsCount != 1) {
                        throw new IllegalStateException(COLUMN_MUST_HAVE_NAME);
                    }
                    attrName = this.parser.getAttributeName(0);
                    if (!NAME_ATTRIBUTE.equals(attrName)) {
                        throw new IllegalStateException(COLUMN_MUST_HAVE_NAME);
                    }
                    String name = this.parser.getAttributeValue(0);
                    if (name == null || name.trim().length() == 0) {
                        throw new IllegalStateException(NAME_IS_EMPTY);
                    }
                    encTable.markColumnEncrypted(name);
                    this.parser.nextTag();
                }
                encTables.put(tableName, encTable);
            }
            EncryptionSettings encryptionSettings = new EncryptionSettings();
            encryptionSettings.setEncryptedTables(encTables);
            return encryptionSettings;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while parsing encryption settings", e);
        }
    }
}

