/*
 * Decompiled with CFR 0.152.
 */
package com.furdei.furdroid.security.encryption;

import com.furdei.furdroid.security.encryption.EncryptionUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.crypto.Cipher;

public class EncryptedFileStorage {
    public static void write(Cipher encryptCipher, File file, byte[] rawBytes) throws IOException {
        byte[] encrypted = EncryptionUtils.encrypt(encryptCipher, rawBytes);
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(encrypted);
    }

    public static byte[] read(Cipher decryptCipher, File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(inputStream);
        byte[] encrypted = new byte[(int)file.length()];
        dis.readFully(encrypted);
        return EncryptionUtils.decrypt(decryptCipher, encrypted);
    }

    public static void write(Cipher encryptCipher, File baseDir, String fileName, byte[] rawBytes) throws IOException {
        EncryptedFileStorage.write(encryptCipher, EncryptedFileStorage.getFile(baseDir, fileName), rawBytes);
    }

    public static byte[] read(Cipher decryptCipher, File baseDir, String fileName) throws IOException {
        return EncryptedFileStorage.read(decryptCipher, EncryptedFileStorage.getFile(baseDir, fileName));
    }

    public static void writeString(Cipher encryptCipher, File baseDir, String fileName, String documentBody) throws IOException {
        EncryptedFileStorage.write(encryptCipher, baseDir, fileName, documentBody.getBytes());
    }

    public static String readString(Cipher decryptCipher, File baseDir, String fileName) throws IOException {
        return new String(EncryptedFileStorage.read(decryptCipher, baseDir, fileName));
    }

    private static File getFile(File baseDir, String fileName) {
        String baseDirPath = baseDir.getPath();
        if (!baseDirPath.endsWith("/") && !baseDirPath.endsWith("\\")) {
            baseDirPath = baseDirPath.concat("/");
        }
        return new File(baseDirPath + fileName);
    }
}

