/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.loadbalancing;

import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;

@JsonTypeName(value="tokenAware")
public class TokenAwarePolicyFactory
implements LoadBalancingPolicyFactory {
    @Valid
    @NotNull
    private LoadBalancingPolicyFactory subPolicy;
    private Boolean shuffleReplicas;

    @JsonProperty
    public LoadBalancingPolicyFactory getSubPolicy() {
        return this.subPolicy;
    }

    @JsonProperty
    public void setSubPolicy(LoadBalancingPolicyFactory subPolicy) {
        this.subPolicy = subPolicy;
    }

    @JsonProperty
    public Boolean getShuffleReplicas() {
        return this.shuffleReplicas;
    }

    @JsonProperty
    public void setShuffleReplicas(Boolean shuffleReplicas) {
        this.shuffleReplicas = shuffleReplicas;
    }

    @Override
    public LoadBalancingPolicy build() {
        return this.shuffleReplicas == null ? new TokenAwarePolicy(this.subPolicy.build()) : new TokenAwarePolicy(this.subPolicy.build(), this.shuffleReplicas.booleanValue());
    }
}

