/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import io.dropwizard.setup.Environment;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import systems.composable.dropwizard.cassandra.CassandraFactory;

class CassandraProvider {
    private final ClusterFactory clusterFactory;
    private final SessionFactory sessionFactory;

    static Binder binder(CassandraFactory cassandraFactory, Environment environment) {
        return new Binder(cassandraFactory, environment);
    }

    CassandraProvider(CassandraFactory cassandraFactory, Environment environment) {
        this.clusterFactory = new ClusterFactory(cassandraFactory.build(environment));
        this.sessionFactory = new SessionFactory(this.clusterFactory, cassandraFactory.getKeyspace());
    }

    public static class SessionFactory
    implements Factory<Session> {
        private final ClusterFactory clusterFactory;
        private final String keyspace;
        private Session session;

        SessionFactory(ClusterFactory clusterFactory, String keyspace) {
            this.clusterFactory = clusterFactory;
            this.keyspace = keyspace;
        }

        public Session provide() {
            if (this.session == null) {
                Cluster cluster = this.clusterFactory.provide();
                this.session = this.keyspace == null || this.keyspace.isEmpty() ? cluster.connect() : cluster.connect(this.keyspace);
            }
            return this.session;
        }

        public void dispose(Session session) {
            session.close();
        }
    }

    public static class ClusterFactory
    implements Factory<Cluster> {
        private final Cluster cluster;

        ClusterFactory(Cluster cluster) {
            this.cluster = cluster;
        }

        public Cluster provide() {
            return this.cluster;
        }

        public void dispose(Cluster cluster) {
            cluster.close();
        }
    }

    public static class Binder
    extends AbstractBinder {
        private final CassandraProvider cassandraProvider;

        Binder(CassandraFactory cassandraFactory, Environment environment) {
            this.cassandraProvider = new CassandraProvider(cassandraFactory, environment);
        }

        protected void configure() {
            this.bindFactory(this.cassandraProvider.clusterFactory).to(Cluster.class).in(Singleton.class);
            this.bindFactory(this.cassandraProvider.sessionFactory).to(Session.class).in(Singleton.class);
        }
    }
}

